/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.blocks.working;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import nmd.primal.core.api.PrimalAPI;
import nmd.primal.core.api.interfaces.types.ITypeNBT;
import nmd.primal.core.api.interfaces.types.ITypeWood;
import nmd.primal.core.common.blocks.AbstractBlockType;
import nmd.primal.core.common.helper.FireHelper;
import nmd.primal.core.common.helper.NBTHelper;
import nmd.primal.core.common.helper.PlayerHelper;
import nmd.primal.core.common.tiles.machines.TileAshBin;

@Deprecated
public class DustBin
extends AbstractBlockType<TileAshBin>
implements ITypeWood {
    public int PLACEMENT_RANGE = 1;

    public DustBin() {
        super(Material.field_151575_d);
        this.func_149672_a(SoundType.field_185848_a);
        this.func_149711_c(2.0f);
        this.func_149752_b(5.0f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)PrimalAPI.States.LAYERS, (Comparable)Integer.valueOf(0)));
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileAshBin();
    }

    public static int getFillLayer(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)PrimalAPI.States.LAYERS);
    }

    public static boolean canFill(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)PrimalAPI.States.LAYERS) < 15;
    }

    public static void setFillValue(World world, BlockPos pos, IBlockState state, int value) {
        world.func_175656_a(pos, state.func_177226_a((IProperty)PrimalAPI.States.LAYERS, (Comparable)Integer.valueOf(value)));
    }

    public static boolean increaseFillValue(World world, BlockPos pos, IBlockState state) {
        if (DustBin.canFill(state)) {
            DustBin.setFillValue(world, pos, state, DustBin.getFillLayer(state) + 1);
            return true;
        }
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable World player, List<String> tooltip, ITooltipFlag advanced) {
        tooltip.add(TextFormatting.GOLD + I18n.func_74838_a((String)"tooltip.info.primal.abstract_dev_warning"));
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing face, float hitX, float hitY, float hitZ) {
        if (hand == EnumHand.OFF_HAND) {
            return false;
        }
        if (world.field_72995_K) {
            return true;
        }
        TileAshBin tile = (TileAshBin)world.func_175625_s(pos);
        if (tile == null) {
            return false;
        }
        return face == tile.getFrontFace();
    }

    private boolean putStack(World world, EntityPlayer player, TileAshBin tile, ItemStack held_stack, int slot) {
        if (!held_stack.func_190926_b()) {
            ItemStack shelf_stack = tile.getStorageHandler().getStackInSlot(slot);
            int limit_stacksize = tile.getStorageHandler().getSlotLimit(slot);
            int shelf_stacksize = !shelf_stack.func_190926_b() ? shelf_stack.func_190916_E() : 0;
            int space_stacksize = shelf_stacksize < limit_stacksize ? limit_stacksize - shelf_stacksize : 0;
            int place_stacksize = held_stack.func_190916_E() >= space_stacksize ? space_stacksize : held_stack.func_190916_E();
            ItemStack place_stack = held_stack.func_77946_l();
            place_stack.func_190920_e(place_stacksize);
            if (tile.putShelfStack(slot, place_stack)) {
                int stack_size = held_stack.func_190916_E() - place_stacksize;
                if (stack_size > 0) {
                    held_stack.func_190920_e(stack_size);
                } else {
                    player.func_184611_a(EnumHand.MAIN_HAND, ItemStack.field_190927_a);
                }
                BlockPos tile_pos = tile.func_174877_v();
                SoundType soundtype = place_stack.func_77973_b() instanceof ItemBlock ? ((ItemBlock)place_stack.func_77973_b()).func_179223_d().func_185467_w() : SoundType.field_185848_a;
                world.func_184148_a(null, (double)tile_pos.func_177958_n(), (double)tile_pos.func_177956_o(), (double)tile_pos.func_177952_p(), soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
                return true;
            }
        }
        return false;
    }

    @Override
    public void dropItemsAndBlock(World world, BlockPos pos, IBlockState state) {
        TileEntity tile;
        if (!world.field_72995_K && world.func_82736_K().func_82766_b("doTileDrops") && !world.restoringBlockSnapshots && (tile = world.func_175625_s(pos)) != null && tile instanceof TileAshBin) {
            float offset = 0.7f;
            for (int i = 0; i < ((TileAshBin)tile).getStorageHandler().getSlots(); ++i) {
                ItemStack stack = ((TileAshBin)tile).getStorageHandler().getStackInSlot(i);
                if (stack.func_190926_b()) continue;
                double offsetX = (double)(RANDOM.nextFloat() * offset) + (double)(1.0f - offset) * 0.5;
                double offsetY = (double)(RANDOM.nextFloat() * offset) + (double)(1.0f - offset) * 0.5;
                double offsetZ = (double)(RANDOM.nextFloat() * offset) + (double)(1.0f - offset) * 0.5;
                EntityItem item = new EntityItem(world, (double)pos.func_177958_n() + offsetX, (double)pos.func_177956_o() + offsetY, (double)pos.func_177952_p() + offsetZ, stack);
                item.func_174869_p();
                world.func_72838_d((Entity)item);
            }
            PlayerHelper.spawnItemOnGround(world, pos, this.func_185473_a(world, pos, state));
        }
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        if (!world.field_72995_K && !willHarvest) {
            FireHelper.makeAsh(world, pos, this.PLACEMENT_RANGE, DustBin.getFillLayer(state));
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return PrimalAPI.Bounds.AABB_BARREL;
    }

    @Override
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Override
    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_185481_k(IBlockState state) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        for (ITypeWood.EnumType blocks$enumtype : ITypeWood.EnumType.values()) {
            ItemStack stack = new ItemStack((Block)this, 1, blocks$enumtype.getMetadata());
            NBTHelper.setString(stack, "type", blocks$enumtype.func_176610_l());
            list.add((Object)stack);
        }
    }

    public ItemStack func_185473_a(World world, BlockPos pos, IBlockState state) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && tile instanceof ITypeNBT) {
            ItemStack stack = new ItemStack((Block)this, 1, ITypeWood.EnumType.byName(((ITypeNBT)tile).getType()).getMetadata());
            NBTHelper.setString(stack, "type", ((ITypeNBT)tile).getType());
            return stack;
        }
        return super.func_185473_a(world, pos, state);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{TYPE, PrimalAPI.States.LAYERS});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)PrimalAPI.States.LAYERS, (Comparable)Integer.valueOf(meta));
    }

    public int func_176201_c(IBlockState state) {
        return this.getLayer(state);
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing face, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176203_a(meta);
    }

    public int getLayer(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)PrimalAPI.States.LAYERS);
    }

    private IBlockState getLayerState(int state_value) {
        return this.func_176223_P().func_177226_a((IProperty)PrimalAPI.States.LAYERS, (Comparable)Integer.valueOf(state_value));
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && tile instanceof ITypeNBT) {
            String type = ((ITypeNBT)tile).getType();
            return state.func_177226_a((IProperty)TYPE, (Comparable)((Object)ITypeWood.EnumType.byName(type)));
        }
        return state;
    }
}

