/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.blocks.saxum;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import nmd.primal.core.api.PrimalAPI;
import nmd.primal.core.api.interfaces.ISpreadBlock;
import nmd.primal.core.common.blocks.AbstractSoil;
import nmd.primal.core.common.entities.living.EntityOvisAtre;
import nmd.primal.core.common.helper.FXHelper;
import nmd.primal.core.common.helper.PlayerHelper;

public class NetherMycelium
extends AbstractSoil
implements ISpreadBlock {
    public NetherMycelium() {
        super(Material.field_151578_c, MapColor.field_151655_K, SoundType.field_185849_b, 1);
        this.func_149711_c(0.4f);
        this.func_149752_b(0.4f);
    }

    @Override
    public float getSpreadChance(World world, BlockPos pos) {
        return 0.12f;
    }

    @Override
    public IBlockState getSpreadBlock(World world, BlockPos source_pos, BlockPos spread_pos) {
        return world.func_175623_d(spread_pos.func_177984_a()) ? this.func_176223_P() : Blocks.field_150424_aL.func_176223_P();
    }

    @Override
    public boolean canSpreadTo(World world, BlockPos source_pos, BlockPos spread_pos) {
        return PrimalAPI.Predicates.SPREAD_NETHER_MYCELIUM.apply((Object)world.func_180495_p(spread_pos));
    }

    @Override
    public void onSpread(World world, BlockPos source_pos, BlockPos spread_pos) {
        FXHelper.fxOoze(world, spread_pos, 1.0f);
    }

    @Override
    public void spreadBlock(World world, BlockPos source_pos, float chance) {
        if (!world.field_72995_K && world.func_175697_a(source_pos, 3) && this.shouldSpread(world, source_pos)) {
            for (EnumFacing facing : EnumFacing.values()) {
                BlockPos spread_pos = source_pos.func_177972_a(facing);
                if (!PrimalAPI.randomCheck(chance) || !this.canSpreadTo(world, source_pos, spread_pos) || !PrimalAPI.placeScheduledBlock(world, spread_pos, this.getSpreadBlock(world, source_pos, spread_pos), 2)) continue;
                this.onSpread(world, source_pos, spread_pos);
            }
            BlockPos down = source_pos.func_177977_b();
            if (world.func_180495_p(down).func_177230_c() == Blocks.field_150424_aL) {
                for (EnumFacing facing : EnumFacing.field_176754_o) {
                    BlockPos spread_pos = down.func_177972_a(facing);
                    if (!PrimalAPI.randomCheck(chance) || !this.canSpreadTo(world, source_pos, spread_pos) || !PrimalAPI.placeScheduledBlock(world, spread_pos, this.getSpreadBlock(world, source_pos, spread_pos), 2)) continue;
                    this.onSpread(world, source_pos, spread_pos);
                }
            }
        }
    }

    public void func_176224_k(World world, BlockPos pos) {
        this.spreadBlock(world, pos, this.getSpreadChance(world, pos));
        FXHelper.fxOoze(world, pos, 1.0f);
    }

    public void func_176208_a(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        super.func_176208_a(world, pos, state, player);
        this.spreadBlock(world, pos, this.getSpreadChance(world, pos));
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        this.spreadBlock(world, pos, this.getSpreadChance(world, pos));
    }

    public void func_180658_a(World world, BlockPos pos, Entity entity, float fallDistance) {
        super.func_180658_a(world, pos, entity, fallDistance);
        this.spreadBlock(world, pos, this.getSpreadChance(world, pos) * 2.0f);
    }

    public void func_176199_a(World world, BlockPos pos, Entity entity) {
        super.func_176199_a(world, pos, entity);
        this.spreadBlock(world, pos, this.getSpreadChance(world, pos));
    }

    @Override
    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        if (entity instanceof EntityLivingBase) {
            entity.field_70143_R *= 0.85f;
            if (!PlayerHelper.isNetherCapable((EntityLivingBase)entity) && !(entity instanceof EntityOvisAtre)) {
                entity.field_70159_w *= 0.6;
                entity.field_70179_y *= 0.6;
            }
        }
    }

    @Override
    public boolean canCreatureSpawn(IBlockState state, IBlockAccess world, BlockPos pos, EntityLiving.SpawnPlacementType type) {
        return true;
    }

    @Override
    public boolean isFlammable(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return false;
    }

    @Override
    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return 0;
    }

    @Override
    public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return 0;
    }

    @Override
    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entity, boolean isActualState) {
        if (entity instanceof EntityLivingBase && !(entity instanceof EntityOvisAtre)) {
            NetherMycelium.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)PrimalAPI.Bounds.AABB_SOULSAND);
        } else {
            NetherMycelium.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)field_185505_j);
        }
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.SOLID;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        super.func_180655_c(stateIn, worldIn, pos, rand);
        if (rand.nextInt(10) == 0) {
            worldIn.func_175688_a(EnumParticleTypes.TOWN_AURA, (double)((float)pos.func_177958_n() + rand.nextFloat()), (double)((float)pos.func_177956_o() + 1.1f), (double)((float)pos.func_177952_p() + rand.nextFloat()), 0.0, 0.0, 0.0, new int[0]);
        }
    }
}

