/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.blocks.saxum;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFarmland;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import nmd.primal.core.api.PrimalAPI;
import nmd.primal.core.api.interfaces.IStackedLand;
import nmd.primal.core.common.blocks.AbstractSoil;
import nmd.primal.core.common.helper.CommonUtils;
import nmd.primal.core.common.helper.FXHelper;
import nmd.primal.core.common.helper.checks.BlockMultiplexer;

public class NetherFarmland
extends AbstractSoil {
    protected static final AxisAlignedBB field_194405_c = new AxisAlignedBB(0.0, 0.9375, 0.0, 1.0, 1.0, 1.0);

    public NetherFarmland() {
        super(Material.field_151578_c, MapColor.field_151655_K, SoundType.field_185849_b, 0);
        this.func_149675_a(true);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)PrimalAPI.States.MOISTURE, (Comparable)Integer.valueOf(0)));
    }

    private boolean hasCrops(World worldIn, BlockPos pos) {
        Block block = worldIn.func_180495_p(pos.func_177984_a()).func_177230_c();
        return block instanceof IPlantable && this.canSustainPlant(worldIn.func_180495_p(pos), (IBlockAccess)worldIn, pos, EnumFacing.UP, (IPlantable)block);
    }

    @Override
    public boolean isFertile(World world, BlockPos pos) {
        return (Integer)world.func_180495_p(pos).func_177229_b((IProperty)BlockFarmland.field_176531_a) > 0;
    }

    @Override
    public boolean canSustainPlant(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing direction, IPlantable plantable) {
        EnumPlantType plantType = plantable.getPlantType(world, pos.func_177972_a(direction));
        switch (plantType) {
            case Desert: 
            case Nether: 
            case Crop: 
            case Cave: 
            case Plains: {
                return true;
            }
        }
        return super.canSustainPlant(state, world, pos, direction, plantable);
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        int i = (Integer)state.func_177229_b((IProperty)PrimalAPI.States.MOISTURE);
        if (!CommonUtils.hasNearByMaterial((IBlockAccess)world, pos, 2, -1, Material.field_151587_i, Material.field_151581_o) && !world.func_175727_C(pos.func_177984_a())) {
            if (i > 0) {
                world.func_180501_a(pos, state.func_177226_a((IProperty)PrimalAPI.States.MOISTURE, (Comparable)Integer.valueOf(i - 1)), 2);
            } else if (!this.hasCrops(world, pos)) {
                NetherFarmland.turnToDirt(world, pos);
            }
        } else if (i < 7) {
            world.func_180501_a(pos, state.func_177226_a((IProperty)PrimalAPI.States.MOISTURE, (Comparable)Integer.valueOf(7)), 2);
        }
    }

    public void func_180658_a(World world, BlockPos pos, Entity entity, float fallDistance) {
        if (!world.field_72995_K && entity.canTrample(world, (Block)this, pos, fallDistance)) {
            NetherFarmland.turnToDirt(world, pos);
        }
        super.func_180658_a(world, pos, entity, fallDistance);
    }

    protected static void turnToDirt(World world, BlockPos worldIn) {
        world.func_175656_a(worldIn, PrimalAPI.Blocks.NETHER_EARTH.func_176223_P());
        AxisAlignedBB axisalignedbb = field_194405_c.func_186670_a(worldIn);
        for (Entity entity : world.func_72839_b((Entity)null, axisalignedbb)) {
            double d0 = Math.min(axisalignedbb.field_72337_e - axisalignedbb.field_72338_b, axisalignedbb.field_72337_e - entity.func_174813_aQ().field_72338_b);
            entity.func_70634_a(entity.field_70165_t, entity.field_70163_u + d0 + 0.001, entity.field_70161_v);
        }
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        super.func_189540_a(state, world, pos, block, fromPos);
        if (world.func_180495_p(pos.func_177984_a()).func_185904_a().func_76220_a()) {
            NetherFarmland.turnToDirt(world, pos);
        }
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return PrimalAPI.Bounds.AABB_FARMLAND;
    }

    @Override
    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entity, boolean isActualState) {
        if (entity instanceof EntityLivingBase) {
            NetherFarmland.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)PrimalAPI.Bounds.AABB_FARMLAND);
        } else {
            NetherFarmland.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)field_185505_j);
        }
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return face == EnumFacing.DOWN ? BlockFaceShape.SOLID : BlockFaceShape.UNDEFINED;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        switch (side) {
            case UP: {
                return true;
            }
            case NORTH: 
            case SOUTH: 
            case WEST: 
            case EAST: {
                IBlockState iblockstate = blockAccess.func_180495_p(pos.func_177972_a(side));
                Block block = iblockstate.func_177230_c();
                return !iblockstate.func_185914_p() && !BlockMultiplexer.forBlock(PrimalAPI.Blocks.NETHER_FARMLAND, PrimalAPI.Blocks.NETHER_PATH, PrimalAPI.Blocks.STAIRS_NETHER_PATH, PrimalAPI.Blocks.STAIRS_PATH, PrimalAPI.Blocks.LOAM_BLOCK, Blocks.field_150458_ak, Blocks.field_185774_da).apply(iblockstate) && !(block instanceof IStackedLand);
            }
        }
        return super.func_176225_a(blockState, blockAccess, pos, side);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        if ((Integer)state.func_177229_b((IProperty)PrimalAPI.States.MOISTURE) == 7 && world.func_175623_d(pos.func_177984_a())) {
            FXHelper.smokeParticles(world, pos, 2, 12, 0.92f);
        }
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        return 0;
    }

    public int getLightOpacity(IBlockState state, IBlockAccess world, BlockPos pos) {
        return (Integer)state.func_177229_b((IProperty)PrimalAPI.States.MOISTURE) == 7 ? 8 : super.getLightOpacity(state, world, pos);
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)PrimalAPI.Blocks.NETHER_EARTH);
    }

    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        return new ItemStack(PrimalAPI.Blocks.NETHER_EARTH);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{PrimalAPI.States.MOISTURE});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)PrimalAPI.States.MOISTURE, (Comparable)Integer.valueOf(meta & 7));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)PrimalAPI.States.MOISTURE);
    }
}

