/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.blocks.saxum;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import nmd.primal.core.api.PrimalAPI;
import nmd.primal.core.api.enums.EnumMoisture;
import nmd.primal.core.api.interfaces.ISpreadBlock;
import nmd.primal.core.common.blocks.AbstractSoil;
import nmd.primal.core.common.helper.FXHelper;
import nmd.primal.core.common.helper.checks.BlockMultiplexer;

public class MudWet
extends AbstractSoil
implements ISpreadBlock {
    public MudWet() {
        super(Material.field_151571_B);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(PrimalAPI.States.WET_DRY, (Comparable)((Object)EnumMoisture.WET)));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable World player, List<String> tooltip, ITooltipFlag advanced) {
        tooltip.add(TextFormatting.GREEN + I18n.func_74838_a((String)"tooltip.info.primal.mud_harvest"));
    }

    @Override
    public float getSpreadChance(World world, BlockPos pos) {
        return 0.01f;
    }

    @Override
    public IBlockState getSpreadBlock(World world, BlockPos source_pos, BlockPos spread_pos) {
        return this.func_176223_P();
    }

    @Override
    public boolean canSpreadTo(World world, BlockPos source_pos, BlockPos spread_pos) {
        return PrimalAPI.Predicates.SPREAD_MUD.apply((Object)world.func_180495_p(spread_pos));
    }

    @Override
    public void onSpread(World world, BlockPos source_pos, BlockPos spread_pos) {
        world.func_184133_a((EntityPlayer)null, spread_pos, SoundEvents.field_187587_bZ, SoundCategory.BLOCKS, 1.0f, 2.6f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.8f);
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        IBlockState neighbor = world.func_180495_p(fromPos);
        if (neighbor.func_185904_a() == Material.field_151587_i || BlockMultiplexer.forBlock(PrimalAPI.Blocks.NETHER_GROWTH).apply(neighbor)) {
            world.func_180501_a(pos, PrimalAPI.Blocks.MUD_DRIED.func_176223_P(), 2);
            FXHelper.fxLava(world, pos);
        } else {
            this.spreadBlock(world, pos, this.getSpreadChance(world, pos) * 2.0f);
        }
    }

    @Override
    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entityIn) {
        entityIn.field_70159_w *= 0.8;
        entityIn.field_70179_y *= 0.8;
    }

    @Override
    public boolean canCreatureSpawn(IBlockState state, IBlockAccess world, BlockPos pos, EntityLiving.SpawnPlacementType type) {
        return true;
    }

    @Override
    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entity, boolean isActualState) {
        if (entity instanceof EntityLivingBase) {
            MudWet.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)PrimalAPI.Bounds.AABB_SOULSAND);
        } else {
            MudWet.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)field_185505_j);
        }
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return face == EnumFacing.DOWN ? BlockFaceShape.SOLID : BlockFaceShape.UNDEFINED;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return PrimalAPI.Items.MUD_CLUMP;
    }

    public int func_149745_a(Random random) {
        return RANDOM.nextInt(3, 6);
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        ThreadLocalRandom rand = RANDOM;
        Item item = this.func_180660_a(state, rand, fortune);
        if (item != null) {
            drops.add(new ItemStack(item, 1, this.func_180651_a(state)));
        }
        return drops;
    }

    public EnumPushReaction func_149656_h(IBlockState state) {
        return EnumPushReaction.DESTROY;
    }

    @Override
    public boolean canSilkHarvest(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        return true;
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        IBlockState state = this.func_176223_P().func_177226_a(PrimalAPI.States.WET_DRY, (Comparable)((Object)EnumMoisture.WET));
        return state;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{PrimalAPI.States.WET_DRY});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(PrimalAPI.States.WET_DRY, (Comparable)((Object)EnumMoisture.byMetadata(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumMoisture)((Object)state.func_177229_b(PrimalAPI.States.WET_DRY))).getMetadata();
    }

    public boolean isWet(IBlockState state) {
        return state.func_177229_b(PrimalAPI.States.WET_DRY) == EnumMoisture.WET;
    }
}

