/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.blocks.plants.wood;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import nmd.primal.core.api.PrimalAPI;
import nmd.primal.core.common.blocks.AbstractBlock;
import nmd.primal.core.common.blocks.lighting.IgnisFatuus;
import nmd.primal.core.common.blocks.plants.wood.AbstractWood;
import nmd.primal.core.common.helper.RecipeHelper;
import nmd.primal.core.common.helper.RegistryHelper;
import nmd.primal.core.common.items.block.ItemNetherLog;

public class CoryphaStalk
extends AbstractWood {
    private String[] dictionary_names;
    public static final PropertyEnum<EnumType> TYPE = PropertyEnum.func_177709_a((String)"type", EnumType.class);

    public CoryphaStalk() {
        super(false);
        this.func_149675_a(true);
        this.func_149711_c(1.0f);
        this.func_149715_a(0.6f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(TYPE, (Comparable)((Object)EnumType.NORMAL)));
    }

    @Override
    public AbstractBlock setDictionaryNames(String ... strings) {
        this.dictionary_names = strings;
        return this;
    }

    @Override
    public String[] getDictionaryNames() {
        return this.dictionary_names;
    }

    @Override
    public void registerDictionaryNames() {
        for (EnumType blocks$enumtype : EnumType.values()) {
            for (String name : blocks$enumtype.getOreNames()) {
                RegistryHelper.registerDictionaryNames(new ItemStack((Block)this, 1, blocks$enumtype.getMetadata()), name);
            }
        }
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return PrimalAPI.Bounds.AABB_THIN_LOG;
    }

    @Override
    public PathNodeType getAiPathNodeType(IBlockState state, IBlockAccess world, BlockPos pos) {
        return PathNodeType.DAMAGE_FIRE;
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing face, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        ItemStack stack = placer.func_184586_b(hand);
        if (stack.func_77973_b() instanceof ItemNetherLog && stack.func_77960_j() > 0) {
            return this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)EnumType.STRIPPED));
        }
        return this.func_176223_P();
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        IBlockState soil = world.func_180495_p(pos.func_177977_b());
        return super.func_176196_c(world, pos) && soil.func_185904_a().func_76230_c();
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack(Item.func_150898_a((Block)this), 1, this.func_176201_c(world.func_180495_p(pos)));
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        this.liteIgnis(world, pos);
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (!this.canBlockStay(world, pos)) {
            this.douseIgnis(world, pos);
            this.dropItemBlock(world, pos, state, 0);
            world.func_175655_b(pos, false);
        }
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        this.douseIgnis(world, pos);
        return super.removedByPlayer(state, world, pos, player, willHarvest);
    }

    public boolean canBlockStay(World world, BlockPos pos) {
        return world.func_180495_p(pos.func_177977_b()).func_185904_a().func_76230_c();
    }

    private void dropItemBlock(World world, BlockPos pos, IBlockState state, int fortune) {
        this.func_180653_a(world, pos, state, 1.0f, fortune);
    }

    private void douseIgnis(World world, BlockPos pos) {
        if (world.field_72995_K) {
            return;
        }
        IBlockState state = world.func_180495_p(pos.func_177984_a());
        Block block = state.func_177230_c();
        if (block.equals(PrimalAPI.Blocks.IGNIS_FATUUS)) {
            ((IgnisFatuus)state.func_177230_c()).doExtinguish(world, pos.func_177984_a(), state, EnumFacing.UP, null);
        }
    }

    private void liteIgnis(World world, BlockPos pos) {
        if (world.field_72995_K) {
            return;
        }
        IBlockState state = world.func_180495_p(pos.func_177984_a());
        if (state.func_177230_c() != PrimalAPI.Blocks.IGNIS_FATUUS && state.func_185904_a().func_76222_j()) {
            PrimalAPI.logger(18, "corphyry", "doLite ignis: " + world.func_180495_p(pos.func_177984_a()).func_177230_c() + "@" + pos);
            RecipeHelper.changeBlock(world, pos.func_177984_a(), PrimalAPI.Blocks.IGNIS_FATUUS.func_176223_P(), 16);
        }
    }

    public int func_180651_a(IBlockState state) {
        return ((EnumType)((Object)state.func_177229_b(TYPE))).getMetadata();
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_185481_k(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return true;
    }

    public MapColor func_180659_g(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return MapColor.field_151655_K;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.MIDDLE_POLE_THIN;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{TYPE});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)EnumType.byMetadata(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumType)((Object)state.func_177229_b(TYPE))).getMetadata();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        for (EnumType blocks$enumtype : EnumType.values()) {
            list.add((Object)new ItemStack((Block)this, 1, blocks$enumtype.getMetadata()));
        }
    }

    public static enum EnumType implements IStringSerializable
    {
        NORMAL("normal", "logCorypha", "logWood"),
        STRIPPED("stripped", "logCorypha", "logStripped");

        private static final EnumType[] META_LOOKUP;
        private final String name;
        private final String[] oreNames;

        private EnumType(String name, String ... oreNames) {
            this.name = name;
            this.oreNames = oreNames;
        }

        public String func_176610_l() {
            return this.name;
        }

        public String[] getOreNames() {
            return this.oreNames;
        }

        public int getMetadata() {
            return this.ordinal();
        }

        public static EnumType byMetadata(int meta) {
            if (meta < 0 || meta >= META_LOOKUP.length) {
                meta = 0;
            }
            return META_LOOKUP[meta];
        }

        static {
            META_LOOKUP = new EnumType[EnumType.values().length];
            EnumType[] enumTypeArray = EnumType.values();
            int n = enumTypeArray.length;
            for (int i = 0; i < n; ++i) {
                EnumType blocks$enumtype;
                EnumType.META_LOOKUP[blocks$enumtype.getMetadata()] = blocks$enumtype = enumTypeArray[i];
            }
        }
    }
}

