/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.blocks.plants.wood;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import nmd.primal.core.api.PrimalAPI;
import nmd.primal.core.api.interfaces.ILit;
import nmd.primal.core.api.interfaces.types.IQuality;
import nmd.primal.core.common.blocks.plants.wood.CharcoalLogStack;
import nmd.primal.core.common.helper.FireHelper;
import nmd.primal.core.common.init.ModConfig;

public class CoryphaLogStack
extends CharcoalLogStack {
    @Override
    public int scheduledTicks(World world, BlockPos pos, IBlockState state) {
        int base;
        int time = base = ModConfig.Machines.CHARCOAL_PIT_TICK_RATE;
        time = (int)((float)time + ((float)base + (float)base * 0.85f));
        PrimalAPI.logger(7, "log stack", "time: " + time + ":" + (int)Math.floor((float)time * 0.75f));
        return RANDOM.nextInt((int)Math.floor((float)time * 0.75f), time);
    }

    @Override
    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random random) {
        if (this.shouldSchedule(world, pos, state)) {
            super.func_180650_b(world, pos, state, random);
        }
    }

    @Override
    public void func_176224_k(World world, BlockPos pos) {
        if (world.field_72995_K) {
            return;
        }
        if (this.isLit((IBlockAccess)world, pos, world.func_180495_p(pos))) {
            FireHelper.makeSmoke(world, pos, 0);
        }
    }

    @Override
    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        if (this.isLit((IBlockAccess)world, pos, state) && entity instanceof EntityLivingBase && PrimalAPI.randomCheck(50)) {
            entity.func_70015_d(RANDOM.nextInt(6, 13));
        }
    }

    @Override
    public Block getAshType(IBlockState state) {
        return PrimalAPI.Blocks.ASH_COMMON;
    }

    @Override
    public IQuality.EnumQuality getOutputQuality(IBlockState state) {
        return IQuality.EnumQuality.HIGH;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(CreativeTabs itemIn, NonNullList<ItemStack> items) {
        items.add((Object)new ItemStack((Block)this));
    }

    @Override
    public int func_180651_a(IBlockState state) {
        return 0;
    }

    @Override
    public float func_176195_g(IBlockState state, World world, BlockPos pos) {
        return 4.0f;
    }

    @Override
    public float getExplosionResistance(World world, BlockPos pos, @Nullable Entity exploder, Explosion explosion) {
        return 10.0f;
    }

    @Override
    public boolean isFlammable(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return false;
    }

    @Override
    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return 0;
    }

    @Override
    public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return 0;
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{ILit.LIT});
    }

    @Override
    public int func_176201_c(IBlockState state) {
        int meta = 0;
        if (((Boolean)state.func_177229_b((IProperty)ILit.LIT)).booleanValue()) {
            meta |= 8;
        }
        return meta;
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)ILit.LIT, (Comparable)Boolean.valueOf((meta & 8) > 0));
    }

    @Override
    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_180642_a(world, pos, facing, hitX, hitY, hitZ, meta, placer);
    }
}

