/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.blocks.plants.wood;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import nmd.primal.core.api.PrimalAPI;
import nmd.primal.core.api.interfaces.ILit;
import nmd.primal.core.api.interfaces.types.IQuality;
import nmd.primal.core.common.blocks.plants.wood.AbstractWood;
import nmd.primal.core.common.blocks.plants.wood.CharcoalLogStack;
import nmd.primal.core.common.init.ModConfig;

public class CharcoalOutput
extends AbstractWood
implements IQuality {
    public CharcoalOutput() {
        super(false);
        this.func_149713_g(0);
        this.func_149711_c(3.0f);
        this.func_149752_b(2.0f);
        this.setHarvestLevel("pickaxe", 0);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)ILit.LIT, (Comparable)Boolean.valueOf(false)).func_177226_a(IQuality.QUALITY, (Comparable)((Object)IQuality.EnumQuality.POOR)));
    }

    public static boolean isLit(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)ILit.LIT);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable World player, List<String> tooltip, ITooltipFlag advanced) {
        tooltip.add(TextFormatting.GOLD + I18n.func_74838_a((String)"tooltip.info.primal.abstract_quality"));
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        return CharcoalOutput.isLit(state) ? 10 : 0;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return PrimalAPI.Bounds.AABB_LOG_STACK;
    }

    @Override
    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entity, boolean isActualState) {
        if (entity instanceof EntityLivingBase) {
            CharcoalOutput.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)PrimalAPI.Bounds.AABB_LOG_STACK_COLLISION);
        } else {
            CharcoalOutput.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)field_185505_j);
        }
    }

    public void onNeighborChange(IBlockAccess world, BlockPos pos, BlockPos neighbor) {
    }

    public void func_176224_k(World world, BlockPos pos) {
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState state, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        CharcoalLogStack.randomDisplayFX(state, world, pos, rand);
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public EnumPushReaction func_149656_h(IBlockState state) {
        return EnumPushReaction.DESTROY;
    }

    @Override
    public boolean canSilkHarvest(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        return true;
    }

    public boolean func_149659_a(Explosion explosionIn) {
        return false;
    }

    @Override
    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        block29: {
            int amount;
            block28: {
                amount = ModConfig.Machines.CHARCOAL_PIT_OUTPUT_AMOUNT.getOutput();
                int variation = Math.max(2, (int)Math.floor((float)amount * 0.35f));
                int above = RANDOM.nextInt(variation);
                int below = RANDOM.nextInt(variation);
                PrimalAPI.logger(29, "charcoal output_items:" + amount + ":" + variation + ":" + above + ":" + below);
                if (!ModConfig.Machines.CHARCOAL_PIT_GRADES) break block28;
                switch ((IQuality.EnumQuality)((Object)state.func_177229_b((IProperty)QUALITY))) {
                    case PURE: {
                        if (below > 0) {
                            amount -= below;
                            for (int j = 0; j < below; ++j) {
                                drops.add((Object)new ItemStack(PrimalAPI.Items.CHARCOAL_HIGH));
                            }
                        }
                        for (int i = 0; i < amount; ++i) {
                            drops.add((Object)new ItemStack(PrimalAPI.Items.CHARCOAL_PURE));
                        }
                        break block29;
                    }
                    case HIGH: {
                        int i;
                        if (above > 0 && PrimalAPI.randomCheck(8)) {
                            amount -= above;
                            for (i = 0; i < above; ++i) {
                                drops.add((Object)new ItemStack(PrimalAPI.Items.CHARCOAL_PURE));
                            }
                        }
                        if (below > 0) {
                            amount -= below;
                            for (int j = 0; j < below; ++j) {
                                drops.add((Object)new ItemStack(PrimalAPI.Items.CHARCOAL_GOOD));
                            }
                        }
                        for (i = 0; i < amount; ++i) {
                            drops.add((Object)new ItemStack(PrimalAPI.Items.CHARCOAL_HIGH));
                        }
                        break block29;
                    }
                    case GOOD: {
                        int i;
                        if (above > 0) {
                            amount -= above;
                            for (i = 0; i < above; ++i) {
                                drops.add((Object)new ItemStack(PrimalAPI.Items.CHARCOAL_HIGH));
                            }
                        }
                        if (below > 0) {
                            amount -= below;
                            for (int j = 0; j < below; ++j) {
                                drops.add((Object)new ItemStack(PrimalAPI.Items.CHARCOAL_FAIR));
                            }
                        }
                        for (i = 0; i < amount; ++i) {
                            drops.add((Object)new ItemStack(PrimalAPI.Items.CHARCOAL_GOOD));
                        }
                        break block29;
                    }
                    case FAIR: {
                        int i;
                        if (above > 0) {
                            amount -= above;
                            for (i = 0; i < above; ++i) {
                                drops.add((Object)new ItemStack(PrimalAPI.Items.CHARCOAL_GOOD));
                            }
                        }
                        if (below > 0) {
                            amount -= below;
                            for (int j = 0; j < below; ++j) {
                                drops.add((Object)new ItemStack(Items.field_151044_h, 1, 1));
                            }
                        }
                        for (i = 0; i < amount; ++i) {
                            drops.add((Object)new ItemStack(PrimalAPI.Items.CHARCOAL_FAIR));
                        }
                        break block29;
                    }
                    default: {
                        int i;
                        if (above > 0) {
                            amount -= above;
                            for (i = 0; i < above; ++i) {
                                drops.add((Object)new ItemStack(PrimalAPI.Items.CHARCOAL_FAIR));
                            }
                        }
                        for (i = 0; i < amount; ++i) {
                            drops.add((Object)new ItemStack(Items.field_151044_h, 1, 1));
                        }
                        break block29;
                    }
                }
            }
            for (int i = 0; i < amount; ++i) {
                drops.add((Object)new ItemStack(Items.field_151044_h, 1, 1));
            }
        }
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing face, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a(IQuality.QUALITY, (Comparable)((Object)IQuality.EnumQuality.byMetadata(placer.func_184586_b(hand).func_77952_i())));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        this.getSubTypes(new ItemStack((Block)this).func_77973_b(), tab, list);
    }

    public int func_180651_a(IBlockState state) {
        return ((IQuality.EnumQuality)((Object)state.func_177229_b(IQuality.QUALITY))).getMetadata();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{ILit.LIT, IQuality.QUALITY});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(IQuality.QUALITY, (Comparable)((Object)IQuality.EnumQuality.byMetadata(CharcoalOutput.getModifiedMeta(meta)))).func_177226_a((IProperty)ILit.LIT, (Comparable)Boolean.valueOf((meta & 8) != 0));
    }

    public int func_176201_c(IBlockState state) {
        int meta = ((IQuality.EnumQuality)((Object)state.func_177229_b(IQuality.QUALITY))).getMetadata();
        if (((Boolean)state.func_177229_b((IProperty)ILit.LIT)).booleanValue()) {
            meta |= 8;
        }
        return meta;
    }

    public static int getModifiedMeta(int meta) {
        return meta < 8 ? meta : meta - 8;
    }
}

