/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.blocks.plants.wood;

import java.util.Arrays;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import nmd.primal.core.api.PrimalAPI;
import nmd.primal.core.api.interfaces.ILit;
import nmd.primal.core.api.interfaces.ISchedule;
import nmd.primal.core.api.interfaces.types.IQuality;
import nmd.primal.core.api.interfaces.types.ITypeLogsAll;
import nmd.primal.core.common.blocks.misc.AshLayer;
import nmd.primal.core.common.blocks.plants.wood.AbstractWood;
import nmd.primal.core.common.helper.BlockHelper;
import nmd.primal.core.common.helper.FXHelper;
import nmd.primal.core.common.helper.FireHelper;
import nmd.primal.core.common.helper.RegistryHelper;
import nmd.primal.core.common.helper.checks.BlockMultiplexer;
import nmd.primal.core.common.helper.checks.MaterialMultiplexer;
import nmd.primal.core.common.init.ModConfig;

public class CharcoalLogStack
extends AbstractWood
implements ITypeLogsAll,
ISchedule,
ILit {
    public CharcoalLogStack() {
        this.func_149713_g(0);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable World player, List<String> tooltip, ITooltipFlag advanced) {
        tooltip.add(TextFormatting.GREEN + I18n.func_74838_a((String)"tooltip.info.primal.charcoal_crafting"));
        tooltip.add(TextFormatting.BLUE + I18n.func_74838_a((String)"tooltip.info.primal.charcoal_output") + ": " + this.getOutputQuality(stack.func_77960_j()).func_176610_l());
    }

    @Override
    public PathNodeType getAiPathNodeType(IBlockState state, IBlockAccess world, BlockPos pos) {
        return this.isLit(world, pos, state) ? PathNodeType.DAMAGE_FIRE : PathNodeType.BLOCKED;
    }

    @Override
    public boolean shouldSchedule(World world, BlockPos pos, IBlockState state) {
        return !BlockHelper.hasStabilizingBlock((IBlockAccess)world, pos, EnumFacing.values());
    }

    @Override
    public boolean shouldScheduleOnPlacement() {
        return false;
    }

    @Override
    public int scheduledTicks(World world, BlockPos pos, IBlockState state) {
        int base;
        int time = base = ModConfig.Machines.CHARCOAL_PIT_TICK_RATE;
        switch (this.getOutputQuality(state)) {
            case HIGH: {
                time = (int)((float)time + ((float)base + (float)base * 0.35f));
                break;
            }
            case GOOD: {
                time = (int)((float)time + ((float)base + (float)base * 0.25f));
                break;
            }
            case FAIR: {
                time = (int)((float)time + ((float)base + (float)base * 0.15f));
                break;
            }
            default: {
                time = (int)((float)time + ((float)base + (float)base * 0.05f));
            }
        }
        PrimalAPI.logger(29, "log stack", "time: " + time + ":" + (int)Math.floor((float)time * 0.85f));
        return RANDOM.nextInt((int)Math.floor((float)time * 0.85f), time);
    }

    @Override
    public boolean canExtinguish(World world, BlockPos pos, IBlockState state, EnumFacing face, EntityLivingBase entity) {
        return entity.func_70093_af();
    }

    @Override
    public boolean doLite(World world, BlockPos pos, IBlockState state, EnumFacing face, EntityLivingBase entity) {
        if (!this.isLit((IBlockAccess)world, pos, state) && world.func_180501_a(pos, state.func_177231_a((IProperty)ILit.LIT), 2)) {
            FireHelper.makeSmoke(world, pos, 16);
            FXHelper.soundFireAmbient(world, pos, 1.0f);
            CharcoalLogStack.updateAdjacentStacks(world, pos, 260);
            return true;
        }
        return false;
    }

    @Override
    public void registerDictionaryNames() {
        for (String string : this.getDictionaryNames()) {
            RegistryHelper.registerDictionaryNames(new ItemStack((Block)this, 1, Short.MAX_VALUE), string);
        }
        for (ITypeLogsAll.EnumType enumType : ITypeLogsAll.EnumType.values()) {
            RegistryHelper.registerDictionaryNames(new ItemStack((Block)this, 1, enumType.getMetadata()), ITypeLogsAll.names_stacked[enumType.getMetadata()]);
        }
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random random) {
        if (world.field_72995_K) {
            return;
        }
        if (!this.isLit((IBlockAccess)world, pos, state)) {
            PrimalAPI.logger(29, "log stack", "lighting from adjacent stack");
            if (this.litFromAdjacentStacks(world, pos, state)) {
                PrimalAPI.logger(29, "schedule", "@" + pos + ", CharcoalLogStack#updateTick");
                this.scheduleUpdate(world, pos, state);
            }
        } else if (this.isSurrounded(world, pos, Material.field_151577_b, Material.field_151578_c, Material.field_151571_B)) {
            PrimalAPI.logger(29, "log stack", "making charcoal");
            world.func_180501_a(pos, PrimalAPI.Blocks.CHARCOAL_STACK.func_176223_P().func_177226_a((IProperty)ILit.LIT, (Comparable)Boolean.valueOf(false)).func_177226_a(IQuality.QUALITY, (Comparable)((Object)this.getOutputQuality(state))), 2);
            world.func_184133_a(null, pos, SoundEvents.field_187646_bt, SoundCategory.BLOCKS, 0.5f, RANDOM.nextFloat() * 0.4f + 0.8f);
        } else {
            PrimalAPI.logger(29, "log stack", "making ash");
            AshLayer.placeAsh(world, pos, this.getAshType(state), 3, 12);
        }
    }

    public void func_176224_k(World world, BlockPos pos) {
        if (world.field_72995_K) {
            return;
        }
        IBlockState state = world.func_180495_p(pos);
        if (this.isLit((IBlockAccess)world, pos, state)) {
            FireHelper.makeSmoke(world, pos, 0);
            world.func_175656_a(pos, this.getUnLitState(state));
        }
    }

    public IQuality.EnumQuality getOutputQuality(int meta) {
        IBlockState state = this.func_176203_a(meta);
        return this.getOutputQuality(state);
    }

    public IQuality.EnumQuality getOutputQuality(IBlockState state) {
        switch ((ITypeLogsAll.EnumType)((Object)state.func_177229_b((IProperty)TYPE))) {
            case JUNGLE: 
            case IRONWOOD: {
                return IQuality.EnumQuality.HIGH;
            }
            case SPRUCE: 
            case ACACIA: {
                return IQuality.EnumQuality.GOOD;
            }
            case OAK: 
            case DARK_OAK: {
                return IQuality.EnumQuality.FAIR;
            }
        }
        return IQuality.EnumQuality.POOR;
    }

    public Block getAshType(IBlockState state) {
        switch ((ITypeLogsAll.EnumType)((Object)state.func_177229_b((IProperty)TYPE))) {
            case IRONWOOD: {
                return PrimalAPI.Blocks.ASH_IRONWOOD;
            }
            case YEW: {
                return PrimalAPI.Blocks.ASH_YEW;
            }
        }
        return PrimalAPI.Blocks.ASH_COMMON;
    }

    public static void updateAdjacentStacks(World world, BlockPos pos, int tick_update) {
        for (EnumFacing face : EnumFacing.values()) {
            BlockPos face_position = pos.func_177972_a(face);
            IBlockState face_state = world.func_180495_p(face_position);
            if (!BlockMultiplexer.forBlock(PrimalAPI.Blocks.LOGS_STACKED, PrimalAPI.Blocks.LOGS_STACKED_CORYPHA).apply(face_state) || ((ILit)face_state.func_177230_c()).isLit((IBlockAccess)world, face_position, face_state)) continue;
            PrimalAPI.scheduleBlock(world, face_position, face_state, tick_update);
        }
    }

    public boolean litFromAdjacentStacks(World world, BlockPos pos, IBlockState state) {
        for (EnumFacing face : EnumFacing.values()) {
            BlockPos face_position = pos.func_177972_a(face);
            IBlockState face_state = world.func_180495_p(face_position);
            if (!BlockMultiplexer.forBlock(PrimalAPI.Blocks.LOGS_STACKED, PrimalAPI.Blocks.LOGS_STACKED_CORYPHA).apply(face_state) || !((ILit)face_state.func_177230_c()).isLit((IBlockAccess)world, face_position, face_state) || !world.func_180501_a(pos, ((ILit)state.func_177230_c()).getLitState(state), 2)) continue;
            CharcoalLogStack.updateAdjacentStacks(world, pos, 260);
            return true;
        }
        return false;
    }

    public boolean isSurrounded(World world, BlockPos pos, Material ... materials) {
        if (world.func_175678_i(pos)) {
            return false;
        }
        for (EnumFacing face : EnumFacing.values()) {
            IBlockState state = world.func_180495_p(pos.func_177972_a(face));
            List<Material> list = Arrays.asList(materials);
            if (PrimalAPI.Predicates.INSULATING_BLOCKS.apply((Object)state) || list.contains(state.func_185904_a())) continue;
            return false;
        }
        return true;
    }

    @Override
    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        if (this.isLit((IBlockAccess)world, pos, state) && entity instanceof EntityLivingBase && PrimalAPI.randomCheck(60)) {
            entity.func_70015_d(RANDOM.nextInt(6, 13));
        }
    }

    public boolean isLadder(IBlockState state, IBlockAccess world, BlockPos pos, EntityLivingBase entity) {
        return entity instanceof EntityPlayer;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return PrimalAPI.Bounds.AABB_LOG_STACK;
    }

    @Override
    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entity, boolean isActualState) {
        if (entity instanceof EntityLivingBase) {
            CharcoalLogStack.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)PrimalAPI.Bounds.AABB_LOG_STACK_COLLISION);
        } else {
            CharcoalLogStack.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)field_185505_j);
        }
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return face == EnumFacing.UP ? BlockFaceShape.SOLID : BlockFaceShape.UNDEFINED;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        return this.isLit(world, pos, state) ? 10 : 0;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState state, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        CharcoalLogStack.randomDisplayFX(state, world, pos, rand);
    }

    public static void randomDisplayFX(IBlockState state, World world, BlockPos pos, Random rand) {
        if (((Boolean)state.func_177229_b((IProperty)ILit.LIT)).booleanValue()) {
            double xSpeed = 0.05 - RANDOM.nextDouble(0.0, 0.1);
            double ySpeed = 0.05 - RANDOM.nextDouble(0.0, 0.1);
            IBlockState above_state = world.func_180495_p(pos.func_177984_a());
            double xOffset = (double)pos.func_177958_n() + 0.5;
            double zOffset = (double)pos.func_177952_p() + 0.5;
            double yOffset_smoke = (double)pos.func_177956_o() + (MaterialMultiplexer.forMaterial(Material.field_151578_c, Material.field_151577_b).apply(above_state) ? 1.8 : 0.8);
            double yOffset_flame = (double)pos.func_177956_o() + 0.5;
            double offsetModifier = RANDOM.nextDouble() * 0.6 - 0.3;
            double xModifier1 = xOffset + offsetModifier;
            double xModifier2 = xOffset + offsetModifier;
            double zModifier1 = zOffset + offsetModifier;
            double zModifier2 = zOffset - offsetModifier;
            if (PrimalAPI.randomCheck(0.1)) {
                world.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, SoundEvents.field_187652_bv, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
            }
            int chance = RANDOM.nextInt(1, 4);
            switch (chance) {
                case 1: {
                    xModifier1 = xOffset + offsetModifier;
                    xModifier2 = xOffset - offsetModifier;
                    zModifier1 = zOffset - offsetModifier;
                    zModifier2 = zOffset + offsetModifier;
                    break;
                }
                case 2: {
                    xModifier1 = xOffset - offsetModifier;
                    xModifier2 = xOffset - offsetModifier;
                    zModifier1 = zOffset + offsetModifier;
                    zModifier2 = zOffset - offsetModifier;
                    break;
                }
                case 3: {
                    xModifier1 = xOffset - offsetModifier;
                    xModifier2 = xOffset + offsetModifier;
                    zModifier1 = zOffset - offsetModifier;
                    zModifier2 = zOffset - offsetModifier;
                }
            }
            world.func_175688_a(EnumParticleTypes.FLAME, xModifier1, yOffset_flame, zModifier1, 0.0, 0.0, 0.0, new int[0]);
            world.func_175688_a(EnumParticleTypes.FLAME, xModifier2, yOffset_flame, zModifier2, 0.0, 0.0, 0.0, new int[0]);
            world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, xModifier1, yOffset_smoke, zModifier1, xSpeed, ySpeed, ySpeed, new int[0]);
            world.func_175688_a(EnumParticleTypes.SMOKE_LARGE, xModifier2, yOffset_smoke, zModifier2, xSpeed, ySpeed, ySpeed, new int[0]);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        this.getTypes(Item.func_150898_a((Block)this), tab, list);
    }

    public int func_180651_a(IBlockState state) {
        return ((ITypeLogsAll.EnumType)((Object)state.func_177229_b((IProperty)TYPE))).getMetadata();
    }

    public float func_176195_g(IBlockState state, World world, BlockPos pos) {
        return this.getTypeHardness((IBlockAccess)world, pos, state);
    }

    public float getExplosionResistance(World world, BlockPos pos, @Nullable Entity exploder, Explosion explosion) {
        IBlockState state = world.func_180495_p(pos);
        return this.getTypeResistance((IBlockAccess)world, pos, state);
    }

    @Override
    public boolean isFlammable(IBlockAccess world, BlockPos pos, EnumFacing face) {
        IBlockState state = world.func_180495_p(pos);
        return this.getTypeFlammability(world, pos, state) > 0;
    }

    @Override
    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        IBlockState state = world.func_180495_p(pos);
        return this.getTypeFlammability(world, pos, state);
    }

    @Override
    public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
        IBlockState state = world.func_180495_p(pos);
        return this.getTypeEncouragement(world, pos, state);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{LIT, TYPE});
    }

    public int func_176201_c(IBlockState state) {
        int meta = ((ITypeLogsAll.EnumType)((Object)state.func_177229_b((IProperty)TYPE))).getMetadata();
        if (((Boolean)state.func_177229_b((IProperty)LIT)).booleanValue()) {
            meta |= 8;
        }
        return meta;
    }

    public IBlockState func_176203_a(int meta) {
        int type = meta > 7 ? meta - 8 : meta;
        return this.func_176223_P().func_177226_a((IProperty)TYPE, (Comparable)((Object)ITypeLogsAll.EnumType.byMetadata(type))).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf((meta & 8) > 0));
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing face, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a((IProperty)TYPE, (Comparable)((Object)ITypeLogsAll.EnumType.byMetadata(placer.func_184586_b(hand).func_77952_i())));
    }
}

