/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.blocks.plants.thatch;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSlime;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityMagmaCube;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import nmd.primal.core.api.PrimalAPI;
import nmd.primal.core.common.blocks.parts.SlabFull;
import nmd.primal.core.common.blocks.plants.thatch.Thatch;
import nmd.primal.core.common.entities.living.EntityOvisAtre;
import nmd.primal.core.common.helper.PlayerHelper;
import nmd.primal.core.common.helper.RecipeHelper;
import nmd.primal.core.common.init.ModConfig;

public class ThatchNether
extends Thatch {
    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag advanced) {
        super.func_190948_a(stack, world, tooltip, advanced);
        tooltip.add(TextFormatting.GREEN + I18n.func_74838_a((String)"tooltip.info.primal.thatch_support"));
        tooltip.add(TextFormatting.GREEN + I18n.func_74838_a((String)"tooltip.info.primal.cineris_carpet"));
        tooltip.add(TextFormatting.GOLD + I18n.func_74838_a((String)"tooltip.info.primal.abstract_environment"));
    }

    @Override
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return this.isFull(state) ? PrimalAPI.Bounds.AABB_SOULSAND : (state.func_177229_b((IProperty)HALF) == SlabFull.EnumSlab.TOP ? PrimalAPI.Bounds.AABB_SLAB_TOP_SHALLOW : PrimalAPI.Bounds.AABB_SLAB_BOTTOM_SHALLOW);
    }

    public static MapColor getBlockMapColor() {
        return MapColor.field_151646_E;
    }

    @Override
    public boolean canCreatureSpawn(IBlockState state, IBlockAccess world, BlockPos pos, EntityLiving.SpawnPlacementType type) {
        return true;
    }

    @Override
    public boolean canPlaceTorchOnTop(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }

    @Override
    public boolean isFlammable(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return false;
    }

    @Override
    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return 0;
    }

    @Override
    public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return 0;
    }

    private double getSpeed(World world, BlockPos pos) {
        double[] speeds = ModConfig.Plants.CINERIS_CARPET_SPEED_MODIFIERS;
        IBlockState base_state = world.func_180495_p(pos.func_177977_b());
        Block base_block = base_state.func_177230_c();
        if (base_block instanceof BlockSlime) {
            return speeds[0];
        }
        if (base_block == Blocks.field_150339_S || RecipeHelper.isOreName(base_block, "blockCopper", "blockTin")) {
            return speeds[2];
        }
        if (PrimalAPI.Predicates.LOOTING_2_BLOCKS.apply((Object)base_state)) {
            return speeds[3];
        }
        if (PrimalAPI.Predicates.LOOTING_3_BLOCKS.apply((Object)base_state)) {
            return speeds[4];
        }
        return speeds[1];
    }

    private void collideWithCineris(World world, BlockPos pos, IBlockState state, Entity entity) {
        if (entity instanceof EntityLivingBase && entity.field_70122_E && !(entity instanceof EntityOvisAtre) && !(entity instanceof EntityMagmaCube) && !PlayerHelper.isNetherCapable((EntityLivingBase)entity) || entity instanceof EntityItem) {
            double factor = this.getSpeed(world, pos);
            double movement = (double)RANDOM.nextFloat() * factor;
            double x = 0.0;
            double z = 0.0;
            EnumFacing facing = this.getFacing(state);
            switch (facing) {
                case NORTH: {
                    z = entity.func_70093_af() ? -movement : movement;
                    break;
                }
                case SOUTH: {
                    z = entity.func_70093_af() ? movement : -movement;
                    break;
                }
                case EAST: {
                    x = entity.func_70093_af() ? movement : -movement;
                    break;
                }
                case WEST: {
                    x = entity.func_70093_af() ? -movement : movement;
                    break;
                }
                default: {
                    x += (double)RANDOM.nextFloat() * factor - (double)RANDOM.nextFloat() * factor;
                    z += (double)RANDOM.nextFloat() * factor - (double)RANDOM.nextFloat() * factor;
                }
            }
            entity.func_70024_g(x, 0.0, z);
        }
    }

    @Override
    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        this.collideWithCineris(world, pos, state, entity);
    }

    @Override
    public void func_176216_a(World world, Entity entity) {
        if (entity.func_70093_af()) {
            super.func_176216_a(world, entity);
        } else if (entity.field_70181_x < 0.0 && this.hasSupport(world, entity.func_180425_c(), 2)) {
            entity.field_70181_x = -entity.field_70181_x * 0.5600000262260437;
            if (!(entity instanceof EntityLivingBase)) {
                entity.field_70181_x *= 0.6;
            }
        }
    }

    @Override
    public void func_180653_a(World world, BlockPos pos, IBlockState state, float chance, int fortune) {
        if (!world.field_72995_K && !world.restoringBlockSnapshots) {
            int i;
            int amount;
            int n = amount = this.isFull(state) ? 2 : 0;
            if (PrimalAPI.randomCheck(4 - amount)) {
                for (i = 0; i < RANDOM.nextInt(1 + amount); ++i) {
                    ThatchNether.func_180635_a((World)world, (BlockPos)pos, (ItemStack)new ItemStack(PrimalAPI.Items.CINERIS_FIBER));
                }
            }
            for (i = 0; i < 2 + amount; ++i) {
                ThatchNether.func_180635_a((World)world, (BlockPos)pos, (ItemStack)new ItemStack(PrimalAPI.Items.THATCHING_NETHER));
            }
        }
    }

    @Override
    public boolean func_149659_a(Explosion explosionIn) {
        return true;
    }

    @Override
    public EnumPushReaction func_149656_h(IBlockState state) {
        return EnumPushReaction.DESTROY;
    }
}

