/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.blocks.plants.thatch;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemHandlerHelper;
import nmd.primal.core.api.PrimalAPI;
import nmd.primal.core.api.interfaces.IFace;
import nmd.primal.core.api.interfaces.IPickup;
import nmd.primal.core.common.blocks.parts.SlabFull;
import nmd.primal.core.common.blocks.parts.Slats;
import nmd.primal.core.common.entities.projectiles.TypeArrow;
import nmd.primal.core.common.init.ModConfig;
import nmd.primal.core.common.items.projectiles.Arrow;

public class Thatch
extends SlabFull
implements IFace,
IPickup {
    public Thatch() {
        super(PrimalAPI.Blocks.THATCH_WET.func_176223_P(), MapColor.field_151673_t, 1, true);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag advanced) {
        super.func_190948_a(stack, world, tooltip, advanced);
        tooltip.add(TextFormatting.GREEN + I18n.func_74838_a((String)"tooltip.info.primal.thatch_support"));
        tooltip.add(TextFormatting.GOLD + I18n.func_74838_a((String)"tooltip.info.primal.abstract_fire_hazard"));
    }

    @Override
    public boolean canCreatureSpawn(IBlockState state, IBlockAccess world, BlockPos pos, EntityLiving.SpawnPlacementType type) {
        return false;
    }

    public boolean canPlaceTorchOnTop(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }

    @Override
    public boolean isFlammable(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return ModConfig.Flammability.THATCH_BURN_CHANCE > 0;
    }

    @Override
    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return ModConfig.Flammability.THATCH_BURN_CHANCE;
    }

    @Override
    public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return ModConfig.Flammability.THATCH_BURN_CHANCE;
    }

    @Override
    public boolean doPickup(World world, BlockPos pos, IBlockState state, EnumFacing face, EntityPlayer player, EnumHand hand) {
        if (world.field_72995_K) {
            return true;
        }
        if (world.func_175656_a(pos, this.getReplacementBlock(world, pos, state))) {
            ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)new ItemStack(Item.func_150898_a((Block)state.func_177230_c()), this.isFull(state) ? 2 : 1));
            return true;
        }
        return false;
    }

    @Override
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return this.isFull(state) ? PrimalAPI.Bounds.AABB_SOULSAND : (state.func_177229_b((IProperty)HALF) == SlabFull.EnumSlab.TOP ? PrimalAPI.Bounds.AABB_SLAB_TOP : PrimalAPI.Bounds.AABB_SLAB_BOTTOM);
    }

    public int func_149738_a(World worldIn) {
        return 2;
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos) {
        world.func_175684_a(pos, (Block)this, this.func_149738_a(world));
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (!world.field_72995_K) {
            this.destroyThatch(world, pos, 6);
        }
    }

    @Override
    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        if (ModConfig.Flammability.THATCH_BURN_CHANCE > 0 && PrimalAPI.randomCheck(16) && entity.func_70027_ad() && world.func_175623_d(pos.func_177984_a())) {
            world.func_180501_a(pos.func_177984_a(), Blocks.field_150480_ab.func_176223_P(), 2);
            if (entity instanceof TypeArrow && ((TypeArrow)entity).matchType(Arrow.Type.TORCH_WOOD, Arrow.Type.TORCH_NETHER)) {
                entity.func_70106_y();
            }
        }
    }

    public void func_176199_a(World world, BlockPos pos, Entity entity) {
        if (!world.field_72995_K && entity instanceof EntityLivingBase && (entity instanceof EntityPlayer || world.func_82736_K().func_82766_b("mobGriefing")) && entity.field_70130_N * entity.field_70130_N * entity.field_70131_O > 0.512f) {
            this.destroyThatch(world, pos, 3);
        }
    }

    public void func_176216_a(World world, Entity entity) {
        if (entity.func_70093_af()) {
            super.func_176216_a(world, entity);
        } else if (entity.field_70181_x < 0.0 && this.hasSupport(world, entity.func_180425_c(), 2)) {
            entity.field_70181_x = -entity.field_70181_x * (double)0.66f;
            if (!(entity instanceof EntityLivingBase)) {
                entity.field_70181_x *= 0.8;
            }
        }
    }

    public boolean hasSupport(World world, BlockPos pos, int range) {
        if (!world.func_175623_d(pos.func_177977_b())) {
            return true;
        }
        for (BlockPos.MutableBlockPos blockpos$mutableblockpos : BlockPos.func_177975_b((BlockPos)pos.func_177982_a(-range, -1, -range), (BlockPos)pos.func_177982_a(range, 0, range))) {
            if (!(world.func_180495_p((BlockPos)blockpos$mutableblockpos).func_177230_c() instanceof Slats)) continue;
            return true;
        }
        return false;
    }

    private void destroyThatch(World world, BlockPos pos, int chance) {
        if (PrimalAPI.randomCheck(chance) && !world.func_180495_p(pos.func_177977_b()).func_185904_a().func_76230_c() && !this.hasSupport(world, pos, 2)) {
            world.func_175655_b(pos, true);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        if (this.isWet(world, pos) && !world.func_180495_p(pos.func_177977_b()).func_185896_q() && PrimalAPI.randomCheck(40)) {
            double d0 = (float)pos.func_177958_n() + rand.nextFloat();
            double d1 = (double)pos.func_177956_o() - 0.05;
            double d2 = (float)pos.func_177952_p() + rand.nextFloat();
            world.func_175688_a(EnumParticleTypes.DRIP_WATER, d0, d1, d2, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(World world, BlockPos pos, ParticleManager manager) {
        this.thatchParticles(world, pos, 8, 0.9);
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    protected static boolean isHalfSlab(IBlockState state) {
        return true;
    }

    public void thatchParticles(World world, BlockPos pos, int amount, double y_offset) {
        EnumParticleTypes particles = EnumParticleTypes.CLOUD;
        for (int i = 0; i <= amount; ++i) {
            world.func_175688_a(particles, (double)pos.func_177958_n() + RANDOM.nextDouble(), (double)pos.func_177956_o() + y_offset, (double)pos.func_177952_p() + RANDOM.nextDouble(), (Math.random() - 0.5) / 10.0, (Math.random() - 0.5) / 10.0, (Math.random() - 0.5) / 10.0, new int[0]);
        }
    }

    public void func_180653_a(World world, BlockPos pos, IBlockState state, float chance, int fortune) {
        if (!world.field_72995_K && !world.restoringBlockSnapshots) {
            int i;
            int amount;
            int n = amount = this.isFull(state) ? 2 : 0;
            if (PrimalAPI.randomCheck(4 - amount)) {
                for (i = 0; i < RANDOM.nextInt(1 + amount); ++i) {
                    Thatch.func_180635_a((World)world, (BlockPos)pos, (ItemStack)new ItemStack(PrimalAPI.Items.PLANT_FIBER));
                }
            }
            for (i = 0; i < 2 + amount; ++i) {
                Thatch.func_180635_a((World)world, (BlockPos)pos, (ItemStack)new ItemStack(PrimalAPI.Items.THATCHING_DRY));
            }
        }
    }

    public boolean func_149659_a(Explosion explosionIn) {
        return false;
    }

    public EnumPushReaction func_149656_h(IBlockState state) {
        return EnumPushReaction.DESTROY;
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{IFace.FACING, HALF});
    }

    @Override
    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing face, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        IBlockState state = this.func_176223_P().func_177226_a((IProperty)HALF, (Comparable)((Object)SlabFull.EnumSlab.BOTTOM)).func_177226_a((IProperty)IFace.FACING, (Comparable)this.getPlacementFacing(placer));
        return this.isFull(state) ? state : (face != EnumFacing.DOWN && (face == EnumFacing.UP || (double)hitY <= 0.5) ? state : state.func_177226_a((IProperty)HALF, (Comparable)((Object)SlabFull.EnumSlab.TOP)));
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)HALF, (Comparable)((Object)SlabFull.EnumSlab.byMetadata(meta))).func_177226_a((IProperty)FACING, (Comparable)this.getHorizontalFacingFromIndex(this.getFacingIndexFromMeta(meta)));
    }

    @Override
    public int func_176201_c(IBlockState state) {
        return SlabFull.EnumSlab.getIndex(state) + this.getHorizontalIndexFromState(state);
    }
}

