/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.blocks.plants.crops;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFarmland;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import nmd.primal.core.api.PrimalAPI;
import nmd.primal.core.api.interfaces.ISchedule;
import nmd.primal.core.api.interfaces.plants.IHarvest;
import nmd.primal.core.api.interfaces.plants.IPrimalPlants;
import nmd.primal.core.common.blocks.plants.AbstractPlantGrowing;
import nmd.primal.core.common.helper.CommonUtils;
import nmd.primal.core.common.helper.checks.BlockMultiplexer;
import nmd.primal.core.common.init.ModConfig;

public class Corn
extends AbstractPlantGrowing
implements IHarvest,
ISchedule {
    @Override
    public boolean shouldSchedule(World world, BlockPos pos, IBlockState state) {
        return !this.isBlooming(state) && !CommonUtils.isValueMatch(this.getAge(state), 4);
    }

    @Override
    public boolean shouldScheduleOnPlacement() {
        return true;
    }

    @Override
    public int scheduledTicks(World world, BlockPos pos, IBlockState state) {
        return RANDOM.nextInt(ModConfig.Plants.PLANT_BASE_TICK_RATE / 2, ModConfig.Plants.PLANT_BASE_TICK_RATE);
    }

    @Override
    public IPrimalPlants.EnumType getType(IBlockState state) {
        return IPrimalPlants.EnumType.NORMAL;
    }

    @Override
    public ItemStack getStalk(IBlockState state) {
        return new ItemStack(PrimalAPI.Items.CORN_STALK_WET);
    }

    @Override
    public ItemStack getSeed(IBlockState state) {
        return new ItemStack(PrimalAPI.Items.CORN_SEEDS);
    }

    @Override
    public ItemStack getCrop(IBlockState state) {
        return new ItemStack(PrimalAPI.Items.CORN_COB);
    }

    @Override
    public int getMaxHeight() {
        return 3;
    }

    @Override
    public boolean isMature(IBlockState state) {
        PrimalAPI.logger(8, "corn", "is mature: " + (this.getAge(state) == 4) + ", " + (this.getAge(state) == 6) + ", " + (this.getAge(state) == 7));
        return CommonUtils.isValueMatch(this.getAge(state), 4, 6, 7);
    }

    @Override
    public boolean canBloom(World world, BlockPos pos, IBlockState state) {
        PrimalAPI.logger(8, "can bloom", "blooming: " + this.isBlooming(state) + ", age is correct: " + CommonUtils.isValueMatch(this.getAge(state), 6, 7));
        return !this.isBlooming(state) && CommonUtils.isValueMatch(this.getAge(state), 6, 7);
    }

    @Override
    public void growFullPlant(World world, BlockPos pos, IBlockState state, int update_flag) {
        super.growFullPlant(world, pos, state, update_flag);
        if (this.isValidSoil((IBlockAccess)world, pos.func_177977_b())) {
            world.func_180501_a(pos, this.getAgedPlant(state, 4), update_flag);
            world.func_180501_a(pos.func_177984_a(), this.getBloomingPlant(state, 6, world.field_73012_v.nextBoolean()), update_flag);
            world.func_180501_a(pos.func_177981_b(2), this.getBloomingPlant(state, 7, world.field_73012_v.nextBoolean()), update_flag);
        }
    }

    @Override
    public float getGrowChance(World world, BlockPos pos, IBlockState state) {
        return super.getGrowChance(world, pos, state);
    }

    @Override
    public float getBloomChance(World world, BlockPos pos, IBlockState state) {
        return 0.45f;
    }

    @Override
    public int harvestAmount() {
        return RANDOM.nextInt(1, 3);
    }

    @Override
    public boolean canHarvest(IBlockState state) {
        return this.isBlooming(state);
    }

    @Override
    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        int age = this.getAge(world.func_180495_p(pos));
        if (age > 3) {
            entity.field_70159_w *= 0.66;
            entity.field_70179_y *= 0.66;
        }
    }

    @Override
    public boolean canBlockStay(World world, BlockPos pos, IBlockState state) {
        IBlockState soil = this.getSoil((IBlockAccess)world, pos);
        if (state.func_177230_c() == this && this.getAge(state) < 4) {
            return (world.func_175699_k(pos) >= 8 || world.func_175678_i(pos)) && this.canSustainPlant(soil, (IBlockAccess)world, pos.func_177977_b(), EnumFacing.UP, this);
        }
        return this.canSustainPlant(soil, (IBlockAccess)world, pos.func_177977_b(), EnumFacing.UP, this);
    }

    @Override
    public boolean canSustainPlant(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing direction, IPlantable plantable) {
        IBlockState plant_state = plantable.getPlant(world, pos.func_177972_a(direction));
        Block soil = state.func_177230_c();
        if (plantable == this) {
            int age = this.getAge(plant_state);
            if (age > 3) {
                return soil == this || this.isValidSoil(world, pos);
            }
            return soil instanceof BlockFarmland || BlockMultiplexer.forBlock(PrimalAPI.Blocks.NETHER_FARMLAND).apply(state);
        }
        return super.canSustainPlant(state, world, pos.func_177977_b(), direction, plantable);
    }

    @Override
    public boolean isValidSoil(IBlockAccess world, BlockPos pos) {
        return PrimalAPI.Predicates.SOIL_SURFACE_COMMON.apply((Object)world.func_180495_p(pos));
    }

    @Override
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return null;
    }

    @Override
    public int func_149745_a(Random random) {
        return 0;
    }

    public void func_180653_a(World world, BlockPos pos, IBlockState state, float chance, int fortune) {
        if (!world.field_72995_K && !world.restoringBlockSnapshots) {
            if (this.getAge(state) == 4) {
                Corn.func_180635_a((World)world, (BlockPos)pos, (ItemStack)this.getStalk(state));
            }
            if (this.getAge(state) > 5) {
                Corn.func_180635_a((World)world, (BlockPos)pos, (ItemStack)this.getStalk(state));
                if (this.isBlooming(state)) {
                    Corn.func_180635_a((World)world, (BlockPos)pos, (ItemStack)this.getCrop(state));
                }
            }
        }
    }
}

