/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.blocks.plants;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import nmd.primal.core.api.PrimalAPI;
import nmd.primal.core.api.interfaces.plants.IPrimalPlants;
import nmd.primal.core.common.blocks.AbstractBlock;

public abstract class AbstractPlant
extends AbstractBlock
implements IPrimalPlants,
IPlantable {
    public AbstractPlant(Material material, MapColor mapcolor) {
        super(material, mapcolor);
        this.func_149672_a(SoundType.field_185850_c);
        this.func_149711_c(0.4f);
        this.func_149752_b(0.0f);
        this.func_149675_a(false);
    }

    public AbstractPlant(Material material) {
        this(material, material.func_151565_r());
    }

    public AbstractPlant(MapColor mapcolor) {
        this(Material.field_151585_k, mapcolor);
    }

    public AbstractPlant() {
        this(Material.field_151585_k, Material.field_151585_k.func_151565_r());
    }

    public boolean canPlantAt(World world, BlockPos pos) {
        if (this.isValidSoil((IBlockAccess)world, pos.func_177977_b())) {
            for (int i = 0; i < this.getMaxHeight(); ++i) {
                if (world.func_175623_d(pos.func_177981_b(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean canFitHeight(World world, BlockPos pos) {
        for (int i = 0; i < this.getMaxHeight(); ++i) {
            if (world.func_175623_d(pos.func_177981_b(i))) continue;
            return false;
        }
        return true;
    }

    public boolean canBlockStay(World world, BlockPos pos, IBlockState state) {
        return this.canSustainPlant(this.getSoil((IBlockAccess)world, pos), (IBlockAccess)world, pos.func_177977_b(), EnumFacing.UP, this);
    }

    @Override
    public ItemStack getStalk(IBlockState state) {
        return ItemStack.field_190927_a;
    }

    @Override
    public ItemStack getSeed(IBlockState state) {
        return ItemStack.field_190927_a;
    }

    @Override
    public ItemStack getCrop(IBlockState state) {
        return ItemStack.field_190927_a;
    }

    @Override
    public int getMaxHeight() {
        return 1;
    }

    @Override
    public boolean isBlooming(IBlockState state) {
        return state.func_177230_c() instanceof IPrimalPlants && (Boolean)state.func_177229_b((IProperty)PLANT_BLOOM) != false;
    }

    @Override
    public void growFullPlant(World world, BlockPos pos, IBlockState state, int update_flag) {
        if (world.field_72995_K) {
            return;
        }
        for (int i = 0; i <= ((IPrimalPlants)state.func_177230_c()).getMaxHeight(); ++i) {
            IBlockState up = world.func_180495_p(pos.func_177981_b(i));
            if (up.func_185904_a().func_76222_j()) continue;
            return;
        }
    }

    @Override
    public void updatePlant(World world, BlockPos pos, IBlockState state, Random rand, int age) {
    }

    public IBlockState getPlant(IBlockAccess world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() != this) {
            return this.func_176223_P();
        }
        return state;
    }

    public EnumPlantType getPlantType(IBlockAccess world, BlockPos pos) {
        if (this == PrimalAPI.Blocks.CORN_STALK) {
            return EnumPlantType.Plains;
        }
        return EnumPlantType.Plains;
    }

    @Override
    public boolean func_176200_f(IBlockAccess world, BlockPos pos) {
        return false;
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        return this.canBlockStay(world, pos, world.func_180495_p(pos));
    }

    @Override
    public boolean canSustainPlant(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing direction, IPlantable plantable) {
        return this.isValidSoil(world, pos);
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        super.func_189540_a(state, world, pos, block, fromPos);
        this.checkForDrop(world, pos, state);
    }

    protected boolean func_149700_E() {
        return false;
    }

    public boolean func_149659_a(Explosion explosionIn) {
        return false;
    }

    public EnumPushReaction func_149656_h(IBlockState state) {
        return EnumPushReaction.DESTROY;
    }

    private boolean checkForDrop(World world, BlockPos pos, IBlockState state) {
        if (this.canBlockStay(world, pos, state)) {
            return true;
        }
        this.func_176226_b(world, pos, state, 0);
        world.func_175698_g(pos);
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return PrimalAPI.Bounds.AABB_BUSH;
    }

    public AxisAlignedBB func_180646_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return field_185506_k;
    }

    public BlockFaceShape func_193383_a(IBlockAccess p_193383_1_, IBlockState p_193383_2_, BlockPos p_193383_3_, EnumFacing p_193383_4_) {
        return BlockFaceShape.UNDEFINED;
    }
}

