/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.blocks.parts;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import nmd.primal.core.api.PrimalAPI;
import nmd.primal.core.common.blocks.AbstractSubBlock;

public class SlabFull
extends AbstractSubBlock {
    public static final PropertyEnum<EnumSlab> HALF = PropertyEnum.func_177709_a((String)"half", EnumSlab.class);

    public SlabFull(IBlockState state, MapColor map_color, int opacity, boolean has_facing) {
        super(state, map_color);
        this.func_149713_g(opacity);
    }

    public SlabFull(IBlockState state) {
        this(state, state.func_185904_a().func_151565_r(), 8, false);
    }

    public SlabFull(IBlockState state, int opacity) {
        this(state, state.func_185904_a().func_151565_r(), opacity, false);
    }

    public SlabFull(IBlockState state, boolean has_facing) {
        this(state, state.func_185904_a().func_151565_r(), 8, has_facing);
    }

    public SlabFull(IBlockState state, MapColor map_color) {
        this(state, map_color, 8, false);
    }

    public int getFacingIndexFromMeta(int meta) {
        int modifier = meta < 4 ? 0 : (meta < 8 ? 4 : 8);
        return meta - modifier;
    }

    public boolean isFull(IBlockState state) {
        return state.func_177229_b(HALF) == EnumSlab.FULL;
    }

    public boolean isTop(IBlockState state) {
        return state.func_177229_b(HALF) == EnumSlab.TOP;
    }

    public boolean isBottom(IBlockState state) {
        return state.func_177229_b(HALF) == EnumSlab.BOTTOM;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing face, float hitX, float hitY, float hitZ) {
        ItemStack heldItem = player.func_184586_b(hand);
        if (!heldItem.func_190926_b() && (state.func_177229_b(HALF) == EnumSlab.TOP && face == EnumFacing.DOWN || state.func_177229_b(HALF) == EnumSlab.BOTTOM && face == EnumFacing.UP) && heldItem.func_77973_b() == Item.func_150898_a((Block)this)) {
            world.func_180501_a(pos, state.func_177226_a(HALF, (Comparable)((Object)EnumSlab.FULL)), 2);
            if (!player.field_71075_bZ.field_75098_d) {
                heldItem.func_190918_g(1);
            }
            SoundType soundtype = this.func_185467_w();
            world.func_184133_a(player, pos, soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
            return true;
        }
        return super.func_180639_a(world, pos, state, player, hand, face, hitX, hitY, hitZ);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return this.isFull(state) ? field_185505_j : (state.func_177229_b(HALF) == EnumSlab.TOP ? PrimalAPI.Bounds.AABB_SLAB_TOP : PrimalAPI.Bounds.AABB_SLAB_BOTTOM);
    }

    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing facing) {
        if (this.isFull(state)) {
            return BlockFaceShape.SOLID;
        }
        if (facing == EnumFacing.UP && this.isTop(state)) {
            return BlockFaceShape.SOLID;
        }
        return facing == EnumFacing.DOWN && this.isBottom(state) ? BlockFaceShape.SOLID : BlockFaceShape.UNDEFINED;
    }

    public boolean func_185481_k(IBlockState state) {
        return this.isFull(state) || this.isTop(state);
    }

    public boolean func_149662_c(IBlockState state) {
        return this.isFull(state);
    }

    public boolean func_149686_d(IBlockState state) {
        return this.isFull(state);
    }

    public boolean doesSideBlockRendering(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing face) {
        if (this.getParentMaterial() == Material.field_151592_s) {
            return false;
        }
        if (ForgeModContainer.disableStairSlabCulling) {
            return super.doesSideBlockRendering(state, world, pos, face);
        }
        if (state.func_185914_p() || this.isFull(state)) {
            return true;
        }
        EnumSlab side = (EnumSlab)((Object)state.func_177229_b(HALF));
        return side == EnumSlab.TOP && face == EnumFacing.UP || side == EnumSlab.BOTTOM && face == EnumFacing.DOWN;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        if (this.field_149764_J == Material.field_151592_s) {
            IBlockState neighbor_state = world.func_180495_p(pos.func_177972_a(side));
            return state != neighbor_state;
        }
        if (this.isFull(state)) {
            return super.func_176225_a(state, world, pos, side);
        }
        if (side != EnumFacing.UP && side != EnumFacing.DOWN && !super.func_176225_a(state, world, pos, side)) {
            return false;
        }
        return super.func_176225_a(state, world, pos, side);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        if (this.getParentMaterial() == Material.field_151577_b && this.isWet(world, pos) && !world.func_180495_p(pos.func_177977_b()).func_185896_q() && PrimalAPI.randomCheck(15)) {
            double x = (float)pos.func_177958_n() + rand.nextFloat();
            double y = this.isTop(state) ? (double)pos.func_177956_o() + 0.0012 : (double)pos.func_177956_o() - 0.05;
            double z = (float)pos.func_177952_p() + rand.nextFloat();
            world.func_175688_a(EnumParticleTypes.DRIP_WATER, x, y, z, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected static boolean isHalfSlab(IBlockState state) {
        Block block = state.func_177230_c();
        return block == Blocks.field_150333_U || block == Blocks.field_150376_bx || block == Blocks.field_180389_cP || block == Blocks.field_185771_cX;
    }

    @Override
    protected boolean func_149700_E() {
        return false;
    }

    public int quantityDropped(IBlockState state, int fortune, Random random) {
        return this.isFull(state) ? 2 : 1;
    }

    @Override
    public int getLightOpacity(IBlockState state, IBlockAccess world, BlockPos pos) {
        return this.isFull(state) ? 255 : this.func_149717_k(state);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{HALF});
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing face, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        IBlockState state = this.func_176223_P().func_177226_a(HALF, (Comparable)((Object)EnumSlab.BOTTOM));
        return this.isFull(state) ? state : (face != EnumFacing.DOWN && (face == EnumFacing.UP || (double)hitY <= 0.5) ? state : state.func_177226_a(HALF, (Comparable)((Object)EnumSlab.TOP)));
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(HALF, (Comparable)((Object)EnumSlab.byMetadata(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return EnumSlab.getIndex(state);
    }

    public static enum EnumSlab implements IStringSerializable
    {
        BOTTOM("bottom"),
        TOP("top"),
        FULL("full");

        private final String name;
        private static int index;

        private EnumSlab(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public String func_176610_l() {
            return this.name;
        }

        public static int getIndex(IBlockState state) {
            EnumSlab type = (EnumSlab)((Object)state.func_177229_b(HALF));
            return type == TOP ? 4 : (type.equals((Object)FULL) ? 8 : 0);
        }

        public static EnumSlab byMetadata(int meta) {
            index = meta > 3 && meta < 8 ? 1 : (meta > 7 ? 2 : 0);
            return EnumSlab.values()[index];
        }
    }
}

