/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.blocks.ores;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import nmd.primal.core.api.PrimalAPI;
import nmd.primal.core.common.blocks.AbstractBlock;
import nmd.primal.core.common.compat.ModLoot;
import nmd.primal.core.common.helper.FXHelper;

public class AncientIce
extends AbstractBlock {
    public AncientIce() {
        super(Material.field_151598_x, MapColor.field_151670_w);
        this.func_149711_c(10.0f);
        this.func_149752_b(10.0f);
        this.setHarvestLevel("pickaxe", 2);
        this.field_149765_K = 0.98f;
    }

    public SoundType getSoundType(IBlockState state, World world, BlockPos pos, @Nullable Entity entity) {
        return PrimalAPI.Sounds.ICE;
    }

    @Override
    public boolean canCreatureSpawn(IBlockState state, IBlockAccess world, BlockPos pos, EntityLiving.SpawnPlacementType type) {
        return true;
    }

    @Override
    public boolean isFlammable(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return false;
    }

    @Override
    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return 0;
    }

    @Override
    public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return 0;
    }

    public void func_180649_a(World world, BlockPos pos, EntityPlayer player) {
        if (world.field_72995_K) {
            return;
        }
        if (PrimalAPI.randomCheck(3)) {
            FXHelper.fxIce(world, pos, 1.0f);
        }
    }

    public void func_180658_a(World world, BlockPos pos, Entity entity, float fallDistance) {
        super.func_180658_a(world, pos, entity, fallDistance);
        FXHelper.fxIce(world, pos, 1.0f);
        if (entity.func_70027_ad()) {
            entity.func_70066_B();
        }
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        IBlockState neighbor = world.func_180495_p(fromPos);
        if (neighbor.func_177230_c() != this) {
            Material material = neighbor.func_185904_a();
            if (neighbor.func_177230_c() == PrimalAPI.Fluids.OVIS_ATRE_MILK.getBlock()) {
                world.func_180501_a(fromPos, PrimalAPI.Blocks.DESICCATED_STONE.func_176223_P(), 2);
                FXHelper.fxLava(world, fromPos);
            } else if (neighbor.func_177230_c() == PrimalAPI.Fluids.MAGMA.getBlock()) {
                world.func_180501_a(fromPos, PrimalAPI.Blocks.SARSEN_STONE.func_176223_P(), 2);
                FXHelper.fxLava(world, fromPos);
            } else if (neighbor.func_177230_c() == PrimalAPI.Fluids.PARAFFIN.getBlock()) {
                world.func_180501_a(fromPos, PrimalAPI.Blocks.PORPHYRY_STONE.func_176223_P(), 2);
                FXHelper.fxLava(world, fromPos);
            } else if (material == Material.field_151587_i) {
                world.func_180501_a(fromPos, Blocks.field_150347_e.func_176223_P(), 2);
                FXHelper.fxLava(world, fromPos);
            } else if (material == Material.field_151586_h) {
                this.packAdjacentIce(world, pos, world.func_180494_b(pos).func_150561_m() == Biome.TempCategory.COLD ? 0.45f : 0.25f);
                FXHelper.fxIce(world, fromPos, 1.5f);
                world.func_180501_a(fromPos, Blocks.field_150432_aD.func_176223_P(), 2);
            }
        }
    }

    private void packAdjacentIce(World world, BlockPos pos, float chance) {
        if (PrimalAPI.randomCheck(chance)) {
            for (EnumFacing facing : EnumFacing.values()) {
                BlockPos pos_offset = pos.func_177972_a(facing);
                IBlockState state = world.func_180495_p(pos_offset);
                Block block = state.func_177230_c();
                if (block != Blocks.field_150432_aD) continue;
                world.func_180501_a(pos_offset, Blocks.field_150403_cj.func_176223_P(), 2);
            }
        }
    }

    public static ItemStack getLootDrop(World world) {
        LootContext.Builder lootcontext$builder = new LootContext.Builder((WorldServer)world);
        List loot = world.func_184146_ak().func_186521_a(ModLoot.MISC_ANCIENT_ICE).func_186462_a((Random)RANDOM, lootcontext$builder.func_186471_a());
        return loot.size() > 0 ? ((ItemStack)loot.get(RANDOM.nextInt(loot.size()))).func_77946_l() : ItemStack.field_190927_a;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        super.func_180655_c(state, world, pos, rand);
        if (rand.nextInt(16) == 0) {
            world.func_175688_a(EnumParticleTypes.CLOUD, (double)((float)pos.func_177958_n() + rand.nextFloat()), (double)((float)pos.func_177956_o() + 1.1f), (double)((float)pos.func_177952_p() + rand.nextFloat()), 0.0, 0.0, 0.0, new int[0]);
        }
    }
}

