/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.blocks.ores;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import nmd.primal.core.api.PrimalAPI;
import nmd.primal.core.common.blocks.AbstractBlock;

public abstract class AbstractOre
extends AbstractBlock {
    public AbstractOre(Material material, SoundType sound_type, String tool_class, int tool_level) {
        super(material);
        this.func_149672_a(sound_type);
        this.setHarvestLevel(tool_class, tool_level);
    }

    public ItemStack getSecondaryItem(IBlockState state, Random rand, int fortune) {
        return ItemStack.field_190927_a;
    }

    public int quantitySecondary(Random random) {
        return 0;
    }

    public EnumPushReaction func_149656_h(IBlockState state) {
        return EnumPushReaction.NORMAL;
    }

    @Override
    public boolean canSilkHarvest(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        return true;
    }

    public int func_149745_a(Random random) {
        return this == Blocks.field_150369_x ? 4 + random.nextInt(5) : 1;
    }

    @Override
    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        int ore_count = this.quantityDropped(state, fortune, RANDOM);
        for (int i = 0; i < ore_count; ++i) {
            Item item = this.func_180660_a(state, RANDOM, fortune);
            if (item == Items.field_190931_a) continue;
            drops.add((Object)new ItemStack(item, 1, this.func_180651_a(state)));
        }
        int secondary_count = this.quantityDropped(state, fortune, RANDOM);
        for (int i = 0; i < secondary_count; ++i) {
            ItemStack second = this.getSecondaryItem(state, RANDOM, fortune);
            if (second.func_190926_b()) continue;
            drops.add((Object)second);
        }
    }

    public int getExpDrop(IBlockState state, IBlockAccess world, BlockPos pos, int fortune) {
        if (this.func_180660_a(state, RANDOM, fortune) != Item.func_150898_a((Block)this)) {
            if (this == PrimalAPI.Blocks.MUD_WET || this == PrimalAPI.Blocks.TERRA_BLOCK || this == PrimalAPI.Blocks.CINIS_BLOCK) {
                return 0;
            }
            if (this == PrimalAPI.Blocks.ORE_SALT || this == PrimalAPI.Blocks.ORE_SALT_FLAT) {
                return MathHelper.func_76136_a((Random)RANDOM, (int)0, (int)2);
            }
            if (this == PrimalAPI.Blocks.CALCIFIED_PARAFFIN) {
                return MathHelper.func_76136_a((Random)RANDOM, (int)0, (int)1);
            }
            if (this == PrimalAPI.Blocks.ORE_BOG_IRON) {
                return MathHelper.func_76136_a((Random)RANDOM, (int)2, (int)5);
            }
            if (this == PrimalAPI.Blocks.ORE_MAGNETITE) {
                return MathHelper.func_76136_a((Random)RANDOM, (int)3, (int)7);
            }
            if (this == PrimalAPI.Blocks.ORE_OPAL) {
                return MathHelper.func_76136_a((Random)RANDOM, (int)3, (int)7);
            }
        }
        return 0;
    }

    @Override
    public boolean canCreatureSpawn(IBlockState state, IBlockAccess world, BlockPos pos, EntityLiving.SpawnPlacementType type) {
        return true;
    }
}

