/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.blocks.misc;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import nmd.primal.core.api.PrimalAPI;
import nmd.primal.core.common.blocks.AbstractFace;
import nmd.primal.core.common.blocks.misc.WattleDaubHelper;
import nmd.primal.core.common.helper.CommonUtils;
import nmd.primal.core.common.helper.PlayerHelper;
import nmd.primal.core.common.helper.RecipeHelper;

public class WattleDaubOld
extends AbstractFace {
    private WattleDaubHelper.EnumWattle wattle;
    private WattleDaubHelper.EnumDaub daub;

    public WattleDaubOld(WattleDaubHelper.EnumWattle wattle_type, WattleDaubHelper.EnumDaub daub_color, MapColor map_color) {
        super(Material.field_151578_c, map_color);
        this.func_149672_a(SoundType.field_185849_b);
        this.setHarvestLevel("pickaxe", 0);
        this.func_149711_c(2.0f);
        this.func_149752_b(5.0f);
        this.func_149713_g(1);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)PrimalAPI.States.DAUB, (Comparable)Integer.valueOf(0)));
        this.wattle = wattle_type;
        this.daub = daub_color;
    }

    public WattleDaubOld(WattleDaubHelper.EnumWattle wattle_type, WattleDaubHelper.EnumDaub daub_color) {
        this(wattle_type, daub_color, MapColor.field_151650_B);
    }

    public WattleDaubOld(WattleDaubHelper.EnumWattle wattle_type) {
        this(wattle_type, WattleDaubHelper.EnumDaub.BASIC, MapColor.field_151650_B);
    }

    public int getDaubLevel(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)PrimalAPI.States.DAUB);
    }

    public boolean isFull(IBlockState state) {
        return this.getDaubLevel(state) == 3;
    }

    public WattleDaubHelper.EnumWattle getWattle() {
        return this.wattle;
    }

    public WattleDaubHelper.EnumDaub getDaub() {
        return this.daub;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing face, float hitX, float hitY, float hitZ) {
        ItemStack stack;
        if (!world.field_72995_K && !this.isFull(state) && !(stack = player.func_184586_b(hand)).func_190926_b() && RecipeHelper.isOreName(stack, WattleDaubHelper.EnumDaub.getDaubNameFromType(this.daub))) {
            world.func_180501_a(pos, state.func_177226_a((IProperty)PrimalAPI.States.DAUB, (Comparable)Integer.valueOf(this.getDaubLevel(state) + 1)), 3);
            stack.func_190918_g(1);
            return true;
        }
        return false;
    }

    public boolean isSideSolid(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        if (this.isFull(state) || side == EnumFacing.UP) {
            return true;
        }
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        switch (facing) {
            case NORTH: 
            case SOUTH: {
                return side == EnumFacing.EAST || side == EnumFacing.WEST;
            }
            case EAST: 
            case WEST: {
                return side == EnumFacing.NORTH || side == EnumFacing.SOUTH;
            }
        }
        return false;
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        this.func_176208_a(world, pos, state, player);
        if (this.getDaubLevel(state) > 0) {
            return world.func_180501_a(pos, this.func_176223_P().func_177226_a((IProperty)PrimalAPI.States.DAUB, (Comparable)Integer.valueOf(this.getDaubLevel(state) - 1)).func_177226_a((IProperty)FACING, state.func_177229_b((IProperty)FACING)), CommonUtils.updateFlag(world));
        }
        return world.func_180501_a(pos, WattleDaubHelper.EnumWattle.getType(this.wattle).func_177226_a((IProperty)FACING, state.func_177229_b((IProperty)FACING)), CommonUtils.updateFlag(world));
    }

    public void func_176208_a(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        if (!world.field_72995_K) {
            PlayerHelper.spawnItemOnPlayer(world, player, WattleDaubHelper.EnumDaub.getDaubStack(this.daub));
        }
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return null;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        int daub = this.getDaubLevel(state);
        switch ((EnumFacing)state.func_177229_b((IProperty)FACING)) {
            case NORTH: 
            case SOUTH: {
                return daub == 1 ? PrimalAPI.Bounds.AABB_DAUB_1_NORTH : (daub == 2 ? PrimalAPI.Bounds.AABB_DAUB_2_NORTH : (daub == 3 ? PrimalAPI.Bounds.AABB_DAUB_3_NORTH : PrimalAPI.Bounds.AABB_WATTLE_NORTH));
            }
        }
        return daub == 1 ? PrimalAPI.Bounds.AABB_DAUB_1_EAST : (daub == 2 ? PrimalAPI.Bounds.AABB_DAUB_2_EAST : (daub == 3 ? PrimalAPI.Bounds.AABB_DAUB_3_EAST : PrimalAPI.Bounds.AABB_WATTLE_EAST));
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState state, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return true;
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{PrimalAPI.States.DAUB, FACING});
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)PrimalAPI.States.DAUB, (Comparable)Integer.valueOf(this.getDaubFromMeta(meta))).func_177226_a((IProperty)FACING, (Comparable)this.getHorizontalFacingFromIndex(this.getFacingIndexFromMeta(meta)));
    }

    @Override
    public int func_176201_c(IBlockState state) {
        int meta = this.getHorizontalIndexFromState(state);
        int daub = this.getDaubLevel(state);
        switch (daub) {
            case 1: {
                return meta |= 4;
            }
            case 2: {
                return meta |= 8;
            }
            case 3: {
                return meta |= 0xC;
            }
        }
        return meta;
    }

    private int getDaubFromMeta(int meta) {
        return meta > 3 && meta < 8 ? 1 : (meta > 7 && meta < 12 ? 2 : (meta > 11 ? 3 : 0));
    }
}

