/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.blocks.misc;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import nmd.primal.core.api.PrimalAPI;
import nmd.primal.core.api.interfaces.IStackedLand;
import nmd.primal.core.common.blocks.AbstractFalling;
import nmd.primal.core.common.helper.CommonUtils;
import nmd.primal.core.common.helper.FXHelper;

public class AtreWool
extends AbstractFalling
implements IStackedLand {
    public AtreWool() {
        super(Material.field_151580_n, MapColor.field_151646_E);
        this.func_149711_c(0.8f);
        this.func_149752_b(0.0f);
        this.func_149672_a(SoundType.field_185854_g);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)STACKED, (Comparable)Boolean.valueOf(false)));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable World player, List<String> tooltip, ITooltipFlag advanced) {
        tooltip.add(TextFormatting.GOLD + I18n.func_74838_a((String)"tooltip.info.primal.abstract_fall_protection"));
    }

    public boolean canCreatureSpawn(IBlockState state, IBlockAccess world, BlockPos pos, EntityLiving.SpawnPlacementType type) {
        return false;
    }

    public boolean isFlammable(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return false;
    }

    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return 0;
    }

    public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return 0;
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        AtreWool.tryAbsorb(worldIn, pos, state);
        super.func_176213_c(worldIn, pos, state);
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (PrimalAPI.randomCheck(6)) {
            AtreWool.tryAbsorb(worldIn, pos, state);
        }
        super.func_189540_a(state, worldIn, pos, blockIn, fromPos);
    }

    public static void tryAbsorb(World worldIn, BlockPos pos, IBlockState state) {
        if (AtreWool.absorb(worldIn, pos)) {
            FXHelper.fxLava(worldIn, pos);
        }
    }

    public static boolean absorb(World worldIn, BlockPos pos) {
        LinkedList queue = Lists.newLinkedList();
        ArrayList list = Lists.newArrayList();
        queue.add(new Tuple((Object)pos, (Object)0));
        int i = 0;
        while (!queue.isEmpty()) {
            Tuple tuple = (Tuple)queue.poll();
            BlockPos blockpos = (BlockPos)tuple.func_76341_a();
            int j = (Integer)tuple.func_76340_b();
            for (EnumFacing enumfacing : EnumFacing.values()) {
                BlockPos blockpos1 = blockpos.func_177972_a(enumfacing);
                if (worldIn.func_180495_p(blockpos1).func_185904_a() != Material.field_151586_h) continue;
                worldIn.func_180501_a(blockpos1, Blocks.field_150350_a.func_176223_P(), 2);
                list.add(blockpos1);
                ++i;
                if (j >= 6) continue;
                queue.add(new Tuple((Object)blockpos1, (Object)(j + 1)));
            }
            if (i <= 64) continue;
            break;
        }
        for (BlockPos blockpos2 : list) {
            worldIn.func_175685_c(blockpos2, Blocks.field_150350_a, false);
        }
        return i > 0;
    }

    public void func_180658_a(World world, BlockPos pos, Entity entity, float fallDistance) {
        if (entity.func_70093_af()) {
            super.func_180658_a(world, pos, entity, fallDistance);
        } else {
            entity.func_180430_e(fallDistance, 0.0f);
        }
    }

    public void func_176216_a(World worldIn, Entity entity) {
        if (entity.func_70093_af()) {
            super.func_176216_a(worldIn, entity);
        } else if (entity.field_70181_x < 0.0) {
            entity.field_70181_x = -entity.field_70181_x * (double)0.66f;
            if (!(entity instanceof EntityLivingBase)) {
                entity.field_70181_x *= 0.8;
            }
        }
    }

    public static boolean canFallThrough(IBlockState state) {
        Block block = state.func_177230_c();
        Material material = state.func_185904_a();
        return block == Blocks.field_150480_ab || material == Material.field_151579_a || material == Material.field_151586_h || material == Material.field_151587_i;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return this.canConnectTo(source, pos.func_177984_a()) ? field_185505_j : PrimalAPI.Bounds.AABB_FARMLAND;
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entity, boolean isActualState) {
        if (entity instanceof EntityLivingBase) {
            AtreWool.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)PrimalAPI.Bounds.AABB_FARMLAND);
        } else {
            AtreWool.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)field_185505_j);
        }
    }

    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing face) {
        return face == EnumFacing.UP && (Boolean)this.func_176221_a(state, world, pos).func_177229_b((IProperty)STACKED) == false ? BlockFaceShape.UNDEFINED : BlockFaceShape.SOLID;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        switch (side) {
            case UP: {
                return !this.canConnectTo(world, pos.func_177984_a());
            }
            case DOWN: 
            case NORTH: 
            case SOUTH: 
            case WEST: 
            case EAST: {
                IBlockState neighbor_state = world.func_180495_p(pos.func_177972_a(side));
                Block block = neighbor_state.func_177230_c();
                return !neighbor_state.func_185914_p() && (!(block instanceof IStackedLand) || this.canConnectTo(world, pos.func_177984_a()) && !this.canConnectTo(world, pos.func_177972_a(side).func_177984_a()));
            }
        }
        return super.func_176225_a(state, world, pos, side);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World world, BlockPos pos, Random rand) {
        super.func_180655_c(stateIn, world, pos, rand);
        if (world.func_175623_d(pos.func_177984_a()) && CommonUtils.isExposedToSun(world, pos.func_177984_a())) {
            FXHelper.smokeParticles(world, pos, 4, 6, 0.92f);
        }
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{STACKED});
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return state.func_177226_a((IProperty)STACKED, (Comparable)Boolean.valueOf(this.canConnectTo(world, pos.func_177984_a())));
    }
}

