/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.blocks.misc;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockTrapDoor;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import nmd.primal.core.api.PrimalAPI;
import nmd.primal.core.common.blocks.AbstractFalling;
import nmd.primal.core.common.blocks.parts.SlabHalf;
import nmd.primal.core.common.blocks.parts.SmokeGrate;
import nmd.primal.core.common.blocks.parts.ThinSlab;
import nmd.primal.core.common.blocks.plants.wood.CharcoalLogStack;
import nmd.primal.core.common.blocks.plants.wood.CharcoalOutput;
import nmd.primal.core.common.entities.EntityFallingAsh;
import nmd.primal.core.common.helper.FXHelper;
import nmd.primal.core.common.helper.FireHelper;

public class AshLayer
extends AbstractFalling {
    private static final int PLACEMENT_RANGE = 1;
    private static final int RAIN_DECAY_RATE = 16;

    public AshLayer() {
        super(Material.field_151595_p, MapColor.field_151670_w);
        this.func_149672_a(SoundType.field_185854_g);
        this.func_149711_c(0.1f);
        this.func_149752_b(0.0f);
        this.setHarvestLevel("shovel", 0);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)PrimalAPI.States.LAYERS, (Comparable)Integer.valueOf(0)));
    }

    public static void placeAsh(World world, BlockPos pos, Block placed_block, int min, int max) {
        if (world.field_72995_K) {
            return;
        }
        IBlockState placed_state = placed_block.func_176223_P();
        IBlockState ground_state = world.func_180495_p(pos.func_177977_b());
        Block ground_block = ground_state.func_177230_c();
        int addingLayers = RANDOM.nextInt(min, max);
        if (ground_block instanceof AshLayer) {
            int groundLayers;
            PrimalAPI.logger(2, "ash place", "layers: " + addingLayers + " : " + groundLayers);
            if (groundLayers < 15) {
                for (groundLayers = ((AshLayer)ground_block).getLayer(ground_state); groundLayers < 15 && addingLayers >= 0; ++groundLayers, --addingLayers) {
                }
                PrimalAPI.logger(2, "ash place", "post-loop layers: " + addingLayers + ", entities layers: " + groundLayers);
                if (groundLayers >= 0 && groundLayers <= 15) {
                    world.func_180501_a(pos.func_177977_b(), ((AshLayer)ground_block).getLayerState(groundLayers), 3);
                }
            }
        }
        if (addingLayers >= 0 && addingLayers <= 15) {
            world.func_180501_a(pos, ((AshLayer)placed_state.func_177230_c()).getLayerState(addingLayers), 3);
        }
        world.func_184133_a((EntityPlayer)null, pos, SoundEvents.field_187552_ah, SoundCategory.BLOCKS, 0.5f, RANDOM.nextFloat() * 0.4f + 0.8f);
    }

    public static void spreadAsh(World world, BlockPos pos) {
        IBlockState fall_state = world.func_180495_p(pos);
        Block fall_block = fall_state.func_177230_c();
        PrimalAPI.logger(2, "spread ash", "block: " + fall_block + ", " + pos);
        if (fall_block instanceof AshLayer) {
            PrimalAPI.logger(2, "spread ash", "Spread Valid");
            FireHelper.makeAsh(world, pos, 1, ((AshLayer)fall_block).getLayer(fall_state), fall_block);
        }
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (!worldIn.field_72995_K) {
            this.checkFallable(worldIn, pos);
        }
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        super.func_189540_a(state, world, pos, block, fromPos);
        if (world.field_72995_K) {
            return;
        }
        IBlockState ground_state = world.func_180495_p(pos.func_177977_b());
        Block ground_block = ground_state.func_177230_c();
        if (ground_block == this) {
            int addingLayers;
            int groundLayers = this.getLayer(ground_state);
            PrimalAPI.logger(2, "ash update", "layers: " + addingLayers + ": " + groundLayers + " @" + pos);
            if (groundLayers < 15) {
                for (addingLayers = this.getLayer(state); groundLayers < 15 && addingLayers >= 0; ++groundLayers, --addingLayers) {
                }
                PrimalAPI.logger(2, "ash update", "post-loop layers: " + addingLayers + ", entities layers: " + groundLayers);
                if (groundLayers >= 0 && groundLayers <= 15) {
                    world.func_180501_a(pos.func_177977_b(), ground_state.func_177226_a((IProperty)PrimalAPI.States.LAYERS, (Comparable)Integer.valueOf(groundLayers)), 3);
                }
                if (addingLayers >= 0 && addingLayers <= 15) {
                    world.func_180501_a(pos, state.func_177226_a((IProperty)PrimalAPI.States.LAYERS, (Comparable)Integer.valueOf(addingLayers)), 3);
                } else {
                    world.func_175698_g(pos);
                }
            }
        }
    }

    private void checkFallable(World world, BlockPos pos) {
        if ((world.func_175623_d(pos.func_177977_b()) || AshLayer.canFallThrough(world.func_180495_p(pos.func_177977_b()))) && pos.func_177956_o() >= 0) {
            if (!field_149832_M && world.func_175707_a(pos.func_177982_a(-32, -32, -32), pos.func_177982_a(32, 32, 32))) {
                if (!world.field_72995_K) {
                    EntityFallingAsh fallingBlock = new EntityFallingAsh(world, (double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, world.func_180495_p(pos));
                    this.func_149829_a(fallingBlock);
                    world.func_72838_d((Entity)fallingBlock);
                }
            } else {
                IBlockState state = world.func_180495_p(pos);
                world.func_175698_g(pos);
                BlockPos blockpos = pos.func_177977_b();
                while ((world.func_175623_d(blockpos) || AshLayer.canFallThrough(world.func_180495_p(blockpos))) && blockpos.func_177956_o() > 0) {
                    blockpos = blockpos.func_177977_b();
                }
                if (blockpos.func_177956_o() > 0) {
                    world.func_175656_a(blockpos.func_177984_a(), state);
                }
            }
        }
    }

    public static boolean canFallThrough(IBlockState state) {
        Material material = state.func_185904_a();
        return material == Material.field_151579_a;
    }

    public void func_176224_k(World world, BlockPos pos) {
        if (world.field_72995_K) {
            return;
        }
        PrimalAPI.logger(2, "Ash", "rain check");
        if (PrimalAPI.randomCheck(16)) {
            PrimalAPI.logger(2, "Ash", "is dissolving");
            int layers = this.getLayer(world.func_180495_p(pos));
            if (layers > 0) {
                world.func_180501_a(pos, this.getLayerState(--layers), 2);
            } else {
                world.func_175698_g(pos);
            }
        }
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        IBlockState state_base = world.func_180495_p(pos.func_177977_b());
        Block block_base = state_base.func_177230_c();
        AxisAlignedBB aabb = state_base.func_185900_c((IBlockAccess)world, pos);
        return state_base.func_177230_c().isLeaves(state_base, (IBlockAccess)world, pos.func_177977_b()) || block_base instanceof AshLayer && (Integer)state_base.func_177229_b((IProperty)PrimalAPI.States.LAYERS) == 15 || block_base instanceof CharcoalLogStack || block_base instanceof CharcoalOutput || block_base instanceof SmokeGrate && state_base.func_177229_b((IProperty)ThinSlab.HALF) == SlabHalf.EnumSlab.TOP || block_base instanceof BlockTrapDoor && state_base.func_177229_b((IProperty)BlockTrapDoor.field_176285_M) == BlockTrapDoor.DoorHalf.TOP || aabb == field_185505_j && state_base.func_185904_a().func_76230_c();
    }

    public static boolean canReplaceBlock(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        Material material = state.func_185904_a();
        boolean fire = material == Material.field_151581_o;
        return world.func_175623_d(pos) || block.func_176200_f((IBlockAccess)world, pos) && !fire && !material.func_76224_d() || fire && world.func_175623_d(pos.func_177984_a());
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)this);
    }

    public int quantityDropped(IBlockState state, int fortune, Random random) {
        return 1 + this.getLayer(state);
    }

    @Override
    public boolean func_176200_f(IBlockAccess world, BlockPos pos) {
        return this.getLayer(world.func_180495_p(pos)) == 0;
    }

    public EnumPushReaction func_149656_h(IBlockState state) {
        return EnumPushReaction.DESTROY;
    }

    public boolean canSilkHarvest(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        return true;
    }

    public void func_185477_a(IBlockState state, World world, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entity, boolean p_185477_7_) {
        if (this.getLayer(state) > 1) {
            super.func_185477_a(state, world, pos, entityBox, collidingBoxes, entity, p_185477_7_);
        }
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return PrimalAPI.Bounds.AABB_LAYERS[this.getLayer(state)];
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return PrimalAPI.Bounds.AABB_LAYERS[this.getLayer(state)];
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return face == EnumFacing.DOWN ? BlockFaceShape.SOLID : BlockFaceShape.UNDEFINED;
    }

    public boolean func_185481_k(IBlockState state) {
        return this.getLayer(state) == 15;
    }

    public boolean func_149662_c(IBlockState state) {
        return this.getLayer(state) == 15;
    }

    public boolean func_149686_d(IBlockState state) {
        return this.getLayer(state) == 15;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState state, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        if (side == EnumFacing.UP) {
            return true;
        }
        IBlockState iblockstate = blockAccess.func_180495_p(pos.func_177972_a(side));
        return (iblockstate.func_177230_c() != this || this.getLayer(iblockstate) < this.getLayer(state)) && super.func_176225_a(state, blockAccess, pos, side);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(IBlockState state, World world, RayTraceResult target, ParticleManager manager) {
        if (PrimalAPI.randomCheck(3)) {
            BlockPos pos = target.func_178782_a();
            int amount = this.getLayer(state);
            double y_offset = (double)(amount + 2) / 10.0;
            FXHelper.smokeParticles(world, pos, amount, 0, y_offset);
        }
        return true;
    }

    public int getLightOpacity(IBlockState state, IBlockAccess world, BlockPos pos) {
        return 1 + this.getLayer(state);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int func_189876_x(IBlockState state) {
        return -16777216;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{PrimalAPI.States.LAYERS});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)PrimalAPI.States.LAYERS, (Comparable)Integer.valueOf(meta));
    }

    public int func_176201_c(IBlockState state) {
        return this.getLayer(state);
    }

    public int getLayer(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)PrimalAPI.States.LAYERS);
    }

    private IBlockState getLayerState(int state_value) {
        return this.func_176223_P().func_177226_a((IProperty)PrimalAPI.States.LAYERS, (Comparable)Integer.valueOf(state_value));
    }
}

