/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.blocks.machines;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import nmd.primal.core.api.interfaces.types.ITypeNBT;
import nmd.primal.core.api.interfaces.types.ITypeWood;
import nmd.primal.core.common.PrimalCore;
import nmd.primal.core.common.blocks.AbstractWorkTable;
import nmd.primal.core.common.helper.CommonUtils;
import nmd.primal.core.common.helper.NBTHelper;
import nmd.primal.core.common.helper.PlayerHelper;
import nmd.primal.core.common.helper.RecipeHelper;
import nmd.primal.core.common.tiles.machines.TileWorkTableShelf;

public class WorkTableShelf
extends AbstractWorkTable<TileWorkTableShelf>
implements ITypeWood {
    public WorkTableShelf(Material material) {
        super(material);
        this.func_149713_g(1);
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileWorkTableShelf();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable World player, List<String> tooltip, ITooltipFlag advanced) {
        tooltip.add(TextFormatting.GREEN + I18n.func_74838_a((String)"tooltip.info.primal.shelf_storage"));
    }

    private int getShelfSlot(TileWorkTableShelf tile, float hitX, float hitY, float hitZ) {
        return this.getHorizontalShelfIndex(tile.getRotation(), hitX, hitZ) + this.getVerticalShelfIndex(hitY);
    }

    private int getHorizontalShelfIndex(int rotation, float hitX, float hitZ) {
        float hit_side = rotation == 0 || rotation == 2 ? hitX : hitZ;
        switch (rotation) {
            case 2: 
            case 3: {
                return hit_side > 0.5f ? 1 : 0;
            }
            case 0: 
            case 1: {
                return hit_side < 0.5f ? 1 : 0;
            }
        }
        return -10;
    }

    private int getVerticalShelfIndex(float hitY) {
        return hitY < 0.5f ? 2 : (hitY > 0.5f ? 0 : -10);
    }

    public void func_180649_a(World world, BlockPos pos, EntityPlayer player) {
        if (world.field_72995_K) {
            return;
        }
        TileWorkTableShelf tile = (TileWorkTableShelf)world.func_175625_s(pos);
        if (tile == null) {
            return;
        }
        RayTraceResult rayResult = ForgeHooks.rayTraceEyes((EntityLivingBase)player, (double)(((EntityPlayerMP)player).field_71134_c.getBlockReachDistance() + 1.0));
        if (rayResult == null) {
            return;
        }
        EnumFacing side = rayResult.field_178784_b;
        if (side != tile.getFrontFace()) {
            return;
        }
        float hitX = (float)(rayResult.field_72307_f.field_72450_a - (double)pos.func_177958_n());
        float hitY = (float)(rayResult.field_72307_f.field_72448_b - (double)pos.func_177956_o());
        float hitZ = (float)(rayResult.field_72307_f.field_72449_c - (double)pos.func_177952_p());
        int slot = this.getShelfSlot(tile, hitX, hitY, hitZ);
        int size = player.func_70093_af() ? tile.getStorageHandler().getStackInSlot(slot).func_190916_E() : 1;
        ItemStack shelf_stack = tile.getStorageHandler().extractItem(slot, size, false);
        if (shelf_stack.func_190926_b() && size > 0) {
            return;
        }
        ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)shelf_stack.func_77946_l());
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing face, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        TileWorkTableShelf tile = (TileWorkTableShelf)world.func_175625_s(pos);
        if (tile == null) {
            return false;
        }
        if (face == EnumFacing.UP) {
            player.openGui((Object)PrimalCore.INSTANCE, 1, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            return true;
        }
        if (face != tile.getFrontFace()) {
            return false;
        }
        int slot = this.getShelfSlot(tile, hitX, hitY, hitZ);
        if (slot > -1) {
            ItemStackHandler handler = tile.getStorageHandler();
            ItemStack held_stack = player.func_184614_ca();
            ItemStack shelf_stack = handler.getStackInSlot(slot);
            if (!shelf_stack.func_190926_b()) {
                if (!held_stack.func_190926_b() && held_stack.func_77969_a(shelf_stack)) {
                    if (shelf_stack.func_190916_E() <= handler.getSlotLimit(slot) && CommonUtils.addStack(tile.getStorageHandler(), player, held_stack, slot)) {
                        SoundType soundtype = held_stack.func_77973_b() instanceof ItemBlock ? ((ItemBlock)held_stack.func_77973_b()).func_179223_d().func_185467_w() : SoundType.field_185848_a;
                        world.func_184148_a(null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
                    }
                } else {
                    ItemStack take_stack = handler.extractItem(slot, player.func_70093_af() ? shelf_stack.func_190916_E() : 1, false);
                    ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)take_stack.func_77946_l());
                }
            } else if (CommonUtils.addStack(tile.getStorageHandler(), player, held_stack, slot)) {
                SoundType soundtype = held_stack.func_77973_b() instanceof ItemBlock ? ((ItemBlock)held_stack.func_77973_b()).func_179223_d().func_185467_w() : SoundType.field_185848_a;
                world.func_184148_a(null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
            }
            return true;
        }
        return super.func_180639_a(world, pos, state, player, hand, face, hitX, hitY, hitZ);
    }

    @Override
    public void dropItemsAndBlock(World world, BlockPos pos, IBlockState state) {
        TileEntity tile;
        if (!world.field_72995_K && world.func_82736_K().func_82766_b("doTileDrops") && !world.restoringBlockSnapshots && (tile = world.func_175625_s(pos)) != null && !tile.func_145837_r() && tile instanceof TileWorkTableShelf) {
            float offset = 0.7f;
            RecipeHelper.dropSlotItems(world, pos, offset, ((TileWorkTableShelf)tile).getCraftingHandler());
            RecipeHelper.dropSlotItems(world, pos, offset, ((TileWorkTableShelf)tile).getStorageHandler());
            PlayerHelper.spawnItemOnGround(world, pos, this.func_185473_a(world, pos, state));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        for (ITypeWood.EnumType blocks$enumtype : ITypeWood.EnumType.values()) {
            ItemStack stack = new ItemStack((Block)this, 1, blocks$enumtype.getMetadata());
            NBTHelper.setString(stack, "type", blocks$enumtype.func_176610_l());
            list.add((Object)stack);
        }
    }

    public ItemStack func_185473_a(World world, BlockPos pos, IBlockState state) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && !tile.func_145837_r() && tile instanceof ITypeNBT) {
            ItemStack stack = new ItemStack((Block)this, 1, ITypeWood.EnumType.byName(((ITypeNBT)tile).getType()).getMetadata());
            NBTHelper.setString(stack, "type", ((ITypeNBT)tile).getType());
            return stack;
        }
        return super.func_185473_a(world, pos, state);
    }

    public Material func_149688_o(IBlockState state) {
        return Material.field_151575_d;
    }

    public SoundType getSoundType(IBlockState state, World world, BlockPos pos, @Nullable Entity entity) {
        return this.func_185467_w();
    }

    public BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, TYPE});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)this.getHorizontalFacingFromIndex(meta));
    }

    public int func_176201_c(IBlockState state) {
        return this.getHorizontalIndexFromState(state);
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && !tile.func_145837_r() && tile instanceof ITypeNBT) {
            String type = ((ITypeNBT)tile).getType();
            return state.func_177226_a((IProperty)TYPE, (Comparable)((Object)ITypeWood.EnumType.byName(type)));
        }
        return state;
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing face, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.getFacingState(placer, this);
    }
}

