/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.blocks.machines;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import nmd.primal.core.api.PrimalAPI;
import nmd.primal.core.api.events.SmelterEvent;
import nmd.primal.core.api.interfaces.IFace;
import nmd.primal.core.api.interfaces.ILit;
import nmd.primal.core.api.interfaces.IPickup;
import nmd.primal.core.api.interfaces.ISchedule;
import nmd.primal.core.api.interfaces.types.ITypeMud;
import nmd.primal.core.api.interfaces.types.ITypeNBT;
import nmd.primal.core.common.blocks.AbstractPottery;
import nmd.primal.core.common.helper.FXHelper;
import nmd.primal.core.common.helper.FireHelper;
import nmd.primal.core.common.helper.PlayerHelper;
import nmd.primal.core.common.helper.RecipeHelper;
import nmd.primal.core.common.init.ModConfig;
import nmd.primal.core.common.recipes.tile.SmelterRecipe;
import nmd.primal.core.common.tiles.machines.TileSmelter;
import stanhebben.zenscript.annotations.NotNull;

public class Smelter
extends AbstractPottery<TileSmelter>
implements ITypeMud,
IFace,
ISchedule,
ILit,
IPickup {
    public Smelter() {
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)ILit.LIT, (Comparable)Boolean.valueOf(false)));
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileSmelter();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable World player, List<String> tooltip, ITooltipFlag advanced) {
        tooltip.add(TextFormatting.GREEN + I18n.func_74838_a((String)"tooltip.info.primal.smelter_crafting"));
        tooltip.add(TextFormatting.RED + I18n.func_74838_a((String)"tooltip.info.primal.abstract_produces_waste"));
    }

    @Override
    public PathNodeType getAiPathNodeType(IBlockState state, IBlockAccess world, BlockPos pos) {
        return this.isLit(world, pos, state) ? PathNodeType.DAMAGE_FIRE : super.getAiPathNodeType(state, world, pos);
    }

    public void setRecipe(@NotNull TileSmelter tile, @NotNull SmelterRecipe recipe, @NotNull IBlockState state) {
        tile.setRecipeTime(recipe);
        this.scheduleUpdate(tile.func_145831_w(), tile.func_174877_v(), state);
    }

    @Override
    public boolean canInteract(World world, BlockPos pos, IBlockState state, EnumFacing face, EntityLivingBase entity) {
        return face != EnumFacing.UP && face != EnumFacing.DOWN;
    }

    @Override
    public boolean canLite(World world, BlockPos pos, IBlockState state, EnumFacing face, @Nullable EntityLivingBase entity) {
        return true;
    }

    @Override
    public boolean canExtinguish(World world, BlockPos pos, IBlockState state, EnumFacing face, EntityLivingBase entity) {
        return false;
    }

    @Override
    public boolean doLite(World world, BlockPos pos, IBlockState state, EnumFacing face, @Nullable EntityLivingBase entity) {
        SmelterRecipe recipe;
        TileEntity tile;
        if (world.field_72995_K) {
            return true;
        }
        if (!this.isLit((IBlockAccess)world, pos, state) && (tile = world.func_175625_s(pos)) != null && !tile.func_145837_r() && tile instanceof TileSmelter && ((TileSmelter)tile).isCovered() && ((TileSmelter)tile).getCounter() == 0 && (recipe = ((TileSmelter)tile).matchRecipe()) != null) {
            if (recipe.isPassive()) {
                ((TileSmelter)tile).playSoundCraft();
                this.setRecipe((TileSmelter)tile, recipe, state);
                return true;
            }
            IBlockState updated_state = state.func_177226_a((IProperty)ILit.LIT, (Comparable)Boolean.valueOf(true));
            if (world.func_180501_a(pos, updated_state, 2)) {
                FireHelper.makeSmoke(world, pos, 16);
                FXHelper.soundFireAmbient(world, pos, 1.0f);
                this.setRecipe((TileSmelter)tile, recipe, updated_state);
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean doPickup(World world, BlockPos pos, IBlockState state, EnumFacing face, EntityPlayer player, EnumHand hand) {
        TileEntity tile;
        if (world.field_72995_K) {
            return true;
        }
        if (face == EnumFacing.UP && (tile = world.func_175625_s(pos)) != null && !tile.func_145837_r() && tile instanceof TileSmelter && ((TileSmelter)tile).isCovered()) {
            SmelterEvent.Open open = new SmelterEvent.Open((TileSmelter)tile, player);
            if (MinecraftForge.EVENT_BUS.post((Event)open)) {
                return false;
            }
            if (this.isLit((IBlockAccess)world, pos, state)) {
                this.doExtinguish(world, pos, state, face, (EntityLivingBase)player);
            } else if (((TileSmelter)tile).getCounter() > 0) {
                FXHelper.soundSteamHiss(world, pos, 1.5f);
            }
            ((TileSmelter)tile).setCovered(false);
            ((TileSmelter)tile).resetCount();
            ((TileSmelter)tile).updateBlock();
            FXHelper.soundPotteryLid(world, pos, 1.5f);
            ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)this.getLid(world, pos, state));
            return true;
        }
        return false;
    }

    @Override
    public boolean shouldSchedule(World world, BlockPos pos, IBlockState state) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && !tile.func_145837_r() && tile instanceof TileSmelter && ((TileSmelter)tile).isCovered()) {
            return this.isLit((IBlockAccess)world, pos, state) || ((TileSmelter)tile).getCounter() > 0;
        }
        return false;
    }

    @Override
    public boolean shouldScheduleOnPlacement() {
        return false;
    }

    @Override
    public int scheduledTicks(World world, BlockPos pos, IBlockState state) {
        return RANDOM.nextInt((int)Math.floor((float)ModConfig.Machines.SMELTER_TICK_RATE * 0.75f), ModConfig.Machines.SMELTER_TICK_RATE);
    }

    public boolean isFrontFace(World world, BlockPos pos, EnumFacing face) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && !tile.func_145837_r() && tile instanceof TileSmelter) {
            return ((TileSmelter)tile).getFrontFace() == face;
        }
        return false;
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (world.field_72995_K) {
            return;
        }
        TileSmelter tile = (TileSmelter)world.func_175625_s(pos);
        if (tile == null || tile.func_145837_r()) {
            return;
        }
        boolean lit = this.isLit((IBlockAccess)world, pos, state);
        SmelterRecipe recipe = tile.matchRecipe();
        if (recipe != null && tile.isCovered() && (lit || recipe.isPassive())) {
            SmelterEvent.Update event = new SmelterEvent.Update(tile, recipe, lit);
            if (MinecraftForge.EVENT_BUS.post((Event)event)) {
                return;
            }
            if (tile.getCounter() > 1) {
                tile.reduceCounter();
                if (recipe.isPassive()) {
                    FXHelper.soundPotteryActive(world, pos, 1.0f);
                }
            } else {
                tile.resetCount();
                if (tile.finishRecipe(recipe)) {
                    SmelterRecipe recipe_continuation;
                    if (lit) {
                        FireHelper.makeSmoke(world, pos, ModConfig.Machines.SMELTER_SMOKE_CHANCE);
                        if (recipe.hasSlag()) {
                            tile.addSlag();
                        }
                    }
                    if ((recipe_continuation = tile.matchRecipe()) != null) {
                        PrimalAPI.logger(24, "smelter", "continue recipe processing");
                        tile.setRecipeTime(recipe_continuation);
                    } else {
                        PrimalAPI.logger(24, "smelter", "no valid recipes remaining");
                        this.doExtinguish(world, pos, state, EnumFacing.UP, null);
                    }
                }
            }
            this.scheduleUpdate(world, pos, state);
        } else {
            tile.resetCount();
        }
    }

    @Override
    public void func_180649_a(World world, BlockPos pos, EntityPlayer player) {
        if (world.field_72995_K) {
            return;
        }
        TileSmelter tile = (TileSmelter)world.func_175625_s(pos);
        if (tile == null || tile.func_145837_r()) {
            return;
        }
        SmelterEvent.Collide collide = new SmelterEvent.Collide(tile, (EntityLivingBase)player);
        if (MinecraftForge.EVENT_BUS.post((Event)collide)) {
            return;
        }
        RayTraceResult rayResult = ForgeHooks.rayTraceEyes((EntityLivingBase)player, (double)(((EntityPlayerMP)player).field_71134_c.getBlockReachDistance() + 1.0));
        if (rayResult != null && rayResult.field_178784_b == tile.getFrontFace()) {
            this.showInventory(tile, player);
        }
        super.func_180649_a(world, pos, player);
    }

    @Override
    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing face, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        if (hand == EnumHand.OFF_HAND) {
            return false;
        }
        TileSmelter tile = (TileSmelter)world.func_175625_s(pos);
        if (tile != null && !tile.func_145837_r()) {
            if (!tile.isCovered() && face == EnumFacing.UP) {
                ItemStack stack = player.func_184614_ca();
                PrimalAPI.logger(24, "smelter", "activated: " + stack);
                if (this.isLid(world, pos, state, stack)) {
                    SmelterRecipe recipe = tile.matchRecipe();
                    SmelterEvent.Close close = new SmelterEvent.Close(tile, player, recipe);
                    if (MinecraftForge.EVENT_BUS.post((Event)close)) {
                        return false;
                    }
                    tile.setCovered(true);
                    tile.updateBlock();
                    PlayerHelper.useStack(player, hand, stack);
                    FXHelper.soundPotteryLid(world, pos, 1.5f);
                    if (recipe != null && recipe.isPassive()) {
                        this.setRecipe(tile, recipe, state);
                        FXHelper.soundPotteryActive(world, pos, 1.0f);
                    }
                    return true;
                }
                if (player.func_70093_af()) {
                    if (!tile.takeOutput(player)) {
                        tile.takeInput(player);
                    }
                    return true;
                }
            }
            if (face == tile.getFrontFace()) {
                this.showInventory(tile, player);
            }
        }
        return super.func_180639_a(world, pos, state, player, hand, face, hitX, hitY, hitZ);
    }

    @Override
    public void func_180658_a(World world, BlockPos pos, Entity entity, float fallDistance) {
        super.func_180658_a(world, pos, entity, fallDistance);
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && !tile.func_145837_r() && tile instanceof TileSmelter) {
            SmelterEvent.Collide collide;
            if (entity instanceof EntityItem) {
                if (!((TileSmelter)tile).isCovered()) {
                    ((TileSmelter)tile).addIngredients((EntityItem)entity);
                }
            } else if (entity instanceof EntityLivingBase && MinecraftForge.EVENT_BUS.post((Event)(collide = new SmelterEvent.Collide((TileSmelter)tile, (EntityLivingBase)entity)))) {
                return;
            }
        }
    }

    @Override
    public void func_176199_a(World world, BlockPos pos, Entity entity) {
        if (entity instanceof EntityLivingBase) {
            SmelterEvent.Collide collide;
            TileEntity tile;
            IBlockState state;
            if (!entity.func_70045_F() && !EnchantmentHelper.func_189869_j((EntityLivingBase)((EntityLivingBase)entity)) && this.isLit((IBlockAccess)world, pos, state = world.func_180495_p(pos))) {
                entity.func_70097_a(DamageSource.field_190095_e, 1.0f);
            }
            if ((tile = world.func_175625_s(pos)) != null && !tile.func_145837_r() && tile instanceof TileSmelter && MinecraftForge.EVENT_BUS.post((Event)(collide = new SmelterEvent.Collide((TileSmelter)tile, (EntityLivingBase)entity)))) {
                return;
            }
        }
        super.func_176199_a(world, pos, entity);
    }

    public void showInventory(TileSmelter tile, EntityPlayer player) {
        if (player.func_70093_af()) {
            SmelterEvent.Check check = new SmelterEvent.Check(tile, player);
            if (MinecraftForge.EVENT_BUS.post((Event)check)) {
                return;
            }
            ItemStackHandler inputHandler = tile.getInputHandler();
            for (int i = 0; i < inputHandler.getSlots(); ++i) {
                ItemStack stack = inputHandler.getStackInSlot(i);
                if (stack.func_190926_b()) continue;
                String count = stack.func_190916_E() > 1 ? " (" + stack.func_190916_E() + ")" : "";
                player.func_145747_a((ITextComponent)new TextComponentTranslation(TextFormatting.GREEN + stack.func_82833_r() + count, new Object[0]));
            }
            ItemStackHandler outputHandler = tile.getOutputHandler();
            for (int i = 0; i < outputHandler.getSlots(); ++i) {
                ItemStack stack = outputHandler.getStackInSlot(i);
                if (stack.func_190926_b()) continue;
                String count = stack.func_190916_E() > 1 ? " (" + stack.func_190916_E() + ")" : "";
                player.func_145747_a((ITextComponent)new TextComponentTranslation(TextFormatting.GOLD + stack.func_82833_r() + count, new Object[0]));
            }
        }
    }

    @Override
    public void dropItemsAndBlock(World world, BlockPos pos, IBlockState state) {
        TileEntity tile;
        if (!world.field_72995_K && world.func_82736_K().func_82766_b("doTileDrops") && !world.restoringBlockSnapshots && (tile = world.func_175625_s(pos)) != null && !tile.func_145837_r() && tile instanceof TileSmelter) {
            float offset = 0.7f;
            RecipeHelper.dropSlotItems(world, pos, offset, ((TileSmelter)tile).getInputHandler());
            RecipeHelper.dropSlotItems(world, pos, offset, ((TileSmelter)tile).getStorageHandler());
            PlayerHelper.spawnItemOnGround(world, pos, this.func_185473_a(world, pos, state));
            if (((TileSmelter)tile).isCovered()) {
                PlayerHelper.spawnItemOnGround(world, pos, this.getLid(world, pos, state));
            }
        }
    }

    @Override
    public void func_176208_a(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        SmelterEvent.Collide collide;
        TileEntity tile;
        if (this.isLit((IBlockAccess)world, pos, state)) {
            FireHelper.doFireDamage((Entity)player, 15, 1.5f);
        }
        if ((tile = world.func_175625_s(pos)) != null && !tile.func_145837_r() && tile instanceof TileSmelter && MinecraftForge.EVENT_BUS.post((Event)(collide = new SmelterEvent.Collide((TileSmelter)tile, (EntityLivingBase)player)))) {
            return;
        }
    }

    @Override
    public void func_180653_a(World world, BlockPos pos, IBlockState state, float chance, int fortune) {
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return PrimalAPI.Bounds.AABB_SMELTER;
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        return this.isLit(world, pos, state) ? 10 : 0;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(IBlockState state, World world, RayTraceResult target, ParticleManager manager) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        if (this.isLit((IBlockAccess)world, pos, state)) {
            int i;
            double x = (double)pos.func_177958_n() + RANDOM.nextDouble(0.4, 0.5);
            double y = (double)pos.func_177956_o() + 0.8 + RANDOM.nextDouble(0.1f);
            double z = (double)pos.func_177952_p() + RANDOM.nextDouble(0.4, 0.5);
            if (PrimalAPI.randomCheck(0.1f)) {
                SoundEvent sound = world.func_175727_C(pos) ? SoundEvents.field_187646_bt : SoundEvents.field_187652_bv;
                world.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, sound, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
            }
            for (i = 0; i < 2 + rand.nextInt(3); ++i) {
                world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, x + (RANDOM.nextDouble() * 0.6 - 0.3), y, z + (RANDOM.nextDouble() * 0.6 - 0.3), 0.0, 0.0, 0.0, new int[0]);
            }
            for (i = 0; i < 2 + rand.nextInt(2); ++i) {
                world.func_175688_a(EnumParticleTypes.FLAME, x + (RANDOM.nextDouble() * 0.5 - 0.2), (double)((float)pos.func_177956_o() + 0.35f), z + (RANDOM.nextDouble() * 0.5 - 0.2), 0.0, 0.0, 0.0, new int[0]);
            }
        }
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing face, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a((IProperty)IFace.FACING, (Comparable)placer.func_174811_aO());
    }

    @Override
    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(world, pos, state, placer, stack);
        TileSmelter tile = (TileSmelter)world.func_175625_s(pos);
        if (tile != null && !tile.func_145837_r()) {
            tile.setRotation((byte)placer.func_174811_aO().func_176736_b());
        }
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{TYPE, FACING, LIT, PrimalAPI.States.COVERED});
    }

    @Override
    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && !tile.func_145837_r() && tile instanceof TileSmelter) {
            return state.func_177226_a((IProperty)TYPE, (Comparable)((Object)ITypeMud.EnumType.byName(((ITypeNBT)tile).getType()))).func_177226_a((IProperty)PrimalAPI.States.COVERED, (Comparable)Boolean.valueOf(((TileSmelter)tile).isCovered()));
        }
        return state;
    }

    @Override
    public int func_176201_c(IBlockState state) {
        int meta = ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b();
        if (((Boolean)state.func_177229_b((IProperty)LIT)).booleanValue()) {
            meta |= 8;
        }
        return meta;
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)meta)).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf((meta & 8) > 0));
    }
}

