/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.blocks.machines;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.Mirror;
import net.minecraft.util.NonNullList;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import nmd.primal.core.api.PrimalAPI;
import nmd.primal.core.api.interfaces.IPhased;
import nmd.primal.core.api.interfaces.types.ITypeNBT;
import nmd.primal.core.api.interfaces.types.ITypeWood;
import nmd.primal.core.common.blocks.AbstractShelf;
import nmd.primal.core.common.helper.NBTHelper;
import nmd.primal.core.common.helper.PlayerHelper;
import nmd.primal.core.common.helper.RecipeHelper;
import nmd.primal.core.common.tiles.machines.TileShelf;

public class ShelfHalf
extends AbstractShelf<TileShelf>
implements ITypeWood,
IPhased {
    public static final PropertyEnum<EnumShelf> HALF = PropertyEnum.func_177709_a((String)"half", EnumShelf.class);

    public ShelfHalf(Material material) {
        super(material, 64);
        this.func_149713_g(1);
        this.func_149711_c(2.0f);
        this.func_149752_b(5.0f);
    }

    @Override
    public boolean isPhased(IBlockState state) {
        return true;
    }

    @Override
    public boolean isPhased(IBlockAccess world, BlockPos pos, IBlockState state) {
        TileEntity tile = world.func_175625_s(pos);
        return tile != null && !tile.func_145837_r() && tile instanceof IPhased && ((TileShelf)tile).isPhased();
    }

    @Override
    public boolean isPhasedAccessible(IBlockAccess world, BlockPos pos, IBlockState state, @Nullable Entity entity) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && !tile.func_145837_r() && tile instanceof TileShelf) {
            BlockPos back_pos = pos.func_177972_a(((TileShelf)tile).getFrontFace().func_176734_d());
            IBlockState back_state = world.func_180495_p(back_pos);
            Block back_block = back_state.func_177230_c();
            return ((TileShelf)tile).isPhased() && entity instanceof EntityPlayer && (world.func_175623_d(back_pos) || back_block instanceof IPhased && !(back_block instanceof ShelfHalf) && ((IPhased)back_block).isPhasedAccessible(world, back_pos, back_state, entity));
        }
        return false;
    }

    @Override
    public boolean setPhase(World world, BlockPos pos, IBlockState state, boolean phased) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && !tile.func_145837_r() && tile instanceof TileShelf) {
            ((TileShelf)tile).setPhase(phased);
            return true;
        }
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        state = state.func_185899_b(source, pos);
        EnumFacing enumfacing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        EnumShelf enumShelf = (EnumShelf)((Object)state.func_177229_b(HALF));
        switch (enumfacing) {
            default: {
                return this.isFront(state) ? PrimalAPI.Bounds.AABB_SLAB_VERTICAL_EAST : PrimalAPI.Bounds.AABB_SLAB_VERTICAL_WEST;
            }
            case SOUTH: {
                return this.isFront(state) ? PrimalAPI.Bounds.AABB_SLAB_VERTICAL_SOUTH : PrimalAPI.Bounds.AABB_SLAB_VERTICAL_NORTH;
            }
            case WEST: {
                return this.isFront(state) ? PrimalAPI.Bounds.AABB_SLAB_VERTICAL_WEST : PrimalAPI.Bounds.AABB_SLAB_VERTICAL_EAST;
            }
            case NORTH: 
        }
        return this.isFront(state) ? PrimalAPI.Bounds.AABB_SLAB_VERTICAL_NORTH : PrimalAPI.Bounds.AABB_SLAB_VERTICAL_SOUTH;
    }

    @Override
    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_185481_k(IBlockState state) {
        return false;
    }

    @Override
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState state, IBlockAccess access, BlockPos pos, EnumFacing side) {
        EnumFacing facing = this.getFacing(state).func_176734_d();
        return this.func_149688_o(state) == Material.field_151592_s || (side == facing || super.func_176225_a(state, access, pos, side)) && super.func_176225_a(state, access, pos, side);
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    @Override
    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing face, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        IBlockState state = this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO());
        EnumFacing place_against = face.func_176734_d();
        EnumFacing place_direction = placer.func_174811_aO();
        switch (place_direction) {
            case NORTH: {
                if (!(hitZ > 0.5f) || place_against == place_direction) break;
                state = state.func_177226_a(HALF, (Comparable)((Object)EnumShelf.FRONT));
                break;
            }
            case SOUTH: {
                if (!(hitZ < 0.5f) || place_against == place_direction) break;
                state = state.func_177226_a(HALF, (Comparable)((Object)EnumShelf.FRONT));
                break;
            }
            case EAST: {
                if (!(hitX < 0.5f) || place_against == place_direction) break;
                state = state.func_177226_a(HALF, (Comparable)((Object)EnumShelf.FRONT));
                break;
            }
            case WEST: {
                if (!(hitX > 0.5f) || place_against == place_direction) break;
                state = state.func_177226_a(HALF, (Comparable)((Object)EnumShelf.FRONT));
                break;
            }
            default: {
                state = state.func_177226_a(HALF, (Comparable)((Object)EnumShelf.BACK));
            }
        }
        return state;
    }

    @Override
    public void dropItemsAndBlock(World world, BlockPos pos, IBlockState state) {
        TileEntity tile;
        if (!world.field_72995_K && world.func_82736_K().func_82766_b("doTileDrops") && !world.restoringBlockSnapshots && (tile = world.func_175625_s(pos)) != null && !tile.func_145837_r() && tile instanceof TileShelf) {
            float offset = 0.7f;
            RecipeHelper.dropSlotItems(world, pos, offset, ((TileShelf)tile).getStorageHandler());
            PlayerHelper.spawnItemOnGround(world, pos, this.func_185473_a(world, pos, state));
        }
    }

    @Override
    public EnumPushReaction func_149656_h(IBlockState state) {
        return EnumPushReaction.DESTROY;
    }

    @Override
    public boolean func_149659_a(Explosion explosionIn) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        for (ITypeWood.EnumType blocks$enumtype : ITypeWood.EnumType.values()) {
            ItemStack stack = new ItemStack((Block)this, 1, blocks$enumtype.getMetadata());
            NBTHelper.setString(stack, "type", blocks$enumtype.func_176610_l());
            list.add((Object)stack);
        }
    }

    public ItemStack func_185473_a(World world, BlockPos pos, IBlockState state) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && !tile.func_145837_r() && tile instanceof ITypeNBT) {
            ItemStack stack = new ItemStack((Block)this, 1, ITypeWood.EnumType.byName(((ITypeNBT)tile).getType()).getMetadata());
            NBTHelper.setString(stack, "type", ((ITypeNBT)tile).getType());
            return stack;
        }
        return super.func_185473_a(world, pos, state);
    }

    @Override
    public BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, TYPE, HALF});
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(HALF, (Comparable)((Object)EnumShelf.byMetadata(meta))).func_177226_a((IProperty)FACING, (Comparable)this.getHorizontalFacingFromIndex(this.getFacingIndexFromMeta(meta)));
    }

    @Override
    public int func_176201_c(IBlockState state) {
        return EnumShelf.getIndex(state) + this.getHorizontalIndexFromState(state);
    }

    @Override
    public int getFacingIndexFromMeta(int meta) {
        int modifier = meta < 4 ? 0 : 4;
        return meta - modifier;
    }

    private boolean isFront(IBlockState state) {
        return state.func_177229_b(HALF) == EnumShelf.FRONT;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && !tile.func_145837_r() && tile instanceof ITypeNBT) {
            String type = ((ITypeNBT)tile).getType();
            return state.func_177226_a((IProperty)TYPE, (Comparable)((Object)ITypeWood.EnumType.byName(type)));
        }
        return state;
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public static enum EnumShelf implements IStringSerializable
    {
        BACK("back"),
        FRONT("front");

        private final String name;
        private static int index;

        private EnumShelf(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public String func_176610_l() {
            return this.name;
        }

        public static int getIndex(IBlockState state) {
            EnumShelf type = (EnumShelf)((Object)state.func_177229_b(HALF));
            return type == FRONT ? 4 : 0;
        }

        public static EnumShelf byMetadata(int meta) {
            index = meta < 4 ? 0 : 1;
            return EnumShelf.values()[index];
        }
    }
}

