/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.blocks.machines;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.Mirror;
import net.minecraft.util.NonNullList;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import nmd.primal.core.api.PrimalAPI;
import nmd.primal.core.api.enums.EnumBasicFluid;
import nmd.primal.core.api.interfaces.IFace;
import nmd.primal.core.api.interfaces.IPickup;
import nmd.primal.core.api.interfaces.ISchedule;
import nmd.primal.core.api.interfaces.types.ITypeNBT;
import nmd.primal.core.api.interfaces.types.ITypeWood;
import nmd.primal.core.common.blocks.AbstractBlockType;
import nmd.primal.core.common.helper.CommonUtils;
import nmd.primal.core.common.helper.FXHelper;
import nmd.primal.core.common.helper.NBTHelper;
import nmd.primal.core.common.helper.PlayerHelper;
import nmd.primal.core.common.helper.RecipeHelper;
import nmd.primal.core.common.init.ModConfig;
import nmd.primal.core.common.tiles.machines.TileFishTrap;

public class FishTrap
extends AbstractBlockType<TileFishTrap>
implements ITypeWood,
IFace,
IPickup,
ISchedule {
    private int interaction_delay;

    public FishTrap() {
        super(Material.field_151586_h);
        this.func_149672_a(SoundType.field_185848_a);
        this.func_149713_g(0);
        this.func_149711_c(0.5f);
        this.func_149752_b(0.0f);
        this.setHarvestLevel("axe", 0);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)BlockLiquid.field_176367_b, (Comparable)Integer.valueOf(0)));
        this.interaction_delay = 2;
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileFishTrap();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag advanced) {
        super.func_190948_a(stack, world, tooltip, advanced);
        tooltip.add(TextFormatting.BLUE + I18n.func_74838_a((String)"tooltip.info.primal.fishtrap_bait"));
        tooltip.add(TextFormatting.BLUE + I18n.func_74838_a((String)"tooltip.info.primal.fishtrap_misc"));
        tooltip.add(TextFormatting.GOLD + I18n.func_74838_a((String)"tooltip.info.primal.fishtrap_warning"));
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return PrimalAPI.Bounds.AABB_FISH_TRAP;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        super.func_180655_c(state, world, pos, rand);
        TileFishTrap tile = (TileFishTrap)world.func_175625_s(pos);
        if (tile != null && !tile.func_145837_r() && tile.hasFish()) {
            EnumParticleTypes particles = state.func_177229_b(PrimalAPI.States.BASIC_FLUID) == EnumBasicFluid.LAVA ? EnumParticleTypes.SMOKE_LARGE : EnumParticleTypes.WATER_BUBBLE;
            FXHelper.makeParticles(world, pos, particles, 2, 4, 0.4f, 0.5);
        }
    }

    @Override
    public boolean shouldSchedule(World world, BlockPos pos, IBlockState state) {
        TileEntity tile = world.func_175625_s(pos);
        return tile != null && !tile.func_145837_r() && tile instanceof TileFishTrap && ((TileFishTrap)tile).checkFrontWaterAccess(world, pos);
    }

    @Override
    public boolean shouldScheduleOnPlacement() {
        return false;
    }

    @Override
    public int scheduledTicks(World world, BlockPos pos, IBlockState state) {
        return RANDOM.nextInt(ModConfig.Machines.FISH_TRAP_TICK_RATE / 2, ModConfig.Machines.FISH_TRAP_TICK_RATE);
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (world.field_72995_K) {
            return;
        }
        TileFishTrap trap = (TileFishTrap)world.func_175625_s(pos);
        if (trap == null || trap.func_145837_r()) {
            return;
        }
        PrimalAPI.logger(20, "scheduled update", "fish trap");
        if (!trap.checkFrontWaterAccess(world, pos, trap.getFrontFace(), 2)) {
            return;
        }
        trap.goFish(world, pos);
        if (trap.hasBait()) {
            PrimalAPI.logger(20, "schedule", "@" + pos + ", FishTrap#updateTick");
            PrimalAPI.scheduleBlock(world, pos, state);
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing face, float hitX, float hitY, float hitZ) {
        super.func_180639_a(world, pos, state, player, hand, face, hitX, hitY, hitZ);
        if (world.field_72995_K) {
            return true;
        }
        TileFishTrap trap = (TileFishTrap)world.func_175625_s(pos);
        if (trap != null && !trap.func_145837_r()) {
            if (trap.hasStorageItems()) {
                if (PrimalAPI.randomCheck(this.interaction_delay)) {
                    ItemStackHandler trapHandler = trap.getStorageHandler();
                    for (int i = 0; i < trapHandler.getSlots(); ++i) {
                        ItemStack stack = trapHandler.extractItem(i, trapHandler.getStackInSlot(i).func_190916_E(), false);
                        ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)stack.func_77946_l());
                    }
                    if (!trap.hasBait()) {
                        trap.resetTrap();
                    }
                }
            } else {
                return trap.baitTrap(world, pos, player, hand);
            }
        }
        return true;
    }

    @Override
    public boolean doPickup(World world, BlockPos pos, IBlockState state, EnumFacing face, EntityPlayer player, EnumHand hand) {
        if (world.field_72995_K) {
            return true;
        }
        ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)this.func_185473_a(world, pos, state));
        world.func_175666_e(pos, state.func_177230_c());
        this.dropItems(world, pos, state);
        return world.func_175656_a(pos, this.getReplacementBlock(world, pos, state));
    }

    @Override
    public IBlockState getReplacementBlock(World world, BlockPos pos, IBlockState state) {
        return state.func_177230_c() == this && state.func_177229_b(PrimalAPI.States.BASIC_FLUID) == EnumBasicFluid.LAVA ? Blocks.field_150353_l.func_176223_P() : Blocks.field_150355_j.func_176223_P();
    }

    @Override
    public void dropItemsAndBlock(World world, BlockPos pos, IBlockState state) {
        TileFishTrap tile;
        if (!world.field_72995_K && world.func_82736_K().func_82766_b("doTileDrops") && !world.restoringBlockSnapshots && (tile = (TileFishTrap)world.func_175625_s(pos)) != null && !tile.func_145837_r()) {
            this.dropItems(world, pos, state);
            PlayerHelper.spawnItemOnGround(world, pos, this.func_185473_a(world, pos, state));
        }
    }

    public void dropItems(World world, BlockPos pos, IBlockState state) {
        TileEntity tile;
        if (!world.field_72995_K && world.func_82736_K().func_82766_b("doTileDrops") && !world.restoringBlockSnapshots && (tile = world.func_175625_s(pos)) != null && !tile.func_145837_r() && tile instanceof TileFishTrap) {
            float offset = 0.7f;
            RecipeHelper.dropSlotItems(world, pos, offset, ((TileFishTrap)tile).getStorageHandler());
            RecipeHelper.dropSlotItems(world, pos, offset, ((TileFishTrap)tile).getFuelHandler());
        }
    }

    private boolean replaceBlock(World world, BlockPos pos, IBlockState state, IBlockState new_state) {
        if (!world.field_72995_K) {
            this.dropItemsAndBlock(world, pos, state);
            return world.func_175656_a(pos, new_state);
        }
        return false;
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        return world.func_180495_p(pos.func_177977_b()).func_185904_a().func_76230_c() && !world.func_175623_d(pos.func_177984_a()) && !CommonUtils.hasAdjacentMaterial((IBlockAccess)world, pos, EnumFacing.field_176754_o, Material.field_151579_a);
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        if (!this.func_176196_c(world, pos)) {
            this.replaceBlock(world, pos, state, this.getReplacementBlock(world, pos, state));
        }
    }

    @Override
    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        if (this.hasTileEntity(state)) {
            world.func_175713_t(pos);
        }
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        this.func_176208_a(world, pos, state, player);
        return this.doPickup(world, pos, state, EnumFacing.UP, player, player.func_184600_cs());
    }

    @Override
    public EnumPushReaction func_149656_h(IBlockState state) {
        return EnumPushReaction.DESTROY;
    }

    @Override
    public boolean func_149659_a(Explosion explosionIn) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        for (ITypeWood.EnumType blocks$enumtype : ITypeWood.EnumType.values()) {
            ItemStack stack = new ItemStack((Block)this, 1, blocks$enumtype.getMetadata());
            NBTHelper.setString(stack, "type", blocks$enumtype.func_176610_l());
            list.add((Object)stack);
        }
    }

    public ItemStack func_185473_a(World world, BlockPos pos, IBlockState state) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && !tile.func_145837_r() && tile instanceof ITypeNBT) {
            ItemStack stack = new ItemStack((Block)this, 1, ITypeWood.EnumType.byName(((ITypeNBT)tile).getType()).getMetadata());
            NBTHelper.setString(stack, "type", ((ITypeNBT)tile).getType());
            return stack;
        }
        return super.func_185473_a(world, pos, state);
    }

    public Material func_149688_o(IBlockState state) {
        return state.func_177229_b(PrimalAPI.States.BASIC_FLUID) == EnumBasicFluid.LAVA ? Material.field_151587_i : Material.field_151586_h;
    }

    public static EnumBasicFluid getFluidFromStack(ItemStack stack) {
        return !stack.func_190926_b() && NBTHelper.getString(stack, "type").equals("corypha") ? EnumBasicFluid.LAVA : EnumBasicFluid.WATER;
    }

    public static Material getMaterialFromStack(ItemStack stack) {
        return !stack.func_190926_b() && NBTHelper.getString(stack, "type").equals("corypha") ? Material.field_151587_i : Material.field_151586_h;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, TYPE, PrimalAPI.States.BASIC_FLUID, BlockLiquid.field_176367_b});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)IFace.FACING, (Comparable)this.getHorizontalFacingFromIndex(this.getFacingIndexFromMeta(meta))).func_177226_a(PrimalAPI.States.BASIC_FLUID, (Comparable)((Object)EnumBasicFluid.byMetadata(meta < 4 ? 0 : 1)));
    }

    public int func_176201_c(IBlockState state) {
        return this.getHorizontalIndexFromState(state) + (state.func_177229_b(PrimalAPI.States.BASIC_FLUID) == EnumBasicFluid.WATER ? 0 : 4);
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing face, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO()).func_177226_a(PrimalAPI.States.BASIC_FLUID, (Comparable)((Object)FishTrap.getFluidFromStack(placer.func_184586_b(hand))));
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && !tile.func_145837_r() && tile instanceof ITypeNBT) {
            String type = ((ITypeNBT)tile).getType();
            return state.func_177226_a((IProperty)TYPE, (Comparable)((Object)ITypeWood.EnumType.byName(type)));
        }
        return state;
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }
}

