/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.blocks.machines;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemHandlerHelper;
import nmd.primal.core.api.PrimalAPI;
import nmd.primal.core.api.interfaces.ILit;
import nmd.primal.core.common.blocks.AbstractContainer;
import nmd.primal.core.common.helper.FireHelper;
import nmd.primal.core.common.helper.RecipeHelper;
import nmd.primal.core.common.recipes.inworld.FireSource;
import nmd.primal.core.common.tiles.ticking.TileFirePit;

@Deprecated
public class FirePit
extends AbstractContainer
implements ILit {
    public FirePit() {
        super(Material.field_151595_p);
        this.func_149713_g(0);
        this.func_149711_c(0.5f);
        this.func_149752_b(0.0f);
        this.setHarvestLevel("shovel", 0);
        this.func_149672_a(SoundType.field_185849_b);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)ILit.LIT, (Comparable)Boolean.valueOf(false)));
        Blocks.field_150480_ab.func_180686_a((Block)this, 60, 1);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable World player, List<String> tooltip, ITooltipFlag advanced) {
        tooltip.add(TextFormatting.GOLD + I18n.func_74838_a((String)"tooltip.info.primal.abstract_dev_warning"));
    }

    @Override
    public boolean doLite(World world, BlockPos pos, IBlockState state, EnumFacing face, EntityLivingBase entity) {
        if (world.field_72995_K) {
            return true;
        }
        if (!this.isLit((IBlockAccess)world, pos, state) && world.func_180501_a(pos, state.func_177226_a((IProperty)ILit.LIT, (Comparable)Boolean.valueOf(true)), 2)) {
            FireHelper.makeSmoke(world, pos, 16);
            world.func_184133_a((EntityPlayer)null, pos, SoundEvents.field_187643_bs, SoundCategory.BLOCKS, 1.0f, RANDOM.nextFloat() * 0.4f + 0.8f);
            return true;
        }
        return false;
    }

    @Override
    public boolean doExtinguish(World world, BlockPos pos, IBlockState state, EnumFacing face, EntityLivingBase entity) {
        if (world.field_72995_K) {
            return true;
        }
        if (this.isLit((IBlockAccess)world, pos, state) && world.func_180501_a(pos, state.func_177226_a((IProperty)ILit.LIT, (Comparable)Boolean.valueOf(false)), 2)) {
            FireHelper.makeSmoke(world, pos, 16);
            world.func_184133_a((EntityPlayer)null, pos, SoundEvents.field_187646_bt, SoundCategory.BLOCKS, 1.0f, RANDOM.nextFloat() * 0.4f + 0.8f);
            return true;
        }
        return false;
    }

    @Override
    public boolean toggle(World world, BlockPos pos, IBlockState state, EnumFacing face, EntityLivingBase entity) {
        return this.isLit((IBlockAccess)world, pos, state) ? this.doExtinguish(world, pos, state, face, entity) : this.doLite(world, pos, state, face, entity);
    }

    public static boolean hasFuel(IBlockAccess world, BlockPos pos) {
        TileFirePit tile = (TileFirePit)world.func_175625_s(pos);
        return tile != null && !tile.getSlotStack(1).func_190926_b();
    }

    public static boolean togleFire(World world, BlockPos pos, IBlockState state) {
        return world.func_180501_a(pos, state.func_177231_a((IProperty)ILit.LIT), 2);
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileFirePit();
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return PrimalAPI.Bounds.AABB_FARMLAND;
    }

    public boolean canPlaceTorchOnTop(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        return this.isLit(world, pos, state) ? 12 : 0;
    }

    @Override
    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return 0;
    }

    @Override
    public boolean isFlammable(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return face == EnumFacing.UP && FirePit.hasFuel(world, pos) && this.isLit(world, pos, world.func_180495_p(pos));
    }

    @Override
    public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return 5;
    }

    @Override
    public boolean isFireSource(World world, BlockPos pos, EnumFacing face) {
        return face == EnumFacing.UP && FirePit.hasFuel((IBlockAccess)world, pos) && this.isLit((IBlockAccess)world, pos, world.func_180495_p(pos));
    }

    @Override
    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        if (PrimalAPI.randomCheckFail(2) && this.isLit((IBlockAccess)world, pos, state) && !entity.func_70026_G() && entity instanceof EntityLivingBase) {
            entity.func_70015_d(4);
        }
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        if (!worldIn.field_72995_K) {
            worldIn.func_180501_a(pos, state.func_177226_a((IProperty)ILit.LIT, (Comparable)Boolean.valueOf(false)), 2);
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing face, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            ItemStack stack = player.field_71071_by.func_70448_g();
            TileFirePit tile = (TileFirePit)world.func_175625_s(pos);
            if (tile != null && !tile.func_145837_r()) {
                ItemStack slot1 = tile.getSlotStack(1);
                if (RecipeHelper.isOreName(stack, "tinder")) {
                    ItemStack putStack = new ItemStack(stack.func_77973_b(), 1);
                    tile.setSlotStack(0, putStack);
                    player.func_184586_b(hand).func_190918_g(1);
                    tile.updateBlock();
                    return true;
                }
                if (ItemStack.func_179545_c((ItemStack)stack, (ItemStack)slot1) && !slot1.func_190926_b() && slot1.func_190916_E() < 64) {
                    if (stack.func_190916_E() + slot1.func_190916_E() <= 64) {
                        slot1.func_190917_f(stack.func_190916_E());
                        player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, ItemStack.field_190927_a);
                        return true;
                    }
                    if (stack.func_190916_E() + slot1.func_190916_E() > 64) {
                        int count = 64 - stack.func_77946_l().func_190916_E();
                        slot1.func_190917_f(count);
                        stack.func_190918_g(count);
                        return true;
                    }
                }
                if (slot1.func_190926_b() && RecipeHelper.isOreName(stack, "stickWood") && stack.func_190916_E() <= 64) {
                    tile.setSlotStack(1, stack.func_77946_l());
                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, ItemStack.field_190927_a);
                    return true;
                }
                if (!stack.func_190926_b() && FireSource.useSource(world, pos, face, player, hand, stack, hitX, hitY, hitZ) && RecipeHelper.isOreName(tile.getSlotStack(0), "tinder")) {
                    world.func_180501_a(pos, state.func_177226_a((IProperty)ILit.LIT, (Comparable)Boolean.valueOf(true)), 2);
                    tile.setSlotStack(0, ItemStack.field_190927_a);
                    if (world.func_180495_p(pos.func_177984_a()).func_177230_c().equals(Blocks.field_150350_a)) {
                        world.func_180501_a(pos.func_177984_a(), Blocks.field_150480_ab.func_176223_P(), 2);
                        return true;
                    }
                }
                if (stack.func_190926_b() && player.func_70093_af()) {
                    for (int i = 0; i < tile.getSlotListSize(); ++i) {
                        if (tile.getSlotStack(i).func_190926_b()) continue;
                        ItemStack take_stack = tile.getSlotStack(i);
                        ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)take_stack.func_77946_l());
                        tile.decrementSlot(i, tile.getSlotStack(i).func_190916_E(), tile.getSlotStack(i));
                        tile.updateBlock();
                        return true;
                    }
                }
            }
        }
        return false;
    }

    @Override
    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        if (!world.field_72995_K) {
            this.dropSlotItems(world, pos);
        }
        super.func_180663_b(world, pos, state);
    }

    public void dropSlotItems(World world, BlockPos pos) {
        TileFirePit tile;
        if (world.func_82736_K().func_82766_b("doTileDrops") && (tile = (TileFirePit)world.func_175625_s(pos)) != null) {
            for (ItemStack stack : tile.getSlotList()) {
                if (stack == null) continue;
                float offset = 0.7f;
                double offsetX = (double)(RANDOM.nextFloat() * offset) + (double)(1.0f - offset) * 0.5;
                double offsetY = (double)(RANDOM.nextFloat() * offset) + (double)(1.0f - offset) * 0.5;
                double offsetZ = (double)(RANDOM.nextFloat() * offset) + (double)(1.0f - offset) * 0.5;
                EntityItem item = new EntityItem(world, (double)pos.func_177958_n() + offsetX, (double)pos.func_177956_o() + offsetY, (double)pos.func_177952_p() + offsetZ, stack);
                item.func_174869_p();
                world.func_72838_d((Entity)item);
            }
        }
    }

    public void func_180658_a(World world, BlockPos pos, Entity entityIn, float fallDistance) {
        if (!world.field_72995_K && entityIn.canTrample(world, (Block)this, pos, fallDistance)) {
            this.dropSlotItems(world, pos);
            this.turnToGravel(world, pos);
        }
        super.func_180658_a(world, pos, entityIn, fallDistance);
    }

    private void turnToGravel(World p_190970_1_, BlockPos p_190970_2_) {
        IBlockState iblockstate = Blocks.field_150351_n.func_176223_P();
        p_190970_1_.func_175656_a(p_190970_2_, iblockstate);
        AxisAlignedBB axisalignedbb = iblockstate.func_185890_d((IBlockAccess)p_190970_1_, p_190970_2_).func_186670_a(p_190970_2_);
        for (Entity entity : p_190970_1_.func_72839_b((Entity)null, axisalignedbb)) {
            entity.func_70107_b(entity.field_70165_t, axisalignedbb.field_72337_e, entity.field_70161_v);
        }
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Override
    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState state, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        if (((Boolean)state.func_177229_b((IProperty)ILit.LIT)).booleanValue()) {
            double d0 = (double)pos.func_177958_n() + 0.5;
            double d1 = (double)pos.func_177956_o() + 0.96;
            double d2 = (double)pos.func_177952_p() + 0.5;
            double d11 = (double)pos.func_177956_o() + (world.func_175623_d(pos.func_177984_a()) ? 1.0 : 1.5);
            double d4 = rand.nextDouble() * 0.6 - 0.3;
            double xSpeed = 0.05 - RANDOM.nextDouble(0.0, 0.1);
            double ySpeed = RANDOM.nextDouble(0.0, 0.065);
            int chance = RANDOM.nextInt(4);
            if (PrimalAPI.randomCheck(0.1)) {
                world.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, SoundEvents.field_187652_bv, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
            }
            switch (chance) {
                case 0: {
                    world.func_175688_a(EnumParticleTypes.FLAME, d0 + d4, d1, d2 + d4, 0.0, ySpeed, 0.0, new int[0]);
                    world.func_175688_a(EnumParticleTypes.FLAME, d0 + d4, d1, d2 - d4, 0.0, ySpeed, 0.0, new int[0]);
                    world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0 + d4, d11, d2 + d4, xSpeed, ySpeed, ySpeed, new int[0]);
                    world.func_175688_a(EnumParticleTypes.SMOKE_LARGE, d0 + d4, d11, d2 - d4, xSpeed, ySpeed, ySpeed, new int[0]);
                    break;
                }
                case 1: {
                    world.func_175688_a(EnumParticleTypes.FLAME, d0 + d4, d1, d2 - d4, 0.0, ySpeed, 0.0, new int[0]);
                    world.func_175688_a(EnumParticleTypes.FLAME, d0 - d4, d1, d2 + d4, 0.0, ySpeed, 0.0, new int[0]);
                    world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0 + d4, d11, d2 - d4, xSpeed, ySpeed, ySpeed, new int[0]);
                    world.func_175688_a(EnumParticleTypes.SMOKE_LARGE, d0 - d4, d11, d2 + d4, xSpeed, ySpeed, ySpeed, new int[0]);
                    break;
                }
                case 2: {
                    world.func_175688_a(EnumParticleTypes.FLAME, d0 - d4, d1, d2 + d4, 0.0, ySpeed, 0.0, new int[0]);
                    world.func_175688_a(EnumParticleTypes.FLAME, d0 - d4, d1, d2 - d4, 0.0, ySpeed, 0.0, new int[0]);
                    world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0 - d4, d11, d2 + d4, xSpeed, ySpeed, ySpeed, new int[0]);
                    world.func_175688_a(EnumParticleTypes.SMOKE_LARGE, d0 - d4, d11, d2 - d4, xSpeed, ySpeed, ySpeed, new int[0]);
                    break;
                }
                case 3: {
                    world.func_175688_a(EnumParticleTypes.FLAME, d0 - d4, d1, d2 - d4, 0.0, ySpeed, 0.0, new int[0]);
                    world.func_175688_a(EnumParticleTypes.FLAME, d0 + d4, d1, d2 + d4, 0.0, ySpeed, 0.0, new int[0]);
                    world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0 - d4, d11, d2 - d4, xSpeed, ySpeed, ySpeed, new int[0]);
                    world.func_175688_a(EnumParticleTypes.SMOKE_LARGE, d0 + d4, d11, d2 + d4, xSpeed, ySpeed, ySpeed, new int[0]);
                }
            }
        }
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{ILit.LIT});
    }

    public int func_176201_c(IBlockState state) {
        int i = 0;
        if (!((Boolean)state.func_177229_b((IProperty)ILit.LIT)).booleanValue()) {
            i = 0;
            return i;
        }
        if (((Boolean)state.func_177229_b((IProperty)ILit.LIT)).booleanValue()) {
            i = 1;
            return i;
        }
        return i;
    }

    public IBlockState func_176203_a(int meta) {
        IBlockState iblockstate = this.func_176223_P();
        if (meta == 0) {
            iblockstate = iblockstate.func_177226_a((IProperty)ILit.LIT, (Comparable)Boolean.valueOf(false));
        }
        if (meta == 1) {
            iblockstate = iblockstate.func_177226_a((IProperty)ILit.LIT, (Comparable)Boolean.valueOf(true));
        }
        return iblockstate;
    }
}

