/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.blocks.lighting;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockTorch;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemHandlerHelper;
import nmd.primal.core.api.PrimalAPI;
import nmd.primal.core.api.interfaces.ILit;
import nmd.primal.core.api.interfaces.IPickup;
import nmd.primal.core.common.helper.FireHelper;
import nmd.primal.core.common.init.ModConfig;

public class Torch
extends BlockTorch
implements ILit,
IPickup {
    private final boolean can_expire;
    private final int burn_rate;
    private final int light_level;

    public Torch(float light, int rate, boolean can_expire, SoundType sound) {
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)field_176596_a, (Comparable)EnumFacing.UP).func_177226_a((IProperty)ILit.LIT, (Comparable)Boolean.valueOf(false)));
        this.func_149675_a(can_expire);
        this.func_149672_a(sound);
        this.func_149711_c(0.0f);
        this.func_149752_b(0.0f);
        this.can_expire = can_expire;
        this.burn_rate = rate;
        this.light_level = (int)(15.0f * light);
    }

    public ItemStack getLitTorch() {
        return this == PrimalAPI.Blocks.TORCH_WOOD ? new ItemStack(Blocks.field_150478_aa) : new ItemStack(PrimalAPI.Items.TORCH_NETHER_LIT);
    }

    @Override
    public boolean doLite(World world, BlockPos pos, IBlockState state, EnumFacing face, EntityLivingBase entity) {
        if (world.field_72995_K) {
            return true;
        }
        if (!this.isLit((IBlockAccess)world, pos, state) && world.func_180501_a(pos, state.func_177226_a((IProperty)ILit.LIT, (Comparable)Boolean.valueOf(true)), 2)) {
            FireHelper.makeSmoke(world, pos, 16);
            world.func_184133_a(null, pos, SoundEvents.field_187643_bs, SoundCategory.BLOCKS, 1.0f, RANDOM.nextFloat() * 0.4f + 0.8f);
            return true;
        }
        return false;
    }

    @Override
    public boolean doExtinguish(World world, BlockPos pos, IBlockState state, EnumFacing face, EntityLivingBase entity) {
        if (world.field_72995_K) {
            return true;
        }
        if (this.isLit((IBlockAccess)world, pos, state) && world.func_180501_a(pos, state.func_177226_a((IProperty)ILit.LIT, (Comparable)Boolean.valueOf(false)), 2)) {
            FireHelper.makeSmoke(world, pos, 16);
            world.func_184133_a(null, pos, SoundEvents.field_187646_bt, SoundCategory.BLOCKS, 1.0f, RANDOM.nextFloat() * 0.4f + 0.8f);
            return true;
        }
        return false;
    }

    @Override
    public boolean toggle(World world, BlockPos pos, IBlockState state, EnumFacing face, EntityLivingBase entity) {
        return this.isLit((IBlockAccess)world, pos, state) ? this.doExtinguish(world, pos, state, face, entity) : this.doLite(world, pos, state, face, entity);
    }

    @Override
    public boolean canExtinguish(World world, BlockPos pos, IBlockState state, EnumFacing face, @Nullable EntityLivingBase entity) {
        return true;
    }

    @Override
    public boolean canPickup(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        return ModConfig.Features.ENABLE_TORCH_PICKUP;
    }

    @Override
    public boolean doPickup(World world, BlockPos pos, IBlockState state, EnumFacing face, EntityPlayer player, EnumHand hand) {
        ItemStack stack;
        ItemStack dropitem = new ItemStack(Item.func_150898_a((Block)this));
        if (this.isLit((IBlockAccess)world, pos, state)) {
            world.func_184133_a(null, pos, SoundEvents.field_187643_bs, SoundCategory.BLOCKS, 1.0f, RANDOM.nextFloat() + 2.6f - RANDOM.nextFloat() * 0.8f);
            stack = this == PrimalAPI.Blocks.TORCH_WOOD ? new ItemStack(Blocks.field_150478_aa) : new ItemStack(PrimalAPI.Items.TORCH_NETHER_LIT);
        } else {
            stack = dropitem;
        }
        if (world.func_175698_g(pos)) {
            ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)stack);
            return true;
        }
        return false;
    }

    public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return this.isLit(world, pos, world.func_180495_p(pos)) ? 60 : 0;
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        if (PrimalAPI.randomCheckFail(this.burn_rate) && this.isLit((IBlockAccess)world, pos, state) && !entity.func_70026_G() && !entity.func_70045_F() && entity instanceof EntityLivingBase) {
            entity.func_70015_d(2);
        }
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (world.field_72995_K) {
            return;
        }
        int torch_life_span = this.getTorchLifeSpan(world, pos);
        if (PrimalAPI.randomCheckFail(torch_life_span)) {
            PrimalAPI.logger(65, "torch going out: " + this.isLit((IBlockAccess)world, pos, state) + ", span: " + torch_life_span);
            this.doExtinguish(world, pos, state, EnumFacing.UP, null);
        }
    }

    public int getTorchLifeSpan(World world, BlockPos pos) {
        int base_life_span = ModConfig.Lighting.TORCH_LIFESPAN;
        int life_span = 0;
        if (this.can_expire && base_life_span > 0) {
            if (world.func_175727_C(pos)) {
                PrimalAPI.logger(65, "torch is getting precipitation");
                life_span = base_life_span;
                if (world.canSnowAtBody(pos, false)) {
                    PrimalAPI.logger(65, "torch is getting snow");
                    life_span *= 2;
                }
            } else if (ModConfig.Lighting.TORCHES_DIE) {
                PrimalAPI.logger(65, "torches die");
                life_span = base_life_span * 4;
            }
        }
        PrimalAPI.logger(65, "torch life span: " + life_span);
        return life_span;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)this);
    }

    public EnumPushReaction func_149656_h(IBlockState state) {
        return EnumPushReaction.DESTROY;
    }

    public boolean func_149659_a(Explosion explosionIn) {
        return false;
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        return this.isLit(world, pos, state) ? this.light_level : 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        if (this.isLit((IBlockAccess)world, pos, state)) {
            EnumParticleTypes smoke = world.func_175727_C(pos) ? EnumParticleTypes.SMOKE_LARGE : EnumParticleTypes.SMOKE_NORMAL;
            EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)field_176596_a);
            double d0 = (double)pos.func_177958_n() + 0.5;
            double d1 = (double)pos.func_177956_o() + 0.7;
            double d2 = (double)pos.func_177952_p() + 0.5;
            double d3 = 0.22;
            double d4 = 0.27;
            if (facing.func_176740_k().func_176722_c()) {
                EnumFacing opposite = facing.func_176734_d();
                world.func_175688_a(smoke, d0 + d4 * (double)opposite.func_82601_c(), d1 + d3, d2 + d4 * (double)opposite.func_82599_e(), 0.0, 0.0, 0.0, new int[0]);
                world.func_175688_a(EnumParticleTypes.FLAME, d0 + d4 * (double)opposite.func_82601_c(), d1 + d3, d2 + d4 * (double)opposite.func_82599_e(), 0.0, 0.0, 0.0, new int[0]);
            } else {
                world.func_175688_a(smoke, d0, d1, d2, 0.0, 0.0, 0.0, new int[0]);
                world.func_175688_a(EnumParticleTypes.FLAME, d0, d1, d2, 0.0, 0.0, 0.0, new int[0]);
            }
        }
    }

    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing face, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        boolean lit = false;
        if (this.canPlaceAt(world, pos, face)) {
            return this.func_176223_P().func_177226_a((IProperty)field_176596_a, (Comparable)face).func_177226_a((IProperty)ILit.LIT, (Comparable)Boolean.valueOf(lit));
        }
        for (EnumFacing enumfacing : EnumFacing.Plane.HORIZONTAL) {
            if (!world.isSideSolid(pos.func_177972_a(enumfacing.func_176734_d()), enumfacing, true)) continue;
            return this.func_176223_P().func_177226_a((IProperty)field_176596_a, (Comparable)enumfacing).func_177226_a((IProperty)ILit.LIT, (Comparable)Boolean.valueOf(lit));
        }
        return this.func_176223_P();
    }

    private boolean canPlaceAt(World world, BlockPos pos, EnumFacing facing) {
        BlockPos blockpos = pos.func_177972_a(facing.func_176734_d());
        boolean flag = facing.func_176740_k().func_176722_c();
        return flag && world.isSideSolid(blockpos, facing, true) || facing == EnumFacing.UP && this.canPlaceOn(world, blockpos);
    }

    private boolean canPlaceOn(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        return state.isSideSolid((IBlockAccess)world, pos, EnumFacing.UP) || state.func_177230_c().canPlaceTorchOnTop(state, (IBlockAccess)world, pos);
    }

    public static boolean canPlaceTorch(World world, BlockPos pos, EnumFacing facing) {
        BlockPos blockpos = pos.func_177972_a(facing.func_176734_d());
        IBlockState state = world.func_180495_p(pos);
        boolean flag = facing.func_176740_k().func_176722_c();
        return flag && world.isSideSolid(blockpos, facing, true) || facing == EnumFacing.UP && state.isSideSolid((IBlockAccess)world, pos, EnumFacing.UP) || state.func_177230_c().canPlaceTorchOnTop(state, (IBlockAccess)world, pos);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{field_176596_a, ILit.LIT});
    }

    public int func_176201_c(IBlockState state) {
        int i;
        switch ((EnumFacing)state.func_177229_b((IProperty)field_176596_a)) {
            case EAST: {
                i = 1;
                break;
            }
            case WEST: {
                i = 2;
                break;
            }
            case SOUTH: {
                i = 3;
                break;
            }
            case NORTH: {
                i = 4;
                break;
            }
            default: {
                i = 5;
            }
        }
        if (((Boolean)state.func_177229_b((IProperty)ILit.LIT)).booleanValue()) {
            i |= 8;
        }
        return i;
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing enumfacing;
        switch (meta & 7) {
            case 0: {
                enumfacing = EnumFacing.UP;
                break;
            }
            case 1: {
                enumfacing = EnumFacing.EAST;
                break;
            }
            case 2: {
                enumfacing = EnumFacing.WEST;
                break;
            }
            case 3: {
                enumfacing = EnumFacing.SOUTH;
                break;
            }
            case 4: {
                enumfacing = EnumFacing.NORTH;
                break;
            }
            default: {
                enumfacing = EnumFacing.UP;
            }
        }
        return this.func_176223_P().func_177226_a((IProperty)field_176596_a, (Comparable)enumfacing).func_177226_a((IProperty)ILit.LIT, (Comparable)Boolean.valueOf((meta & 8) > 0));
    }
}

