/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.blocks;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import nmd.primal.core.api.interfaces.IFace;
import nmd.primal.core.common.blocks.AbstractBlockType;
import nmd.primal.core.common.helper.CommonUtils;
import nmd.primal.core.common.tiles.AbstractTileType;
import nmd.primal.core.common.tiles.machines.TileShelf;

public abstract class AbstractShelf<TILE extends AbstractTileType>
extends AbstractBlockType<TILE>
implements IFace {
    private int shelf_size;

    public AbstractShelf(Material material, int size) {
        super(material);
        this.func_149713_g(0);
        this.shelf_size = size;
    }

    public AbstractShelf(Material material) {
        this(material, 64);
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileShelf();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable World player, List<String> tooltip, ITooltipFlag advanced) {
        tooltip.add(TextFormatting.GREEN + I18n.func_74838_a((String)"tooltip.info.primal.shelf_storage"));
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(IBlockState state, World world, RayTraceResult target, ParticleManager manager) {
        TileShelf tile = (TileShelf)world.func_175625_s(target.func_178782_a());
        if (tile != null && !tile.func_145837_r() && tile.getFrontFace() == target.field_178784_b) {
            return true;
        }
        return super.addHitEffects(state, world, target, manager);
    }

    private int getShelfSlot(TileShelf tile, float hitX, float hitY, float hitZ) {
        return this.getHorizontalShelfIndex(tile.getRotation(), hitX, hitZ) + this.getVerticalShelfIndex(hitY);
    }

    private int getHorizontalShelfIndex(int rotation, float hitX, float hitZ) {
        float hit_side = rotation == 0 || rotation == 2 ? hitX : hitZ;
        switch (rotation) {
            case 2: 
            case 3: {
                return hit_side > 0.5f ? 1 : 0;
            }
            case 0: 
            case 1: {
                return hit_side < 0.5f ? 1 : 0;
            }
        }
        return -10;
    }

    private int getVerticalShelfIndex(float hitY) {
        return hitY < 0.5f ? 2 : (hitY > 0.5f ? 0 : -10);
    }

    public void func_180649_a(World world, BlockPos pos, EntityPlayer player) {
        if (world.field_72995_K) {
            return;
        }
        TileShelf tile = (TileShelf)world.func_175625_s(pos);
        if (tile == null || tile.func_145837_r()) {
            return;
        }
        RayTraceResult rayResult = ForgeHooks.rayTraceEyes((EntityLivingBase)player, (double)(((EntityPlayerMP)player).field_71134_c.getBlockReachDistance() + 1.0));
        if (rayResult == null) {
            return;
        }
        EnumFacing side = rayResult.field_178784_b;
        if (side != tile.getFrontFace()) {
            return;
        }
        float hitX = (float)(rayResult.field_72307_f.field_72450_a - (double)pos.func_177958_n());
        float hitY = (float)(rayResult.field_72307_f.field_72448_b - (double)pos.func_177956_o());
        float hitZ = (float)(rayResult.field_72307_f.field_72449_c - (double)pos.func_177952_p());
        int slot = this.getShelfSlot(tile, hitX, hitY, hitZ);
        int size = player.func_70093_af() ? tile.getStorageHandler().getStackInSlot(slot).func_190916_E() : 1;
        ItemStack shelf_stack = tile.getStorageHandler().extractItem(slot, size, false);
        if (shelf_stack.func_190926_b() && size > 0) {
            return;
        }
        ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)shelf_stack.func_77946_l());
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing face, float hitX, float hitY, float hitZ) {
        if (hand == EnumHand.OFF_HAND) {
            return false;
        }
        if (world.field_72995_K) {
            return true;
        }
        TileShelf tile = (TileShelf)world.func_175625_s(pos);
        if (tile == null || tile.func_145837_r()) {
            return false;
        }
        if (face != tile.getFrontFace()) {
            return false;
        }
        int slot = this.getShelfSlot(tile, hitX, hitY, hitZ);
        if (slot > -1) {
            ItemStackHandler handler = tile.getStorageHandler();
            ItemStack held_stack = player.func_184614_ca();
            ItemStack shelf_stack = handler.getStackInSlot(slot);
            if (!shelf_stack.func_190926_b()) {
                if (!held_stack.func_190926_b() && held_stack.func_77969_a(shelf_stack)) {
                    if (shelf_stack.func_190916_E() <= handler.getSlotLimit(slot) && CommonUtils.addStack(handler, player, held_stack, slot)) {
                        SoundType soundtype = held_stack.func_77973_b() instanceof ItemBlock ? ((ItemBlock)held_stack.func_77973_b()).func_179223_d().func_185467_w() : SoundType.field_185848_a;
                        world.func_184148_a(null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
                    }
                } else {
                    ItemStack take_stack = handler.extractItem(slot, player.func_70093_af() ? shelf_stack.func_190916_E() : 1, false);
                    ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)take_stack.func_77946_l());
                }
            } else if (CommonUtils.addStack(tile.getStorageHandler(), player, held_stack, slot)) {
                SoundType soundtype = held_stack.func_77973_b() instanceof ItemBlock ? ((ItemBlock)held_stack.func_77973_b()).func_179223_d().func_185467_w() : SoundType.field_185848_a;
                world.func_184148_a(null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
            }
            return true;
        }
        return super.func_180639_a(world, pos, state, player, hand, face, hitX, hitY, hitZ);
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing face, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a((IProperty)IFace.FACING, (Comparable)placer.func_174811_aO());
    }

    public BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{IFace.FACING});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)IFace.FACING, (Comparable)this.getHorizontalFacingFromIndex(meta));
    }

    public int func_176201_c(IBlockState state) {
        return this.getHorizontalIndexFromState(state);
    }
}

