/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.blocks;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemStackHandler;
import nmd.primal.core.api.PrimalAPI;
import nmd.primal.core.api.interfaces.IPickup;
import nmd.primal.core.api.interfaces.types.ITypeMud;
import nmd.primal.core.api.interfaces.types.ITypeNBT;
import nmd.primal.core.common.blocks.AbstractBlockType;
import nmd.primal.core.common.helper.FXHelper;
import nmd.primal.core.common.helper.NBTHelper;
import nmd.primal.core.common.tiles.AbstractTilePottery;

public abstract class AbstractPottery<TILE extends AbstractTilePottery>
extends AbstractBlockType<TILE>
implements ITypeMud,
IPickup {
    public AbstractPottery() {
        super(Material.field_151576_e);
        this.setHarvestLevel("pickaxe", 0);
        this.func_149713_g(0);
    }

    public SoundType getSoundType(IBlockState state, World world, BlockPos pos, @Nullable Entity entity) {
        return PrimalAPI.Sounds.POTTERY;
    }

    public ItemStack getLid(World world, BlockPos pos, IBlockState state) {
        ITypeMud.EnumType type = (ITypeMud.EnumType)((Object)state.func_185899_b((IBlockAccess)world, pos).func_177229_b((IProperty)TYPE));
        switch (type) {
            case MUD: {
                return new ItemStack(PrimalAPI.Items.SMELTERY_LID_MUD);
            }
            case ADOBE: {
                return new ItemStack(PrimalAPI.Items.SMELTERY_LID_ADOBE);
            }
            case TERRA: {
                return new ItemStack(PrimalAPI.Items.SMELTERY_LID_TERRA);
            }
            case CINIS: {
                return new ItemStack(PrimalAPI.Items.SMELTERY_LID_CINIS);
            }
        }
        return ItemStack.field_190927_a;
    }

    public boolean isLid(World world, BlockPos pos, IBlockState state, ItemStack stack) {
        return this.getLid(world, pos, state).func_77969_a(stack);
    }

    @Override
    public boolean canPickup(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        TileEntity tile = world.func_175625_s(pos);
        return tile != null && !tile.func_145837_r() && tile instanceof AbstractTilePottery && ((AbstractTilePottery)tile).isCovered();
    }

    public void func_180649_a(World world, BlockPos pos, EntityPlayer player) {
        FXHelper.soundPotteryHit(world, pos, 1.5f);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing face, float hitX, float hitY, float hitZ) {
        FXHelper.soundPotteryHit(world, pos, 1.5f);
        return super.func_180639_a(world, pos, state, player, hand, face, hitX, hitY, hitZ);
    }

    public void func_180658_a(World world, BlockPos pos, Entity entity, float fallDistance) {
        super.func_180658_a(world, pos, entity, fallDistance);
        if (world.field_72995_K) {
            return;
        }
        FXHelper.soundPotteryHit(world, pos, 1.5f);
    }

    public void func_176199_a(World world, BlockPos pos, Entity entity) {
        super.func_176199_a(world, pos, entity);
    }

    public float getEnchantPowerBonus(World world, BlockPos pos) {
        float bonus = 0.0f;
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && !tile.func_145837_r() && tile instanceof AbstractTilePottery && ((AbstractTilePottery)tile).isCovered()) {
            ItemStackHandler handler = ((AbstractTilePottery)tile).getStorageHandler();
            for (int i = 0; i < handler.getSlots(); ++i) {
                ItemStack stored = handler.getStackInSlot(i);
                if (stored.func_77969_a(new ItemStack(PrimalAPI.Items.ASH_BONE)) && stored.func_190916_E() >= 16) {
                    bonus += 1.0f;
                    continue;
                }
                if (stored.func_77969_a(new ItemStack(PrimalAPI.Items.ASH_WOLF)) && stored.func_190916_E() >= 16) {
                    bonus += 1.0f;
                    continue;
                }
                if (stored.func_77969_a(new ItemStack(PrimalAPI.Blocks.ASH_YEW)) && stored.func_190916_E() >= 16) {
                    bonus += 1.0f;
                    continue;
                }
                if (stored.func_77969_a(new ItemStack(PrimalAPI.Items.OPAL))) {
                    bonus += 1.0f;
                    continue;
                }
                if (stored.func_77969_a(new ItemStack(Items.field_151166_bC))) {
                    bonus += 1.0f;
                    continue;
                }
                if (stored.func_77969_a(new ItemStack(Items.field_151045_i))) {
                    bonus += 1.0f;
                    continue;
                }
                if (stored.func_77969_a(new ItemStack(Items.field_151144_bL))) {
                    bonus += 1.0f;
                    continue;
                }
                if (stored.func_77969_a(new ItemStack(Items.field_151144_bL, 1, 1))) {
                    bonus += 2.0f;
                    continue;
                }
                if (stored.func_77969_a(new ItemStack(Items.field_190929_cY))) {
                    bonus += 3.0f;
                    continue;
                }
                if (stored.func_77969_a(new ItemStack(Items.field_151156_bN))) {
                    bonus += 6.0f;
                    continue;
                }
                if (!stored.func_77969_a(new ItemStack(Blocks.field_150380_bt))) continue;
                bonus += 6.0f;
            }
            PrimalAPI.logger(26, "pottery", "enchant bonus: " + bonus);
        }
        return bonus;
    }

    @Override
    public void dropItemsAndBlock(World world, BlockPos pos, IBlockState state) {
    }

    @Override
    public void func_176208_a(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
    }

    @Override
    public void func_180653_a(World world, BlockPos pos, IBlockState state, float chance, int fortune) {
    }

    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing face) {
        return face == EnumFacing.DOWN ? BlockFaceShape.SOLID : BlockFaceShape.UNDEFINED;
    }

    @Override
    public boolean func_176205_b(IBlockAccess world, BlockPos pos) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        for (ITypeMud.EnumType blocks$enumtype : ITypeMud.EnumType.values()) {
            ItemStack stack = new ItemStack((Block)this, 1, blocks$enumtype.getMetadata());
            NBTHelper.setString(stack, "type", blocks$enumtype.func_176610_l());
            list.add((Object)stack);
        }
    }

    public ItemStack func_185473_a(World world, BlockPos pos, IBlockState state) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && !tile.func_145837_r() && tile instanceof AbstractTilePottery) {
            ItemStack stack = new ItemStack((Block)this, 1, ITypeMud.EnumType.byName(((AbstractTilePottery)tile).getType()).getMetadata());
            NBTHelper.setString(stack, "type", ((AbstractTilePottery)tile).getType());
            return stack;
        }
        return super.func_185473_a(world, pos, state);
    }

    @Override
    public float func_176195_g(IBlockState state, World world, BlockPos pos) {
        return this.getTypeHardness((IBlockAccess)world, pos, world.func_180495_p(pos));
    }

    @Override
    public float getExplosionResistance(World world, BlockPos pos, @Nullable Entity exploder, Explosion explosion) {
        return this.getTypeResistance((IBlockAccess)world, pos, world.func_180495_p(pos));
    }

    @Override
    public boolean isFlammable(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return false;
    }

    @Override
    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return 0;
    }

    @Override
    public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return 0;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{TYPE, PrimalAPI.States.COVERED});
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && !tile.func_145837_r() && tile instanceof AbstractTilePottery) {
            return state.func_177226_a((IProperty)TYPE, (Comparable)((Object)ITypeMud.EnumType.byName(((ITypeNBT)tile).getType()))).func_177226_a((IProperty)PrimalAPI.States.COVERED, (Comparable)Boolean.valueOf(((AbstractTilePottery)tile).isCovered()));
        }
        return state;
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P();
    }
}

