/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.blocks;

import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLiving;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import nmd.primal.core.api.interfaces.IFace;
import nmd.primal.core.api.interfaces.IRotation;
import nmd.primal.core.common.blocks.AbstractBlock;

public abstract class AbstractContainer<TILE extends TileEntity>
extends AbstractBlock
implements ITileEntityProvider {
    public AbstractContainer(Material material, MapColor map_color) {
        super(material, map_color);
        this.field_149758_A = true;
    }

    public AbstractContainer(Material material) {
        this(material, material.func_151565_r());
    }

    public TILE getTileEntity(IBlockAccess world, BlockPos pos) {
        try {
            return (TILE)world.func_175625_s(pos);
        }
        catch (Exception var3) {
            throw new RuntimeException(var3);
        }
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    @Override
    public boolean canCreatureSpawn(IBlockState state, IBlockAccess world, BlockPos pos, EntityLiving.SpawnPlacementType type) {
        return false;
    }

    public boolean func_149700_E() {
        return false;
    }

    @Override
    public boolean func_176200_f(IBlockAccess world, BlockPos pos) {
        return false;
    }

    public boolean func_189539_a(IBlockState state, World world, BlockPos pos, int id, int param) {
        super.func_189539_a(state, world, pos, id, param);
        TileEntity tile = world.func_175625_s(pos);
        return tile != null && tile.func_145842_c(id, param);
    }

    public boolean rotateBlock(World world, BlockPos pos, EnumFacing face) {
        TileEntity tile;
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() instanceof IFace && face.func_176740_k().func_176722_c() && (tile = world.func_175625_s(pos)) != null && !tile.func_145837_r() && tile instanceof IRotation && world.func_180501_a(pos, state.func_177226_a((IProperty)IFace.FACING, (Comparable)face.func_176734_d()), 3)) {
            ((IRotation)tile).setRotation((byte)face.func_176734_d().func_176736_b());
            return true;
        }
        return false;
    }

    private boolean isInvalidNeighbor(World world, BlockPos pos, EnumFacing facing) {
        return world.func_180495_p(pos.func_177972_a(facing)).func_185904_a() == Material.field_151570_A;
    }

    private boolean hasInvalidNeighbor(World world, BlockPos pos) {
        return this.isInvalidNeighbor(world, pos, EnumFacing.NORTH) || this.isInvalidNeighbor(world, pos, EnumFacing.SOUTH) || this.isInvalidNeighbor(world, pos, EnumFacing.WEST) || this.isInvalidNeighbor(world, pos, EnumFacing.EAST);
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        this.dropItemsAndBlock(world, pos, state);
        world.func_175713_t(pos);
    }

    public void dropItemsAndBlock(World world, BlockPos pos, IBlockState state) {
    }
}

