/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.blocks;

import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityWitherSkull;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import nmd.primal.core.api.PrimalAPI;
import nmd.primal.core.api.interfaces.IFireProof;
import nmd.primal.core.api.interfaces.IPhased;
import nmd.primal.core.api.interfaces.IPickup;
import nmd.primal.core.api.interfaces.crafting.IDictionaryName;
import nmd.primal.core.common.PrimalCore;
import nmd.primal.core.common.helper.RegistryHelper;
import nmd.primal.core.common.helper.checks.BlockMultiplexer;

public abstract class AbstractBlock
extends Block
implements IDictionaryName<AbstractBlock>,
IFireProof<AbstractBlock> {
    protected static ThreadLocalRandom RANDOM = PrimalCore.RANDOM;
    private boolean is_fire_source;
    private boolean is_fire_proof;
    private boolean can_spawn;
    private String[] dictionary_names;

    public AbstractBlock(Material material, MapColor map_color) {
        super(material, map_color);
        this.func_149675_a(false);
    }

    public AbstractBlock(Material material) {
        this(material, material.func_151565_r());
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable World player, List<String> tooltip, ITooltipFlag advanced) {
        Item item = stack.func_77973_b();
        if (item instanceof ItemBlock && ((ItemBlock)item).func_179223_d() instanceof IPickup) {
            tooltip.add(TextFormatting.GREEN + I18n.func_74838_a((String)"tooltip.info.primal.abstract_pickup"));
        }
        if (this.is_fire_proof) {
            tooltip.add(TextFormatting.YELLOW + I18n.func_74838_a((String)"tooltip.info.primal.abstract_fire_proof"));
        }
    }

    public String getName() {
        return this.getRegistryName().toString();
    }

    public boolean isWet(World world, BlockPos pos) {
        return world.func_175727_C(pos.func_177984_a());
    }

    public Block setFireSource() {
        this.is_fire_source = true;
        return this;
    }

    public boolean getFireSource() {
        return this.is_fire_source;
    }

    @Override
    public AbstractBlock setDictionaryNames(String ... strings) {
        this.dictionary_names = strings;
        return this;
    }

    @Override
    public String[] getDictionaryNames() {
        return this.dictionary_names;
    }

    @Override
    public void registerDictionaryNames() {
        for (String name : this.getDictionaryNames()) {
            RegistryHelper.registerDictionaryNames(new ItemStack((Block)this, 1, Short.MAX_VALUE), name);
        }
    }

    public void func_185477_a(IBlockState state, World world, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entity, boolean isActualState) {
        if (!(this instanceof IPhased) || !((IPhased)((Object)this)).isPhasedAccessible((IBlockAccess)world, pos, state, entity) && !(entity instanceof EntityOcelot)) {
            super.func_185477_a(state, world, pos, entityBox, collidingBoxes, entity, isActualState);
        }
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        if (this instanceof IPhased && ((IPhased)((Object)this)).isPhased((IBlockAccess)world, pos, state) && ((IPhased)((Object)this)).isPhasedAccessible((IBlockAccess)world, pos, state, entity)) {
            entity.field_70159_w *= 0.75;
            entity.field_70179_y *= 0.75;
            entity.func_70066_B();
        }
    }

    public boolean func_176205_b(IBlockAccess world, BlockPos pos) {
        return this instanceof IPhased ? ((IPhased)((Object)this)).isPhased(world, pos, world.func_180495_p(pos)) && ((IPhased)((Object)this)).isPhasedAccessible(world, pos, world.func_180495_p(pos), null) : super.func_176205_b(world, pos);
    }

    public boolean func_176214_u(IBlockState state) {
        return this instanceof IPhased ? !((IPhased)((Object)this)).isPhased(state) : super.func_176214_u(state);
    }

    public PathNodeType getAiPathNodeType(IBlockState state, IBlockAccess world, BlockPos pos) {
        return this instanceof IPhased && ((IPhased)((Object)this)).isPhased(world.func_180495_p(pos)) ? PathNodeType.BLOCKED : super.getAiPathNodeType(state, world, pos);
    }

    @SideOnly(value=Side.CLIENT)
    public Vec3d getFogColor(World world, BlockPos pos, IBlockState state, Entity entity, Vec3d originalColor, float partialTicks) {
        return this instanceof IPhased && ((IPhased)((Object)this)).isPhasedAccessible((IBlockAccess)world, pos, state, entity) ? new Vec3d(0.0, 0.0, 0.0) : super.getFogColor(world, pos, state, entity, originalColor, partialTicks);
    }

    public AbstractBlock setCanSpawn(boolean can_spawn) {
        this.can_spawn = can_spawn;
        return this;
    }

    public boolean canCreatureSpawn(IBlockState state, IBlockAccess world, BlockPos pos, EntityLiving.SpawnPlacementType type) {
        return false;
    }

    @Override
    public AbstractBlock setFireProof(boolean is_fire_proof) {
        this.is_fire_proof = is_fire_proof;
        return this;
    }

    public boolean isFlammable(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return !this.is_fire_proof && this.getFlammability(world, pos, face) > 0;
    }

    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return this.is_fire_proof ? 0 : Blocks.field_150480_ab.func_176532_c((Block)this);
    }

    public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return this.is_fire_proof ? 0 : Blocks.field_150480_ab.func_176534_d((Block)this);
    }

    public boolean isFireSource(World world, BlockPos pos, EnumFacing face) {
        return this.is_fire_source && face == EnumFacing.UP;
    }

    public boolean func_176200_f(IBlockAccess world, BlockPos pos) {
        return false;
    }

    public boolean canSilkHarvest(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        return false;
    }

    public boolean isBlockFertile(IBlockState state) {
        return BlockMultiplexer.forBlock(PrimalAPI.Blocks.MUD_WET, PrimalAPI.Blocks.TERRA_BLOCK, PrimalAPI.Blocks.CINIS_BLOCK, PrimalAPI.Blocks.ORE_BOG_IRON, PrimalAPI.Blocks.SATETSU, PrimalAPI.Blocks.NETHER_EARTH, PrimalAPI.Blocks.NETHER_GROWTH).apply(state);
    }

    public boolean isFertile(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        PrimalAPI.logger(2, "fertile", "block: " + state.func_177230_c());
        if (BlockMultiplexer.forBlock(PrimalAPI.Blocks.LOAM_BLOCK, PrimalAPI.Blocks.NETHER_FARMLAND).apply(state)) {
            return (Integer)state.func_177229_b((IProperty)PrimalAPI.States.MOISTURE) > 0;
        }
        if (this.isBlockFertile(state)) {
            return true;
        }
        return super.isFertile(world, pos);
    }

    protected boolean canSustainBush(IBlockState state) {
        return this.isBlockFertile(state);
    }

    public boolean canSustainPlant(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing direction, IPlantable plantable) {
        IBlockState plant = plantable.getPlant(world, pos.func_177972_a(direction));
        EnumPlantType plantType = plantable.getPlantType(world, pos.func_177972_a(direction));
        Block block = plant.func_177230_c();
        if (plantable instanceof BlockBush && this.isBlockFertile(state)) {
            return true;
        }
        switch (plantType) {
            case Desert: {
                return BlockMultiplexer.forBlock(PrimalAPI.Blocks.SATETSU, PrimalAPI.Blocks.ORE_SALT_FLAT).apply(state);
            }
            case Nether: {
                return BlockMultiplexer.forBlock(PrimalAPI.Blocks.NETHER_FARMLAND, PrimalAPI.Blocks.NETHER_GROWTH).apply(state);
            }
            case Crop: {
                return BlockMultiplexer.forBlock(PrimalAPI.Blocks.NETHER_FARMLAND, PrimalAPI.Blocks.LOAM_BLOCK).apply(state);
            }
            case Cave: {
                return state.isSideSolid(world, pos, EnumFacing.UP);
            }
            case Plains: {
                return this.isBlockFertile(state);
            }
        }
        return super.canSustainPlant(state, world, pos, direction, plantable);
    }

    public boolean canEntityDestroy(IBlockState state, IBlockAccess world, BlockPos pos, Entity entity) {
        if (entity instanceof EntityDragon) {
            return !BlockMultiplexer.forBlock(PrimalAPI.Blocks.STORAGE_CRATE, PrimalAPI.Blocks.ANCIENT_ICE, PrimalAPI.Blocks.ORE_SALT, PrimalAPI.Blocks.DRY_GRASS, PrimalAPI.Blocks.INANIS_GRASS, PrimalAPI.Blocks.CINERIS_BLOOM, PrimalAPI.Blocks.CINERIS_GRASS, PrimalAPI.Blocks.BLUE_STONE, PrimalAPI.Blocks.NIGHT_STONE, PrimalAPI.Blocks.STAIRS_NIGHT_STONE, PrimalAPI.Blocks.ERODED_END_STONE, PrimalAPI.Blocks.PURPURITE_STONE, PrimalAPI.Blocks.SOUL_GLASS, PrimalAPI.Blocks.OBSIDIAN_TRANSPARENT).apply(this.func_176223_P());
        }
        if (entity instanceof EntityWither) {
            return EntityWither.func_181033_a((Block)this) && this != PrimalAPI.Blocks.NIGHT_STONE && this != PrimalAPI.Blocks.STAIRS_NIGHT_STONE;
        }
        if (entity instanceof EntityWitherSkull) {
            return EntityWither.func_181033_a((Block)this) && this != PrimalAPI.Blocks.NIGHT_STONE && this != PrimalAPI.Blocks.STAIRS_NIGHT_STONE && this != PrimalAPI.Blocks.SOUL_GLASS && this != PrimalAPI.Blocks.OBSIDIAN_TRANSPARENT;
        }
        return super.canEntityDestroy(state, world, pos, entity);
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        int count = this.quantityDropped(state, fortune, RANDOM);
        for (int i = 0; i < count; ++i) {
            Item item = this.func_180660_a(state, RANDOM, fortune);
            if (item == Items.field_190931_a) continue;
            drops.add((Object)new ItemStack(item, 1, this.func_180651_a(state)));
        }
    }
}

