/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.block.Block;
import net.minecraft.command.ICommand;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLFingerprintViolationEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLLoadCompleteEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartedEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppedEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppingEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import nmd.primal.core.common.CommonProxy;
import nmd.primal.core.common.commands.PrimalCommand;
import nmd.primal.core.common.init.ModBlocks;
import nmd.primal.core.common.init.ModCapabilities;
import nmd.primal.core.common.init.ModCompat;
import nmd.primal.core.common.init.ModEntities;
import nmd.primal.core.common.init.ModFluids;
import nmd.primal.core.common.init.ModItems;
import nmd.primal.core.common.init.ModRecipes;
import nmd.primal.core.common.init.ModRegistries;
import nmd.primal.core.common.init.ModWorld;
import nmd.primal.core.common.network.ModNetwork;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="primal", name="primal", version="0.6.104", acceptedMinecraftVersions="[1.12.0, 1.13.0)", dependencies="required-after:forge@[14.21.1.2400,);after:thaumcraft;after:rustic;after:coralreef;after:mekanism;after:toughasnails;after:toolbox;after:thermalexpansion;after:thebetweenlands;after:biomesoplenty;after:undergroundbiomes;after:natura;after:stellarapi;after:stellarsky;after:quark;after:survivalist;after:tconstruct;after:immersiveengineering;after:techreborn;after:ic2;after:roguelike;after:traverse;after:combustfish;after:dynamictrees;after:waila;after:grue;after:nex;", updateJSON="http://insecure.www.nmd.so/primal/update.json", certificateFingerprint="67a0e286dc0d4b502f3c92ac20b953517b52d0a9")
public class PrimalCore {
    @Mod.Instance(value="primal")
    public static PrimalCore INSTANCE;
    @SidedProxy(clientSide="nmd.primal.core.client.ClientProxy", serverSide="nmd.primal.core.common.CommonProxy")
    public static CommonProxy PROXY;
    public static ThreadLocalRandom RANDOM;
    public static SimpleNetworkWrapper NETWORK;
    public static Logger LOGGER;
    public static final NonNullList<Item> ITEMS;
    public static final NonNullList<ItemBlock> ITEM_BLOCKS;
    public static final NonNullList<Block> BLOCKS;
    public static List<Block> COLOURED_BLOCKS;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        PROXY.preInit();
        ModNetwork.registerGuiHandler();
        ModNetwork.registerPackets();
        ModCapabilities.preInit();
        ModEntities.preInit();
        ModBlocks.preInit();
        ModItems.preInit();
        ModRecipes.preInit();
        ModCompat.preInit(event);
        ModRegistries.preInit(event);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        PROXY.init();
        ModCapabilities.init();
        ModCompat.init();
        ModBlocks.init();
        ModFluids.init();
        ModRecipes.init();
        ModWorld.init();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        PROXY.postInit();
        ModCapabilities.postInit();
        ModEntities.postInit();
        ModCompat.postInit();
        ModBlocks.postInit();
        ModRecipes.postInit();
    }

    @Mod.EventHandler
    public void onFingerprintViolation(FMLFingerprintViolationEvent event) {
        LOGGER.warn("Invalid fingerprint detected!");
    }

    @Mod.EventHandler
    public void loadComplete(FMLLoadCompleteEvent event) {
    }

    @Mod.EventHandler
    public void serverStopping(FMLServerStoppingEvent event) {
    }

    @Mod.EventHandler
    public void serverStarted(FMLServerStartedEvent event) {
    }

    @Mod.EventHandler
    public void serverStopped(FMLServerStoppedEvent event) {
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new PrimalCommand());
    }

    static {
        RANDOM = ThreadLocalRandom.current();
        NETWORK = NetworkRegistry.INSTANCE.newSimpleChannel("primal");
        LOGGER = LogManager.getLogger((String)"primal");
        ITEMS = NonNullList.func_191196_a();
        ITEM_BLOCKS = NonNullList.func_191196_a();
        BLOCKS = NonNullList.func_191196_a();
        COLOURED_BLOCKS = Lists.newArrayList();
        LOGGER.info("PrimalCore is not a core mod");
        Locale.setDefault(Locale.ENGLISH);
        FluidRegistry.enableUniversalBucket();
    }
}

