/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.client.render.tiles;

import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import nmd.primal.core.api.interfaces.IFace;

@SideOnly(value=Side.CLIENT)
public final class TileRenderHelper {
    public static int getRotationAdjustment(IBlockState state, int rotation) {
        Block block = state.func_177230_c();
        return block instanceof IFace ? ((IFace)block).getHorizontalIndexFromState(state) : rotation;
    }

    public static void initRenderAndRotate(IBlockState state, double x, double y, double z) {
        int rotation_adjusted = TileRenderHelper.getRotationAdjustment(state, 0);
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)(x + 0.5), (double)(y + 0.5), (double)(z + 0.5));
        GlStateManager.func_179152_a((float)0.25f, (float)0.25f, (float)0.25f);
        GlStateManager.func_179114_b((float)(90.0f * (float)(-rotation_adjusted - 2)), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179109_b((float)-1.5f, (float)-0.0f, (float)-1.0f);
    }

    public static void renderItem(World world, RenderItem renderItem, ItemStack stack, float rotation, float scale, float offset_x, float offset_y, float offset_z, float stump) {
        IBakedModel model = TileRenderHelper.getBakedItemModel(renderItem, stack, world, null);
        TextureManager textureManager = Minecraft.func_71410_x().func_110434_K();
        textureManager.func_110577_a(TextureMap.field_110575_b);
        textureManager.func_110581_b(TextureMap.field_110575_b).func_174936_b(false, false);
        GlStateManager.func_179123_a();
        GlStateManager.func_179094_E();
        GlStateManager.func_179129_p();
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179103_j((int)(Minecraft.func_71379_u() ? 7425 : 7424));
        GlStateManager.func_179109_b((float)offset_x, (float)0.0f, (float)offset_z);
        GlStateManager.func_179109_b((float)0.75f, (float)offset_y, (float)stump);
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
        GlStateManager.func_179114_b((float)rotation, (float)1.0f, (float)0.0f, (float)0.0f);
        RenderHelper.func_74518_a();
        renderItem.func_180454_a(stack, model);
        RenderHelper.func_74519_b();
        GlStateManager.func_179089_o();
        GlStateManager.func_179084_k();
        GlStateManager.func_179121_F();
        GlStateManager.func_179099_b();
        textureManager.func_110577_a(TextureMap.field_110575_b);
        textureManager.func_110581_b(TextureMap.field_110575_b).func_174935_a();
    }

    @Deprecated
    public static void renderItemWeird(World world, RenderItem renderItem, ItemStack stack, float rotation, float scale, float translate_x, float translate_z, float translate_y, float offset_z) {
        IBakedModel model = TileRenderHelper.getBakedItemModel(renderItem, stack, world, null);
        TextureManager textureManager = Minecraft.func_71410_x().func_110434_K();
        textureManager.func_110577_a(TextureMap.field_110575_b);
        textureManager.func_110581_b(TextureMap.field_110575_b).func_174936_b(false, false);
        GlStateManager.func_179123_a();
        GlStateManager.func_179094_E();
        GlStateManager.func_179129_p();
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179103_j((int)(Minecraft.func_71379_u() ? 7425 : 7424));
        GlStateManager.func_179137_b((double)translate_x, (double)0.0, (double)translate_z);
        GlStateManager.func_179109_b((float)0.75f, (float)translate_y, (float)offset_z);
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
        GlStateManager.func_179114_b((float)rotation, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        RenderHelper.func_74518_a();
        renderItem.func_180454_a(stack, model);
        RenderHelper.func_74519_b();
        GlStateManager.func_179089_o();
        GlStateManager.func_179084_k();
        GlStateManager.func_179121_F();
        GlStateManager.func_179099_b();
        textureManager.func_110577_a(TextureMap.field_110575_b);
        textureManager.func_110581_b(TextureMap.field_110575_b).func_174935_a();
    }

    public static IBakedModel getBakedItemModel(RenderItem renderItem, ItemStack stack, World world, EntityLivingBase entity) {
        IBakedModel model = renderItem.func_184393_a(stack, world, entity);
        model = ForgeHooksClient.handleCameraTransforms((IBakedModel)model, (ItemCameraTransforms.TransformType)ItemCameraTransforms.TransformType.NONE, (boolean)false);
        return model;
    }

    public static int getLight(World world, BlockPos pos, EnumFacing front_face) {
        int light = world.func_175626_b(pos.func_177984_a(), 0);
        int front = world.func_175626_b(pos.func_177967_a(front_face, 1), 0);
        int back = world.func_175626_b(pos.func_177967_a(front_face.func_176734_d(), 1), 0);
        if (front > light) {
            light = front;
        }
        if (back > front) {
            light = back;
        }
        return light;
    }

    public static int getAverageLight(World world, BlockPos pos) {
        int a = world.func_175626_b(pos.func_177984_a(), 0);
        int b = world.func_175626_b(pos.func_177977_b(), 0);
        int c = world.func_175626_b(pos.func_177978_c(), 0);
        int d = world.func_175626_b(pos.func_177968_d(), 0);
        int e = world.func_175626_b(pos.func_177974_f(), 0);
        int f = world.func_175626_b(pos.func_177976_e(), 0);
        if (b > a) {
            a = b;
        }
        if (c > a) {
            a = c;
        }
        if (d > a) {
            a = d;
        }
        if (e > a) {
            a = e;
        }
        if (f > a) {
            a = f;
        }
        return a;
    }
}

