/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.client.particles;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.world.World;
import nmd.primal.core.client.particles.ParticleTextureStitcher;

public abstract class ParticleFactory<F extends ParticleFactory<?, T>, T extends Particle> {
    private final ParticleTextureStitcher<T> stitcher;
    private final Class<T> type;
    private final ParticleArgs<?> baseArgs;
    private final ParticleArgs<?> defaultArgs;
    public static final Object EMPTY_ARG = new Object();
    private final BaseArgsBuilder<F, BaseArgsBuilder<F, ?, T>, T> baseArgsBuilder = BaseArgsBuilder.access$1400(this);

    public ParticleFactory(Class<T> type) {
        this(type, null);
    }

    public ParticleFactory(Class<T> type, @Nullable ParticleTextureStitcher<T> stitcher) {
        this.stitcher = stitcher;
        this.type = type;
        this.baseArgs = ParticleArgs.create();
        this.setBaseArguments(this.baseArgs);
        this.defaultArgs = ParticleArgs.create();
    }

    public final ParticleTextureStitcher<? extends Particle> getStitcher() {
        return this.stitcher;
    }

    public final Class<T> getType() {
        return this.type;
    }

    protected final T getParticle(ImmutableParticleArgs args) {
        T particle = this.createParticle(args);
        if (this.getStitcher() != null) {
            ((ParticleTextureStitcher.IParticleSpriteReceiver)particle).setStitchedSprites(this.getStitcher().getSprites());
        }
        particle.func_70538_b(args.r, args.g, args.b);
        particle.func_82338_g(args.a);
        return particle;
    }

    protected abstract T createParticle(ImmutableParticleArgs var1);

    protected void setBaseArguments(ParticleArgs<?> args) {
    }

    protected void setDefaultArguments(World world, double x, double y, double z, ParticleArgs<?> args) {
    }

    public BaseArgsBuilder<F, BaseArgsBuilder<F, ?, T>, T> getBaseArgsBuilder() {
        this.baseArgsBuilder.reset();
        return this.baseArgsBuilder;
    }

    public final T create(World world, double x, double y, double z, @Nullable ParticleArgs<?> args) {
        if (args == null) {
            args = ParticleArgs.get();
        }
        this.defaultArgs.reset();
        this.setDefaultArguments(world, x, y, z, this.defaultArgs);
        args.resetContainer();
        this.defaultArgs.resetContainer();
        boolean hasActualDefaults = this.defaultArgs.isColorSet() || this.defaultArgs.isMotionSet() || this.defaultArgs.isScaleSet() || this.defaultArgs.isDataSet();
        args = hasActualDefaults ? this.baseArgs.combineArgs(this.defaultArgs).combineArgs(args) : this.baseArgs.combineArgs(args);
        return this.getParticle(new ImmutableParticleArgs(world, x, y, z, args));
    }

    public final T spawn(World world, double x, double y, double z, @Nullable ParticleArgs<?> args) {
        T particle = this.create(world, x, y, z, args);
        if (particle != null) {
            Minecraft.func_71410_x().field_71452_i.func_78873_a(particle);
        }
        return particle;
    }

    public static final class BaseArgsBuilder<F extends ParticleFactory<?, ?>, B extends ParticleArgs<?>, C extends Particle>
    extends ParticleArgs<B> {
        private final ParticleFactory<?, ?> factory;

        private BaseArgsBuilder(ParticleFactory<?, ?> factory) {
            this.factory = factory;
        }

        private static <F extends ParticleFactory<?, ?>, B extends ParticleArgs<?>, C extends Particle> BaseArgsBuilder<F, B, C> create(ParticleFactory<?, ?> factory) {
            return new BaseArgsBuilder<F, B, C>(factory);
        }

        public final F buildBaseArgs() {
            ParticleArgs<?> container = ParticleArgs.create();
            container = this.combineArgs(container);
            container = ((ParticleFactory)this.factory).baseArgs.combineArgs(container);
            if (container.isMotionSet()) {
                ((ParticleFactory)this.factory).baseArgs.withMotion(container.getMotionX(), container.getMotionY(), container.getMotionZ());
            }
            if (container.isColorSet()) {
                ((ParticleFactory)this.factory).baseArgs.withColor(container.getColor());
            }
            if (container.isScaleSet()) {
                ((ParticleFactory)this.factory).baseArgs.withScale(container.getScale());
            }
            if (container.isDataSet()) {
                ((ParticleFactory)this.factory).baseArgs.withData(((ParticleArgs)container).data);
            }
            return (F)this.factory;
        }

        static /* synthetic */ BaseArgsBuilder access$1400(ParticleFactory x0) {
            return BaseArgsBuilder.create(x0);
        }
    }

    public static class ParticleArgs<T extends ParticleArgs<?>>
    implements Consumer<ParticleArgs<?>> {
        private static final ParticleArgs<?> BUILDER = ParticleArgs.create();
        private static final Object[] NO_DATA = new Object[0];
        private boolean motionSet = false;
        private double motionX;
        private double motionY;
        private double motionZ;
        private boolean scaleSet = false;
        private float scale;
        private boolean colorSet = false;
        private float r;
        private float g;
        private float b;
        private float a;
        private Object[] data;
        private boolean dataSet = false;
        private ParticleArgs<?> container;

        private ParticleArgs() {
            this.reset();
        }

        private static <F extends ParticleArgs<?>> ParticleArgs<F> create() {
            return new ParticleArgs();
        }

        private ParticleArgs(ParticleArgs<?> args) {
            if (args == null) {
                throw new NullPointerException("Particle args to copy must not be null");
            }
            this.motionSet = args.motionSet;
            this.motionX = args.motionX;
            this.motionY = args.motionY;
            this.motionZ = args.motionZ;
            this.scaleSet = args.scaleSet;
            this.scale = args.scale;
            this.colorSet = args.colorSet;
            this.r = args.r;
            this.g = args.g;
            this.b = args.b;
            this.a = args.a;
            if (args.data == NO_DATA || args.data.length == 0) {
                this.data = NO_DATA;
            } else {
                this.data = new Object[args.data.length];
                for (int i = 0; i < this.data.length; ++i) {
                    this.data[i] = args.data[i];
                }
            }
            this.dataSet = args.dataSet;
        }

        public static <F extends ParticleArgs<?>> ParticleArgs<F> copy(ParticleArgs<?> args) {
            return new ParticleArgs(args);
        }

        public final void reset() {
            this.motionX = 0.0;
            this.motionY = 0.0;
            this.motionZ = 0.0;
            this.scale = 1.0f;
            this.a = 1.0f;
            this.b = 1.0f;
            this.g = 1.0f;
            this.r = 1.0f;
            this.data = NO_DATA;
            this.dataSet = false;
            this.motionSet = false;
            this.scaleSet = false;
            this.colorSet = false;
            this.resetContainer();
        }

        protected final void resetContainer() {
            if (this.container != null) {
                this.container.motionX = this.motionX;
                this.container.motionY = this.motionY;
                this.container.motionZ = this.motionZ;
                this.container.scale = this.scale;
                this.container.r = this.r;
                this.container.g = this.g;
                this.container.b = this.b;
                this.container.a = this.a;
                this.container.data = this.data;
                this.container.dataSet = this.dataSet;
                this.container.motionSet = this.motionSet;
                this.container.scaleSet = this.scaleSet;
                this.container.colorSet = this.colorSet;
            }
        }

        public final T accept(Consumer<ParticleArgs<?>> consumer) {
            consumer.accept(this);
            return (T)this;
        }

        public final T withMotion(double motionX, double motionY, double motionZ) {
            this.motionX = motionX;
            this.motionY = motionY;
            this.motionZ = motionZ;
            this.motionSet = true;
            return (T)this;
        }

        public final T withScale(float scale) {
            this.scale = scale;
            this.scaleSet = true;
            return (T)this;
        }

        public final T withColor(float r, float g, float b, float a) {
            this.r = r;
            this.g = g;
            this.b = b;
            this.a = a;
            this.colorSet = true;
            return (T)this;
        }

        public final T withColor(int color) {
            return this.withColor((float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f, (float)(color >> 24 & 0xFF) / 255.0f);
        }

        public final T withColor(float[] color) {
            return this.withColor(color[0], color[1], color[2], color[3]);
        }

        public final T withData(Object ... data) {
            if (data == null || data.length == 0) {
                data = NO_DATA;
            }
            this.data = data;
            this.dataSet = true;
            return (T)this;
        }

        public final ArgumentDataBuilder<T> withDataBuilder() {
            return new ArgumentDataBuilder(this, null);
        }

        public final double getMotionX() {
            return this.motionX;
        }

        public final double getMotionY() {
            return this.motionY;
        }

        public final double getMotionZ() {
            return this.motionZ;
        }

        public final boolean isMotionSet() {
            return this.motionSet;
        }

        public final float getScale() {
            return this.scale;
        }

        public final boolean isScaleSet() {
            return this.scaleSet;
        }

        public final float[] getColor() {
            return new float[]{this.r, this.g, this.b, this.a};
        }

        public final boolean isColorSet() {
            return this.colorSet;
        }

        public final DataHelper getData() {
            return new DataHelper(this.data);
        }

        public final boolean isDataSet() {
            return this.dataSet;
        }

        public static ParticleArgs<?> get() {
            BUILDER.reset();
            return BUILDER;
        }

        protected final ParticleArgs<?> combineArgs(ParticleArgs<?> args) {
            ParticleArgs<Object> container = args.container;
            if (container == null) {
                args.container = ParticleArgs.copy(args);
                container = args.container;
            }
            if (!container.isMotionSet()) {
                container.withMotion(this.getMotionX(), this.getMotionY(), this.getMotionZ());
            }
            if (!container.isColorSet()) {
                container.withColor(this.getColor());
            }
            if (!container.isScaleSet()) {
                container.withScale(this.getScale());
            }
            if (this.isDataSet()) {
                Object[] initialAdditionalArgs = container.data;
                Object[] defaultArgs = this.data;
                Object[] additionalArgs = container.data;
                if (defaultArgs.length > initialAdditionalArgs.length) {
                    additionalArgs = new Object[defaultArgs.length];
                    container.withData(additionalArgs);
                }
                for (int i = 0; i < additionalArgs.length; ++i) {
                    if (i < initialAdditionalArgs.length) {
                        if (initialAdditionalArgs[i] == EMPTY_ARG) {
                            if (i >= defaultArgs.length) {
                                additionalArgs[i] = null;
                                continue;
                            }
                            additionalArgs[i] = defaultArgs[i];
                            continue;
                        }
                        additionalArgs[i] = initialAdditionalArgs[i];
                        continue;
                    }
                    if (i >= defaultArgs.length) continue;
                    additionalArgs[i] = defaultArgs[i];
                }
            }
            return container;
        }

        @Override
        public final void accept(ParticleArgs<?> defaultArgs) {
            defaultArgs.combineArgs(this);
        }

        public static final class ArgumentDataBuilder<T extends ParticleArgs<?>> {
            private int highestIndex = 0;
            private final Map<Integer, Object> setArgs = new HashMap<Integer, Object>();
            private final T args;

            private ArgumentDataBuilder(T args) {
                this.args = args;
            }

            public ArgumentDataBuilder<T> setData(int index, Object ... data) {
                if (index + data.length - 1 > this.highestIndex) {
                    this.highestIndex = index + data.length - 1;
                }
                for (int i = 0; i < data.length; ++i) {
                    this.setArgs.put(index + i, data[i]);
                }
                return this;
            }

            public ArgumentDataBuilder<T> setEmpty(int index) {
                return this.setData(index, EMPTY_ARG);
            }

            public T buildData() {
                Object[] data = new Object[this.highestIndex + 1];
                for (int i = 0; i < data.length; ++i) {
                    data[i] = EMPTY_ARG;
                }
                for (Map.Entry<Integer, Object> entry : this.setArgs.entrySet()) {
                    data[entry.getKey().intValue()] = entry.getValue();
                }
                ((ParticleArgs)this.args).withData(data);
                return this.args;
            }

            /* synthetic */ ArgumentDataBuilder(ParticleArgs x0, 1 x1) {
                this(x0);
            }
        }
    }

    public static class ImmutableParticleArgs {
        public final World world;
        public final double x;
        public final double y;
        public final double z;
        public final double motionX;
        public final double motionY;
        public final double motionZ;
        public final float scale;
        public final float r;
        public final float g;
        public final float b;
        public final float a;
        public final DataHelper data;

        public ImmutableParticleArgs(World world, double x, double y, double z, ParticleArgs<?> builder) {
            this.world = world;
            this.x = x;
            this.y = y;
            this.z = z;
            this.motionX = ((ParticleArgs)builder).motionX;
            this.motionY = ((ParticleArgs)builder).motionY;
            this.motionZ = ((ParticleArgs)builder).motionZ;
            this.scale = ((ParticleArgs)builder).scale;
            this.r = ((ParticleArgs)builder).r;
            this.g = ((ParticleArgs)builder).g;
            this.b = ((ParticleArgs)builder).b;
            this.a = ((ParticleArgs)builder).a;
            this.data = new DataHelper(((ParticleArgs)builder).data);
        }
    }

    public static final class DataHelper {
        private final Object[] data;

        private DataHelper(Object[] data) {
            this.data = data;
        }

        public Object[] getAll() {
            Object[] arr = new Object[this.data.length];
            for (int i = 0; i < arr.length; ++i) {
                arr[i] = this.data[i];
            }
            return arr;
        }

        public <T> T getObject(Class<T> type, int index) {
            return (T)this.data[index];
        }

        public <T> T[] getObjectArray(Class<T> type, int index) {
            return (Object[])this.data[index];
        }

        public Object getObject(int index) {
            return this.getObject(Object.class, index);
        }

        public Object[] getObjectArray(int index) {
            return this.getObjectArray(Object.class, index);
        }

        public byte getByte(int index) {
            return this.getObject(Number.class, index).byteValue();
        }

        public short getShort(int index) {
            return this.getObject(Number.class, index).shortValue();
        }

        public int getInt(int index) {
            return this.getObject(Number.class, index).intValue();
        }

        public long getLong(int index) {
            return this.getObject(Number.class, index).longValue();
        }

        public float getFloat(int index) {
            return this.getObject(Number.class, index).floatValue();
        }

        public double getDouble(int index) {
            return this.getObject(Number.class, index).doubleValue();
        }

        public boolean getBool(int index) {
            return this.getObject(Boolean.class, index);
        }

        public char getChar(int index) {
            return this.getObject(Character.class, index).charValue();
        }

        public byte[] getByteArray(int index) {
            return (byte[])this.getObject(index);
        }

        public short[] getShortArray(int index) {
            return (short[])this.getObject(index);
        }

        public int[] getIntArray(int index) {
            return (int[])this.getObject(index);
        }

        public long[] getLongArray(int index) {
            return (long[])this.getObject(index);
        }

        public float[] getFloatArray(int index) {
            return (float[])this.getObject(index);
        }

        public double[] getDoubleArray(int index) {
            return (double[])this.getObject(index);
        }

        public boolean[] getBoolArray(int index) {
            return (boolean[])this.getObject(index);
        }

        public char[] getCharArray(int index) {
            return (char[])this.getObject(index);
        }
    }
}

