/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.client;

import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ClientHelper {
    public static void resetGammaSetting() {
        if (Minecraft.func_71410_x().field_71474_y.field_74333_Y < 0.0f) {
            Minecraft.func_71410_x().field_71474_y.field_74333_Y = 0.5f;
        }
    }

    public static <E extends Entity> void registerEntityRenderer(Class<E> entityClass, Class<? extends Render<E>> renderClass) {
        RenderingRegistry.registerEntityRenderingHandler(entityClass, new EntityRenderFactory(renderClass));
    }

    public static void registerFluidModel(IFluidBlock fluidBlock) {
        Item item = Item.func_150898_a((Block)((Block)fluidBlock));
        assert (item != Items.field_190931_a);
        ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[0]);
        final ModelResourceLocation modelResourceLocation = new ModelResourceLocation("primal:fluid", fluidBlock.getFluid().getName());
        ModelLoader.setCustomMeshDefinition((Item)item, stack -> modelResourceLocation);
        ModelLoader.setCustomStateMapper((Block)((Block)fluidBlock), (IStateMapper)new StateMapperBase(){

            protected ModelResourceLocation func_178132_a(IBlockState p_178132_1_) {
                return modelResourceLocation;
            }
        });
    }

    public static class EntityRenderFactory<E extends Entity>
    implements IRenderFactory<E> {
        private Class<? extends Render<E>> renderClass;

        private EntityRenderFactory(Class<? extends Render<E>> renderClass) {
            this.renderClass = renderClass;
        }

        public Render<E> createRenderFor(RenderManager manager) {
            Render<E> renderer = null;
            try {
                renderer = this.renderClass.getConstructor(RenderManager.class).newInstance(manager);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return renderer;
        }
    }
}

