/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.client;

import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityOtherPlayerMP;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.FOVUpdateEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.RenderBlockOverlayEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import nmd.primal.core.api.PrimalAPI;
import nmd.primal.core.api.enums.EnumArmorSet;
import nmd.primal.core.client.ClientHelper;
import nmd.primal.core.client.ClientSettings;
import nmd.primal.core.common.PrimalCore;
import nmd.primal.core.common.fluids.AbstractFluidBlock;
import nmd.primal.core.common.helper.CompatHelper;
import nmd.primal.core.common.helper.PlayerHelper;
import nmd.primal.core.common.helper.WorldHelper;
import nmd.primal.core.common.init.ModCapabilities;
import nmd.primal.core.common.init.ModCompat;
import nmd.primal.core.common.init.ModConfig;
import nmd.primal.core.common.init.ModFluids;
import nmd.primal.core.common.init.ModInfo;
import nmd.primal.core.common.items.tools.PrimalBow;

@SideOnly(value=Side.CLIENT)
@Mod.EventBusSubscriber(value={Side.CLIENT}, modid="primal")
public class ClientEvents {
    @SubscribeEvent
    public static void registerModels(ModelRegistryEvent event) {
        ResourceLocation location;
        PrimalAPI.logger(1, "Registering Models");
        for (ItemBlock item : PrimalCore.ITEM_BLOCKS) {
            location = item.getRegistryName();
            if (location == null) continue;
            if (item.func_77614_k()) {
                NonNullList subItems = NonNullList.func_191196_a();
                item.func_150895_a(ModInfo.TAB_PRIMAL, subItems);
                for (ItemStack subItem : subItems) {
                    String subItemName = item.func_77667_c(subItem);
                    subItemName = subItemName.substring(subItemName.indexOf(".") + 8);
                    ModelLoader.setCustomModelResourceLocation((Item)item, (int)subItem.func_77960_j(), (ModelResourceLocation)new ModelResourceLocation("primal:" + subItemName, "inventory"));
                }
                continue;
            }
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation("primal:" + item.delegate.name().func_110623_a(), "inventory"));
        }
        for (ItemBlock item : PrimalCore.ITEMS) {
            location = item.getRegistryName();
            if (location == null) continue;
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(location, "inventory"));
        }
        ModFluids.FLUID_BLOCKS.forEach(ClientHelper::registerFluidModel);
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void onUpdateFov(FOVUpdateEvent event) {
        ItemStack bow = event.getEntity().func_184607_cu();
        if (!bow.func_190926_b() && bow.func_77973_b() instanceof PrimalBow) {
            int usedTicks = bow.func_77973_b().func_77626_a(bow) - event.getEntity().func_184605_cv();
            float strength = (float)usedTicks / 20.0f;
            if ((strength = (strength * strength + strength * 2.0f) / 3.0f * 1.15f) > 1.0f) {
                strength = 1.0f;
            }
            event.setNewfov(1.0f - strength * 0.25f);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void onF3Menu(RenderGameOverlayEvent.Pre event) {
        if (ModConfig.Survival.HIDE_F3_INFO && event.getType() == RenderGameOverlayEvent.ElementType.DEBUG) {
            event.setCanceled(true);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=false)
    public static void onBlockOverlay(RenderBlockOverlayEvent event) {
        EntityPlayer player = event.getPlayer();
        World world = player.func_130014_f_();
        IBlockState state = event.getBlockForOverlay();
        Material material = state.func_185904_a();
        if (world.func_180495_p(event.getBlockPos()).func_177230_c() instanceof AbstractFluidBlock) {
            event.setCanceled(true);
        } else if (PlayerHelper.isNetherCapable((EntityLivingBase)player) && material == Material.field_151587_i) {
            event.setCanceled(true);
        } else if (CompatHelper.isSlotQuantum((EntityLivingBase)player, EntityEquipmentSlot.HEAD, ModCompat.IC2_QUANTUM_HELMET) && (material == Material.field_151586_h || material == Material.field_151587_i)) {
            event.setCanceled(true);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
    public static void onFogDensity(EntityViewRenderEvent.FogDensity event) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        boolean helmet = CompatHelper.isSlotQuantum((EntityLivingBase)player, EntityEquipmentSlot.HEAD, ModCompat.IC2_QUANTUM_HELMET);
        if (PrimalAPI.randomCheck(100)) {
            PrimalAPI.logger(4, "fog", "density: " + event.getDensity());
        }
        if ((PlayerHelper.isNetherCapable((EntityLivingBase)player) || helmet) && player.func_70055_a(Material.field_151587_i)) {
            event.setDensity(0.7f);
            event.setCanceled(true);
        } else if (helmet && player.func_70055_a(Material.field_151586_h)) {
            event.setDensity(0.08f);
            event.setCanceled(true);
        } else if (WorldHelper.hasNetherFog() && player.field_71093_bK == -1) {
            event.setDensity((float)ModConfig.Worldgen.NETHER_FOG_DENSITY_OVERRIDE);
            event.setCanceled(true);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
    public static void onFogColor(EntityViewRenderEvent.FogColors event) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        World world = player.func_130014_f_();
        IBlockState state = event.getState();
        Material material = state.func_185904_a();
        if (Minecraft.func_71410_x().func_175606_aa() != null && PlayerHelper.isNetherCapable((EntityLivingBase)player) && !world.field_73011_w.func_177495_o() && !material.func_76224_d() && ModCapabilities.hasLightProtection((EntityPlayer)player)) {
            event.setRed(0.0656f);
            event.setGreen(0.0656f);
            event.setBlue(0.0656f);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
    public static void onRenderLiving(RenderLivingEvent.Specials.Pre event) {
        if (event.getEntity() instanceof EntityOtherPlayerMP) {
            EntityPlayer player = (EntityPlayer)event.getEntity();
            if ((ClientSettings.HIDE_PLAYER_NAMES || PlayerHelper.isPlayer(player) || PlayerHelper.isFullArmor((EntityLivingBase)player, EnumArmorSet.WOLF, EnumArmorSet.OVIS, EnumArmorSet.SINUOUS, EnumArmorSet.VITRIFIED)) && event.isCancelable()) {
                event.setCanceled(true);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player == null) {
            return;
        }
        boolean dimension_listed = ClientSettings.AMBIENT_LIGHT_DIMENSIONS.contains(player.field_71093_bK);
        if (ClientSettings.AMBIENT_LIGHT_GLOBAL && !dimension_listed || !ClientSettings.AMBIENT_LIGHT_GLOBAL && dimension_listed) {
            World world = player.func_130014_f_();
            float ambient_light = ClientSettings.AMBIENT_LIGHT_LEVEL;
            if (world.func_72971_b(1.0f) < 0.205f && world.field_73011_w.func_76569_d() && world.field_73011_w.func_191066_m()) {
                BlockPos pos = new BlockPos(player.field_70165_t, player.field_70163_u + 1.0, player.field_70161_v);
                float moon_phase = world.getCurrentMoonPhaseFactorBody();
                float light = Math.min(0.8f, world.func_175724_o(pos));
                if (moon_phase > 0.0f && light > 0.0f) {
                    float phase_factor = moon_phase * 0.24f;
                    if (world.func_72896_J()) {
                        phase_factor *= 0.5f;
                    }
                    ambient_light += phase_factor * light;
                }
            }
            Minecraft.func_71410_x().field_71474_y.field_74333_Y = ambient_light;
        } else {
            ClientHelper.resetGammaSetting();
        }
    }

    static {
        PrimalAPI.logger(1, "Registering Client Events");
    }
}

