/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.api.interfaces.crafting;

import java.util.List;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.registries.IForgeRegistryEntry;
import nmd.primal.core.api.PrimalAPI;
import nmd.primal.core.common.helper.StackHelper;

public interface ITileRecipe<RECIPE extends IForgeRegistryEntry.Impl<RECIPE>> {
    public boolean finishRecipe(RECIPE var1);

    public void onTakeOutput();

    public void onAddInput();

    default public boolean consumeItem(ItemStackHandler handler, int slot, int amount) {
        ItemStack consume = handler.extractItem(slot, amount, false);
        return !consume.func_190926_b();
    }

    default public NonNullList<ItemStack> takeAllOutputs() {
        NonNullList outputs = NonNullList.func_191196_a();
        ItemStackHandler handler = this.getOutputHandler();
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack output = handler.getStackInSlot(i);
            if (output.func_190926_b()) continue;
            outputs.add((Object)handler.extractItem(i, output.func_190916_E(), false));
            this.onTakeOutput();
        }
        return outputs;
    }

    default public ItemStack getInputStack(ItemStack stack) {
        return StackHelper.getStack(this.getInputHandler(), stack);
    }

    default public ItemStack getOutputStack(ItemStack stack) {
        return StackHelper.getStack(this.getOutputHandler(), stack);
    }

    default public boolean takeInput(EntityPlayer player) {
        return StackHelper.takeItemReverse(player, this.getInputHandler());
    }

    default public boolean takeOutput(EntityPlayer player) {
        return StackHelper.takeItem(player, this.getOutputHandler());
    }

    default public ItemStack addIngredients(ItemStack addStack) {
        if (!addStack.func_190926_b()) {
            ItemStackHandler handler = this.getInputHandler();
            int size = addStack.func_190916_E();
            if ((addStack = ItemHandlerHelper.insertItemStacked((IItemHandler)handler, (ItemStack)addStack.func_77946_l(), (boolean)false)).func_190916_E() < size) {
                this.onAddInput();
            }
        }
        return addStack;
    }

    default public boolean addIngredients(EntityItem entity) {
        ItemStack stack = entity.func_92059_d().func_77946_l();
        ItemStack added = this.addIngredients(stack);
        if (added.func_190926_b()) {
            entity.func_70106_y();
            return true;
        }
        entity.func_92058_a(added);
        return false;
    }

    default public ItemStack takeItem(ItemStackHandler handler, int slot) {
        ItemStack output;
        if (handler != null && !(output = handler.getStackInSlot(slot)).func_190926_b()) {
            return handler.extractItem(slot, output.func_190916_E(), false);
        }
        return ItemStack.field_190927_a;
    }

    public ItemStackHandler getInputHandler();

    public ItemStackHandler getOutputHandler();

    default public NBTTagCompound readRecipeHandlers(NBTTagCompound nbt) {
        ItemStackHandler handler = this.getInputHandler();
        if (handler != null) {
            if (nbt.func_150297_b("input", 10)) {
                handler.deserializeNBT(nbt.func_74775_l("input"));
            }
            if (nbt.func_150297_b("output", 10)) {
                handler.deserializeNBT(nbt.func_74775_l("output"));
            }
        }
        return nbt;
    }

    default public NBTTagCompound writeRecipeHandlers(NBTTagCompound nbt) {
        ItemStackHandler handler = this.getInputHandler();
        if (handler != null) {
            NBTTagCompound compound = handler.serializeNBT();
            nbt.func_74782_a("input", (NBTBase)compound);
            nbt.func_74782_a("output", (NBTBase)compound);
        }
        return nbt;
    }

    default public NBTTagCompound readRecipeItemHandler(NBTTagCompound nbt, ItemStackHandler itemStackHandler, String name) {
        if (nbt.func_150297_b(name, 10)) {
            itemStackHandler.deserializeNBT(nbt.func_74775_l(name));
        }
        return nbt;
    }

    default public NBTTagCompound writeRecipeItemHandler(NBTTagCompound nbt, ItemStackHandler itemStackHandler, String name) {
        NBTTagCompound compound = itemStackHandler.serializeNBT();
        nbt.func_74782_a(name, (NBTBase)compound);
        return nbt;
    }

    default public boolean removeItem(ItemStack stack, ItemStackHandler handler) {
        if (!stack.func_190926_b() && handler != null) {
            for (int i = 0; i < handler.getSlots(); ++i) {
                if (!handler.getStackInSlot(i).func_77969_a(stack)) continue;
                return this.consumeItem(handler, i, stack.func_190916_E());
            }
        }
        return false;
    }

    default public boolean removeInput(ItemStack stack) {
        return this.removeItem(stack, this.getInputHandler());
    }

    default public boolean removeOutput(ItemStack stack) {
        return this.removeItem(stack, this.getOutputHandler());
    }

    default public boolean hasInput() {
        ItemStackHandler handler = this.getInputHandler();
        if (handler != null) {
            for (int i = 0; i < handler.getSlots(); ++i) {
                if (handler.getStackInSlot(i).func_190926_b()) continue;
                return true;
            }
        }
        return false;
    }

    default public boolean hasInput(ItemStack match) {
        ItemStackHandler handler;
        if (!match.func_190926_b() && (handler = this.getInputHandler()) != null) {
            for (int i = 0; i < handler.getSlots(); ++i) {
                if (!handler.getStackInSlot(i).func_77969_a(match)) continue;
                return true;
            }
        }
        return false;
    }

    default public boolean hasOutput() {
        ItemStackHandler handler = this.getOutputHandler();
        if (handler != null) {
            for (int i = 0; i < handler.getSlots(); ++i) {
                if (handler.getStackInSlot(i).func_190926_b()) continue;
                return true;
            }
        }
        return false;
    }

    default public boolean hasOutputItem(ItemStack match) {
        ItemStackHandler handler;
        if (!match.func_190926_b() && (handler = this.getOutputHandler()) != null) {
            for (int i = 0; i < handler.getSlots(); ++i) {
                if (!handler.getStackInSlot(i).func_77969_a(match)) continue;
                return true;
            }
        }
        return false;
    }

    default public boolean canStoreItems(ItemStackHandler handler, List<ItemStack> items) {
        for (ItemStack stack : items) {
            ItemStack residue = ItemHandlerHelper.insertItemStacked((IItemHandler)handler, (ItemStack)stack.func_77946_l(), (boolean)true);
            if (!residue.func_190926_b()) continue;
            PrimalAPI.logger(28, "ITileRecipe", "canStoreItems: residue: " + residue.func_77977_a());
            return true;
        }
        return false;
    }

    default public boolean canStoreInput(List<ItemStack> items) {
        return this.canStoreItems(this.getInputHandler(), items);
    }

    default public boolean canStoreOutput(List<ItemStack> items) {
        return this.canStoreItems(this.getOutputHandler(), items);
    }
}

