/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.api.interfaces;

import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import nmd.primal.core.common.helper.FXHelper;
import nmd.primal.core.common.helper.FireHelper;

public interface ILit {
    public static final PropertyBool LIT = PropertyBool.func_177716_a((String)"lit");

    default public IBlockState getLitState(IBlockState state) {
        return state.func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(true));
    }

    default public IBlockState getUnLitState(IBlockState state) {
        return state.func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(false));
    }

    default public boolean isLit(IBlockAccess world, BlockPos pos, IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)LIT);
    }

    default public boolean doLite(World world, BlockPos pos, IBlockState state, EnumFacing face, @Nullable EntityLivingBase entity) {
        if (world.field_72995_K) {
            return true;
        }
        if (world.func_180501_a(pos, state.func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(true)), 2)) {
            FireHelper.makeSmoke(world, pos, 16);
            FXHelper.soundFireAmbient(world, pos, 1.0f);
            return true;
        }
        return false;
    }

    default public boolean doExtinguish(World world, BlockPos pos, IBlockState state, EnumFacing face, @Nullable EntityLivingBase entity) {
        if (world.field_72995_K) {
            return true;
        }
        if (this.isLit((IBlockAccess)world, pos, state) && world.func_180501_a(pos, state.func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(false)), 2)) {
            FireHelper.makeSmoke(world, pos, 16);
            FXHelper.soundFireExtinguish(world, pos, 1.0f);
            return true;
        }
        return false;
    }

    default public boolean canInteract(World world, BlockPos pos, IBlockState state, EnumFacing face, @Nullable EntityLivingBase entity) {
        return true;
    }

    default public boolean canLite(World world, BlockPos pos, IBlockState state, EnumFacing face, @Nullable EntityLivingBase entity) {
        return true;
    }

    default public boolean canExtinguish(World world, BlockPos pos, IBlockState state, EnumFacing face, @Nullable EntityLivingBase entity) {
        return true;
    }

    default public boolean toggle(World world, BlockPos pos, IBlockState state, EnumFacing face, @Nullable EntityLivingBase entity) {
        return this.isLit((IBlockAccess)world, pos, state) ? this.doExtinguish(world, pos, state, face, entity) : this.doLite(world, pos, state, face, entity);
    }
}

