/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.api.interfaces;

import com.google.common.base.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;

public interface IFace {
    public static final PropertyDirection FACING_FULL = PropertyDirection.func_177714_a((String)"facing");
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);

    default public EnumFacing getFacing(IBlockState state) {
        return (EnumFacing)state.func_177229_b((IProperty)FACING);
    }

    default public EnumFacing getPlacementFacing(EntityLivingBase placer) {
        return placer.func_174811_aO();
    }

    default public IBlockState getFacingState(EntityLivingBase placer, Block block) {
        return block.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)this.getPlacementFacing(placer));
    }

    default public IBlockState getRotation(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    default public IBlockState getMirror(IBlockState state, Mirror mirror) {
        return state.func_185907_a(mirror.func_185800_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    default public int getFacingIndexFromMeta(int meta) {
        int modifier = meta < 4 ? 0 : (meta < 8 ? 4 : (meta < 12 ? 8 : 12));
        return meta - modifier;
    }

    default public int getHorizontalIndexFromState(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b();
    }

    default public EnumFacing getHorizontalFacingFromIndex(int index) {
        switch (index) {
            case 1: {
                return EnumFacing.WEST;
            }
            case 2: {
                return EnumFacing.NORTH;
            }
            case 3: {
                return EnumFacing.EAST;
            }
        }
        return EnumFacing.SOUTH;
    }

    default public EnumFacing getFacing(int meta) {
        switch (meta & 3) {
            case 1: {
                return EnumFacing.WEST;
            }
            case 2: {
                return EnumFacing.NORTH;
            }
            case 3: {
                return EnumFacing.EAST;
            }
        }
        return EnumFacing.SOUTH;
    }

    default public int getMetaForFacing(EnumFacing facing) {
        switch (facing) {
            case WEST: {
                return 1;
            }
            case NORTH: {
                return 2;
            }
            case EAST: {
                return 3;
            }
        }
        return 0;
    }
}

