/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.api.interfaces;

import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.IStringSerializable;

public interface IEphemeral {
    public static final PropertyEnum<EnumStability> STABILITY = PropertyEnum.func_177709_a((String)"stability", EnumStability.class);

    public int getDecayRate();

    default public EnumStability getStability(IBlockState state) {
        return (EnumStability)((Object)state.func_177229_b(STABILITY));
    }

    default public boolean isStable(IBlockState state) {
        return this.getStability(state) == EnumStability.STABLE;
    }

    public static enum EnumStability implements IStringSerializable
    {
        STABLE("stable"),
        EPHEMERAL("ephemeral");

        private static final EnumStability[] META_LOOKUP;
        private final String name;

        private EnumStability(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public String func_176610_l() {
            return this.name;
        }

        public int getMetadata() {
            return this.ordinal();
        }

        public static EnumStability byMetadata(int meta) {
            if (meta < 0 || meta >= META_LOOKUP.length) {
                meta = 0;
            }
            return META_LOOKUP[meta];
        }

        static {
            META_LOOKUP = new EnumStability[EnumStability.values().length];
            EnumStability[] enumStabilityArray = EnumStability.values();
            int n = enumStabilityArray.length;
            for (int i = 0; i < n; ++i) {
                EnumStability blocks$enumtype;
                EnumStability.META_LOOKUP[blocks$enumtype.getMetadata()] = blocks$enumtype = enumStabilityArray[i];
            }
        }
    }
}

