/*
 * Decompiled with CFR 0.152.
 */
package fat_cat.configs;

import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ConfigHandler {
    public static final ConfigHandler INSTANCE = new ConfigHandler();
    public Configuration CONFIG;
    public static int FAT_CAT_MIN_SPAWN_SIZE;
    public static int FAT_CAT_MAX_SPAWN_SIZE;
    public static int FAT_CAT_SPAWN_PROBABILITY;
    public static int FAT_CAT_SPAWN_Y_HEIGHT;
    public static boolean FAT_CAT_ATTACK_MOBS;
    public static boolean FAT_CAT_ATTACK_CREATURES;
    public static boolean FAT_CAT_CUSTOM_NAME;
    public static String[] PREFIX;
    public static String[] FORENAME;
    public static String[] SURNAME;
    public final String[] usedCategories = new String[]{"Spawn Settings", "Attack Settings"};

    public void loadConfig(FMLPreInitializationEvent event) {
        this.CONFIG = new Configuration(event.getSuggestedConfigurationFile());
        this.CONFIG.load();
        this.syncConfigs();
    }

    private void syncConfigs() {
        FAT_CAT_MIN_SPAWN_SIZE = this.CONFIG.get("Spawn Settings", "Spawn Group Minimum Size", 1).getInt(1);
        FAT_CAT_MAX_SPAWN_SIZE = this.CONFIG.get("Spawn Settings", "Spawn Group Maximum Size", 3).getInt(3);
        FAT_CAT_SPAWN_PROBABILITY = this.CONFIG.get("Spawn Settings", "Spawn Chance Probability", 10).getInt(10);
        FAT_CAT_SPAWN_Y_HEIGHT = this.CONFIG.get("Spawn Settings", "Max Y Spawn Height", 256).getInt(256);
        FAT_CAT_CUSTOM_NAME = this.CONFIG.get("Spawn Settings", "Mobs Spawn with Custom Names", true).getBoolean(true);
        PREFIX = this.CONFIG.getStringList("Title", "Spawn Settings", new String[]{"Mr.", "Master", "Sir", "Lord", "Dr.", "Professor", " Duke", "Baron", "Earl", "Viscount"}, "Title Prefix eg. Mr, Dr, etc\n[You can have more then one title. It will randomly pick a title at spawn for each Mob.]");
        FORENAME = this.CONFIG.getStringList("Forename", "Spawn Settings", new String[]{"Bartholomew", "Criddlington", "Isembard", "Ishmail", "Crundle", "Faffington", "Thomaston", "Ezra", "Tarquell", "Obadiah"}, "1st Name of the Mob \n[You can have more then one name. It will randomly pick a name at spawn for each Mob.]");
        SURNAME = this.CONFIG.getStringList("Surname", "Spawn Settings", new String[]{"Smythe", "Poshtoff", "Pennyworth", "Brindleford", "Scottmangle", "Arkwright", "Granville", "Houghton", "Glenross", "Fumbleford"}, "2nd Name of the Mob \n[You can have more then one name. It will randomly pick a name at spawn for each Mob.]");
        FAT_CAT_ATTACK_MOBS = this.CONFIG.get("Attack Settings", "Attacks Monsters", false).getBoolean(false);
        FAT_CAT_ATTACK_CREATURES = this.CONFIG.get("Attack Settings", "Attacks Everything (Except Other Rich Industrialists)", false).getBoolean(false);
        if (this.CONFIG.hasChanged()) {
            this.CONFIG.save();
        }
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("fat_cat")) {
            this.syncConfigs();
        }
    }
}

