/*
 * Decompiled with CFR 0.152.
 */
package net.gobbob.mobends.pack;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import net.gobbob.mobends.client.model.entity.IBendsModel;
import net.gobbob.mobends.pack.BendsAction;
import net.gobbob.mobends.pack.BendsCondition;
import net.gobbob.mobends.pack.BendsTarget;
import net.gobbob.mobends.pack.PackManager;
import net.gobbob.mobends.util.EnumAxis;
import net.gobbob.mobends.util.GUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ImageBufferDownload;
import net.minecraft.client.renderer.ThreadDownloadImageData;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.util.ResourceLocation;

public class BendsPack {
    public static final ResourceLocation DEFAULT_THUMBNAIL_TEXTURE = new ResourceLocation("mobends", "textures/gui/default_pack_thumbnail.png");
    public static HashMap<String, BendsTarget> targets = new HashMap();
    private String filename;
    private String displayName;
    private String author;
    private String description;
    private URL downloadURL;
    private String thumbnailURL;
    private ResourceLocation thumbnailLocation;

    public BendsPack() {
    }

    public BendsPack(String filename, String displayName, String author, String description) {
        this.filename = filename;
        this.displayName = displayName;
        this.author = author;
        this.description = description;
        if (this.filename == null) {
            this.filename = BendsPack.constructName(displayName);
        }
    }

    public void readBasicInfo(File file) throws IOException {
        this.filename = file.getName();
        BufferedReader reader = new BufferedReader(new FileReader(file.getAbsolutePath()));
        String line = reader.readLine();
        while (line != null) {
            String data;
            if (line.startsWith("name:")) {
                data = line;
                this.displayName = BendsPack.formatStringData("name:", data);
            } else if (line.startsWith("author:")) {
                data = line;
                this.author = BendsPack.formatStringData("author:", data);
            } else if (line.startsWith("description:")) {
                data = line;
                this.description = BendsPack.formatStringData("description:", data);
            }
            line = reader.readLine();
        }
        reader.close();
    }

    public void apply() {
        targets.clear();
        if (this.filename == null) {
            return;
        }
        System.out.println("Applying a pack.");
        BufferedReader reader = null;
        boolean cachePack = false;
        if (this.downloadURL != null) {
            boolean downloadPack;
            boolean bl = downloadPack = PackManager.cachedDatabase.getEntry(this.filename) == null || PackManager.cachedDatabase.getEntry(this.filename).get("updatedDate") != PackManager.publicDatabase.getEntry(this.filename).get("updatedDate");
            if (!downloadPack) {
                try {
                    reader = new BufferedReader(new FileReader(new File(PackManager.cacheDirectory, this.filename)));
                    System.out.println("Reading a cached public pack.");
                }
                catch (FileNotFoundException e) {
                    downloadPack = true;
                }
            }
            if (downloadPack) {
                PackManager.cachedDatabase.addEntry(this.filename).set("updatedDate", PackManager.publicDatabase.getEntry(this.filename).get("updatedDate"));
                try {
                    reader = new BufferedReader(new InputStreamReader(this.downloadURL.openStream()));
                    System.out.println("Downloading a public pack.");
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                PackManager.cachedDatabase.saveToFile(PackManager.databaseCacheFile);
                cachePack = true;
            }
        } else {
            try {
                reader = new BufferedReader(new FileReader(new File(PackManager.localDirectory, this.filename)));
                System.out.println("Reading a local pack.");
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
        String[] lines = new String[]{};
        if (reader != null) {
            lines = GUtil.readLines(reader);
        }
        if (cachePack) {
            GUtil.writeLines(new File(PackManager.cacheDirectory, this.filename), lines);
        }
        String anim = "";
        BendsTarget target = null;
        for (String line : lines) {
            String data;
            if (line.startsWith("target")) {
                data = line;
                data = BendsPack.formatStringData("target", data);
                target = new BendsTarget(data.toLowerCase());
                targets.put(data.toLowerCase(), target);
                continue;
            }
            if (line.contains("anim")) {
                data = line;
                anim = BendsPack.formatStringData("anim", data).trim();
                if (target == null || target.conditions.containsKey(anim)) continue;
                target.conditions.put(anim, new BendsCondition(anim));
                continue;
            }
            if (!line.contains("@") || target == null) continue;
            target.getCondition(anim).addAction(BendsPack.getActionFromLine(line));
        }
    }

    public void downloadThumbnail() {
        ResourceLocation resourcelocation = new ResourceLocation("mobends", "bendsPackThumbnails/" + this.filename);
        ITextureObject itextureobject = Minecraft.func_71410_x().func_110434_K().func_110581_b(resourcelocation);
        if (itextureobject == null) {
            File file2 = new File(PackManager.cacheDirectory, this.filename + ".png");
            ImageBufferDownload iimagebuffer = new ImageBufferDownload();
            ThreadDownloadImageData threaddownloadimagedata = new ThreadDownloadImageData(file2, this.thumbnailURL, DEFAULT_THUMBNAIL_TEXTURE, null);
            Minecraft.func_71410_x().func_110434_K().func_110579_a(resourcelocation, (ITextureObject)threaddownloadimagedata);
        }
        this.thumbnailLocation = resourcelocation;
    }

    public void save() throws IOException {
        if (this.isPublic()) {
            return;
        }
        System.out.println("Saving " + this.filename);
        String tab = "\t";
        if (this.filename == null) {
            this.filename = BendsPack.constructName(this.displayName);
        }
        File packFile = new File(PackManager.localDirectory, this.filename + "");
        packFile.createNewFile();
        BufferedWriter os = new BufferedWriter(new FileWriter(packFile));
        os.write("name: \"" + this.displayName + "\"\n");
        os.write("author: \"" + this.author + "\"\n");
        os.write("description: \"" + this.description + "\"\n");
        os.newLine();
        for (BendsTarget target : targets.values()) {
            try {
                os.write("target " + target.mob + " {\n");
                for (BendsCondition condition : target.conditions.values()) {
                    try {
                        os.write("\tanim " + condition.getAnimationName() + " {\n");
                        for (int a = 0; a < condition.getActionAmount(); ++a) {
                            BendsAction action = condition.getAction(a);
                            os.write("\t\t@" + action.model + ":" + (action.property == BendsAction.EnumBoxProperty.ROT ? "rot" : (action.property == BendsAction.EnumBoxProperty.SCALE ? "scale" : "prerot")) + ":" + (action.axis == EnumAxis.X ? "x" : (action.axis == EnumAxis.Y ? "y" : (action.axis == EnumAxis.Z ? "z" : ""))) + " ");
                            for (int c = 0; c < action.calculations.size(); ++c) {
                                BendsAction.Calculation calc = action.calculations.get(c);
                                os.write(calc.operator == BendsAction.EnumOperator.SET ? "==" : (calc.operator == BendsAction.EnumOperator.ADD ? "+=" : (calc.operator == BendsAction.EnumOperator.SUBSTRACT ? "-=" : (calc.operator == BendsAction.EnumOperator.MULTIPLY ? "*=" : (calc.operator == BendsAction.EnumOperator.DIVIDE ? "/=" : "==")))));
                                if (c == 0) {
                                    os.write(" ");
                                    if (action.modifier != null) {
                                        os.write(":" + action.modifier.name().toLowerCase() + ":");
                                    }
                                }
                                os.write(calc.globalVar == null ? "" + calc.number : "$" + calc.globalVar);
                            }
                            os.write(" #" + action.smooth);
                            os.newLine();
                        }
                        os.write("\t}\n");
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                os.write("}\n\n");
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
        os.close();
    }

    public void saveBasicInfo() {
        if (this.isPublic()) {
            return;
        }
        String tab = "\t";
        if (this.filename == null) {
            this.filename = BendsPack.constructName(this.displayName);
        }
        File packFile = new File(PackManager.localDirectory, this.filename + "");
        try {
            String animationInfo = "";
            if (packFile.exists()) {
                animationInfo = GUtil.readFile(packFile);
                int index = animationInfo.indexOf("\ntarget");
                animationInfo = index >= 0 ? animationInfo.substring(index) : "";
            } else {
                packFile.createNewFile();
            }
            BufferedWriter os = new BufferedWriter(new FileWriter(packFile));
            os.write("name: \"" + this.displayName + "\"\n");
            os.write("author: \"" + this.author + "\"\n");
            os.write("description: \"" + this.description + "\"\n");
            os.write(animationInfo);
            os.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void rename(String newName) {
        if (this.filename.equalsIgnoreCase(newName) || this.isPublic()) {
            return;
        }
        this.filename = newName;
    }

    public BendsPack setThumbnailURL(String string) {
        this.thumbnailURL = string;
        if (this.thumbnailURL != null) {
            this.downloadThumbnail();
        }
        return this;
    }

    public BendsPack setDownloadURL(String string) {
        try {
            this.downloadURL = new URL(string);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        return this;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ResourceLocation getThumbnail() {
        return this.thumbnailLocation != null ? this.thumbnailLocation : DEFAULT_THUMBNAIL_TEXTURE;
    }

    public boolean isPublic() {
        return this.downloadURL != null;
    }

    public String getFilename() {
        return this.filename;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getAuthor() {
        return this.author;
    }

    public String getDescription() {
        return this.description;
    }

    public static String constructName(String argName) {
        String name = argName;
        name = name.toLowerCase();
        name = name.replace('.', ' ');
        name = name.trim();
        name = name.replace(" ", "_");
        return name;
    }

    public static BendsTarget createTarget(String id) {
        BendsTarget target = new BendsTarget(id);
        targets.put(id, target);
        return target;
    }

    public static String formatStringData(String header, String data) {
        if ((data = data.replaceFirst(header, "")).contains("\"")) {
            data = data.replaceAll("\"", "");
        }
        if (data.contains("{")) {
            data = data.replace("{", "");
        }
        data = data.trim();
        return data;
    }

    public static BendsAction getActionFromLine(String line) {
        int i;
        BendsAction action = new BendsAction();
        action.model = "";
        ArrayList<Operation> calcs = new ArrayList<Operation>();
        calcs.add(new Operation());
        int calc = 0;
        String smooth = "";
        int stage = 0;
        for (i = 0; i < line.length(); ++i) {
            if (stage == 0) {
                if (line.charAt(i) != '@') continue;
                stage = 1;
                continue;
            }
            if (stage == 1) {
                if (line.charAt(i) == ':') {
                    ++stage;
                    continue;
                }
                action.model = action.model + line.charAt(i);
                continue;
            }
            if (stage == 2) {
                if (line.charAt(i) != ' ') continue;
                ++stage;
                continue;
            }
            if (stage == 3) {
                if (line.charAt(i) == ' ') {
                    ++stage;
                    continue;
                }
                ((Operation)calcs.get((int)calc)).operator = ((Operation)calcs.get((int)calc)).operator + line.charAt(i);
                continue;
            }
            if (stage == 4) {
                if (line.charAt(i) == ' ') {
                    ++stage;
                    continue;
                }
                if (line.charAt(i) == '+' | line.charAt(i) == '-' | line.charAt(i) == '=' | line.charAt(i) == '*' | line.charAt(i) == '/') {
                    if (line.charAt(i + 1) == '=') {
                        calcs.add(new Operation());
                        ((Operation)calcs.get((int)(++calc))).operator = line.charAt(i) + "=";
                        ++i;
                        continue;
                    }
                    ((Operation)calcs.get((int)calc)).num = ((Operation)calcs.get((int)calc)).num + line.charAt(i);
                    continue;
                }
                ((Operation)calcs.get((int)calc)).num = ((Operation)calcs.get((int)calc)).num + line.charAt(i);
                continue;
            }
            if (stage != 5) continue;
            if (line.charAt(i) == ' ') {
                ++stage;
                continue;
            }
            smooth = smooth + (line.charAt(i) == '#' ? "" : Character.valueOf(line.charAt(i)));
        }
        for (i = 0; i < calcs.size(); ++i) {
            ((Operation)calcs.get((int)i)).num = ((Operation)calcs.get((int)i)).num.trim();
            for (BendsAction.EnumModifier modifier : BendsAction.EnumModifier.values()) {
                if (!((Operation)calcs.get((int)i)).num.contains(":" + modifier.name().toLowerCase() + ":")) continue;
                action.modifier = modifier;
                ((Operation)calcs.get((int)i)).num = ((Operation)calcs.get((int)i)).num.replaceAll(":" + modifier.name().toLowerCase() + ":", "");
                ((Operation)calcs.get((int)i)).num = ((Operation)calcs.get((int)i)).num.trim();
                break;
            }
            if (((Operation)calcs.get((int)i)).num.contains("$")) {
                ((Operation)calcs.get((int)i)).num = ((Operation)calcs.get((int)i)).num.replace("$", " ");
                ((Operation)calcs.get((int)i)).globalVar = ((Operation)calcs.get((int)i)).num = ((Operation)calcs.get((int)i)).num.trim();
                ((Operation)calcs.get((int)i)).num = "0";
            }
            ((Operation)calcs.get((int)i)).operator = ((Operation)calcs.get((int)i)).operator.trim();
            if (((Operation)calcs.get((int)i)).num.startsWith("#")) continue;
            action.calculations.add(new BendsAction.Calculation(BendsAction.getOperatorFromSymbol(((Operation)calcs.get((int)i)).operator), Float.parseFloat(((Operation)calcs.get((int)i)).num)).setGlobalVar(((Operation)calcs.get((int)i)).globalVar));
        }
        if (line.contains(":rot:")) {
            action.property = BendsAction.EnumBoxProperty.ROT;
        } else if (line.contains(":scale:")) {
            action.property = BendsAction.EnumBoxProperty.SCALE;
        } else if (line.contains(":prerot:")) {
            action.property = BendsAction.EnumBoxProperty.PREROT;
        }
        if (line.contains(":x")) {
            action.axis = EnumAxis.X;
        } else if (line.contains(":y")) {
            action.axis = EnumAxis.Y;
        } else if (line.contains(":z")) {
            action.axis = EnumAxis.Z;
        }
        action.smooth = smooth.isEmpty() ? 1.0f : Float.parseFloat(smooth);
        return action;
    }

    public static BendsTarget getTarget(String id) {
        return targets.get(id);
    }

    public static void animate(IBendsModel model, String target, String anim) {
        BendsTarget bTarget = BendsPack.getTarget(target);
        if (bTarget == null) {
            return;
        }
        bTarget.applyToModel(model, anim);
    }

    private static class Operation {
        public String operator = "";
        public String num = "";
        public String globalVar = null;
    }
}

