/*
 * Decompiled with CFR 0.152.
 */
package net.gobbob.mobends.client.gui.packeditor;

import net.gobbob.mobends.client.gui.packeditor.GuiPackEditor;
import net.gobbob.mobends.client.gui.packeditor.GuiPackList;
import net.gobbob.mobends.pack.BendsPack;
import net.gobbob.mobends.pack.PackManager;
import net.gobbob.mobends.util.Draw;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;

public class GuiPackEntry {
    public static final int HEIGHT = 31;
    public static final int MARGIN = 2;
    protected FontRenderer fontRenderer;
    protected GuiPackList packList;
    protected String originalName = "unnamed.bends";
    protected String name = "unnamed.bends";
    protected String displayName = "Unnamed";
    protected String author;
    protected String description;
    protected ResourceLocation thumbnailLocation;
    protected int x = 0;
    protected int y = 0;
    protected boolean hover = false;
    protected boolean selected = false;
    protected boolean applied;

    public GuiPackEntry() {
        this.author = Minecraft.func_71410_x().field_71439_g.func_70005_c_();
        this.description = "A custom pack made by " + Minecraft.func_71410_x().field_71439_g.func_70005_c_() + ".";
        this.thumbnailLocation = BendsPack.DEFAULT_THUMBNAIL_TEXTURE;
        this.applied = false;
        this.fontRenderer = Minecraft.func_71410_x().field_71466_p;
    }

    public GuiPackEntry(GuiPackList packList) {
        this();
        this.packList = packList;
    }

    public GuiPackEntry(GuiPackList packList, BendsPack pack) {
        this(packList);
        this.name = pack.getFilename();
        this.originalName = pack.getFilename();
        this.displayName = pack.getDisplayName();
        this.author = pack.getAuthor();
        this.description = pack.getDescription();
        this.thumbnailLocation = pack.getThumbnail();
        this.applied = PackManager.getCurrentPack() != null && PackManager.getCurrentPack().getFilename().equalsIgnoreCase(pack.getFilename());
    }

    public void initGui(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public void update(int mouseX, int mouseY) {
        this.hover = mouseX >= this.x && mouseX <= this.x + 102 && mouseY >= this.y && mouseY <= this.y + 31;
    }

    public boolean mouseClicked(int mouseX, int mouseY, int state) {
        this.update(mouseX, mouseY);
        return this.hover;
    }

    public int display(int mouseX, int mouseY) {
        this.update(mouseX, mouseY);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(GuiPackEditor.BACKGROUND_TEXTURE);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int textureY = this.selected ? 62 : (this.hover ? 31 : 0);
        Draw.texturedModalRect(this.x - 1, this.y - (this.selected ? 1 : 0), 0, textureY, 102, 31);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(this.thumbnailLocation);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Draw.texturedRectangle(this.x + 2, this.y + 2, 25, 25, 0.0f, 0.0f, 0.78125f, 0.78125f);
        this.fontRenderer.func_175063_a(this.fontRenderer.func_78269_a(this.displayName, 70), (float)(this.x + 32), (float)(this.y + 1), 0xFFFFFF);
        Draw.rectangle_xgradient((float)(this.x + 101 - 40), (float)(this.y + 1), 39.0f, 9.0f, 0x4E4E4E, -11645362);
        if (this.applied) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(GuiPackEditor.BACKGROUND_TEXTURE);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Draw.texturedModalRect(this.x + 1, this.y + 1, 45, 117, 27, 27);
        }
        return 33;
    }

    public GuiPackEntry setApplied(boolean value) {
        this.applied = value;
        return this;
    }

    public boolean isApplied() {
        return this.applied;
    }
}

