/*
 * Decompiled with CFR 0.152.
 */
package net.gobbob.mobends.client.gui.nodeeditor;

import java.util.ArrayList;
import java.util.List;
import net.gobbob.mobends.client.gui.GuiBendsMenu;
import net.gobbob.mobends.client.gui.elements.GuiAddButton;
import net.gobbob.mobends.client.gui.nodeeditor.GuiAnimationNode;
import net.gobbob.mobends.client.gui.nodeeditor.GuiNodeEditor;
import net.gobbob.mobends.pack.BendsCondition;
import net.gobbob.mobends.pack.BendsTarget;
import net.gobbob.mobends.util.Draw;
import net.minecraft.client.Minecraft;

public class GuiAnimationSection {
    private List<GuiAnimationNode> nodes = new ArrayList<GuiAnimationNode>();
    private String animationName;
    private GuiAddButton buttonAddNode;
    private int height = 0;
    private int width;
    public boolean hover;
    private boolean selected = false;
    private GuiNodeEditor nodeEditor;
    public static final int HEADER_HEIGHT = 15;
    public static final int MARGIN_HEIGHT = 17;

    public GuiAnimationSection(GuiNodeEditor nodeEditor, String animationName) {
        this.setAnimationName(animationName);
        this.buttonAddNode = new GuiAddButton();
        this.nodeEditor = nodeEditor;
    }

    public void updatePositions(int x, int y) {
        this.buttonAddNode.setPosition(x + 16, y + this.height - 17);
    }

    public int display(int x, int y, int mouseX, int mouseY) {
        this.hover = mouseX >= x && mouseX < x + this.getVisualWidth() && mouseY >= y && mouseY < y + 15;
        Minecraft.func_71410_x().func_110434_K().func_110577_a(GuiBendsMenu.ICONS_TEXTURE);
        int textureX = this.selected ? 14 : (this.hover ? 7 : 0);
        Draw.texturedModalRect(x, y, textureX, 0, 3, 16);
        Draw.texturedModalRect(x + 3, y, this.width, 16, textureX + 3, 0, 1, 16);
        Draw.texturedModalRect(x + 3 + this.width, y, textureX + 4, 0, 3, 16);
        Minecraft.func_71410_x().field_71466_p.func_175063_a(this.getAnimationName(), (float)(x + 5), (float)(y + 3), 0xFFFFFF);
        y += 15;
        for (int i = 0; i < this.nodes.size(); ++i) {
            y = this.nodes.get(i).display(x, y);
        }
        this.buttonAddNode.display();
        return y += 17;
    }

    public void addNode(GuiAnimationNode node) {
        this.nodes.add(node);
    }

    public void addDefaultNode() {
        GuiAnimationNode node = new GuiAnimationNode(this);
        node.setModel(this.nodeEditor.getAlterableParts() != null && this.nodeEditor.getAlterableParts().length > 0 ? this.nodeEditor.getAlterableParts()[0] : "");
        this.nodes.add(node);
    }

    public int updateHeight(int x, int y) {
        this.height = 15 + 15 * this.nodes.size() + 17;
        this.updatePositions(x, y);
        return this.height;
    }

    public void setAnimationName(String animationName) {
        this.animationName = animationName;
        this.width = Minecraft.func_71410_x().field_71466_p.func_78256_a(this.animationName) + 7;
    }

    public void populate(BendsCondition condition) {
        for (int i = 0; i < condition.getActionAmount(); ++i) {
            this.addNode(new GuiAnimationNode(this, condition.getAction(i)));
        }
    }

    public boolean mouseClicked(int x, int y, int event) {
        boolean pressed = false;
        this.selected = this.hover;
        if (this.selected) {
            this.getNodeEditor().getParameterEditor().select(this);
        }
        if (this.buttonAddNode.mouseClicked(x, y, event)) {
            this.addDefaultNode();
            this.nodeEditor.updateHeight();
            this.nodeEditor.onChange();
            pressed = true;
        }
        for (int i = 0; i < this.nodes.size(); ++i) {
            if (!this.nodes.get(i).onMousePressed(x, y, event)) continue;
            pressed = true;
        }
        return pressed || this.selected;
    }

    public void mouseReleased(int x, int y, int event) {
        this.buttonAddNode.mouseReleased(x, y, event);
    }

    public void update(int x, int y, int mouseX, int mouseY) {
        for (int i = 0; i < this.nodes.size(); ++i) {
            this.nodes.get(i).update(x, y + 15 + i * 15, mouseX, mouseY);
        }
        this.buttonAddNode.update(mouseX, mouseY);
        this.hover = mouseX >= x && mouseX < x + this.getVisualWidth() && mouseY >= y && mouseY < y + 15;
    }

    public int getVisualWidth() {
        return this.width + 7;
    }

    public int getHeight() {
        return this.height;
    }

    public String getAnimationName() {
        return this.animationName;
    }

    public GuiNodeEditor getNodeEditor() {
        return this.nodeEditor;
    }

    public void applyChanges(BendsTarget target) {
        BendsCondition condition = new BendsCondition(this.animationName);
        target.conditions.put(this.animationName, condition);
        for (int i = 0; i < this.nodes.size(); ++i) {
            this.nodes.get(i).applyChanges(target, condition);
        }
    }

    public void removeNode(GuiAnimationNode guiAnimationNode) {
        this.nodes.remove(guiAnimationNode);
        this.nodeEditor.onChange();
    }

    public void remove() {
        this.nodeEditor.removeSection(this);
    }

    public List<GuiAnimationNode> getNodes() {
        return this.nodes;
    }

    public int getGlobalWidth() {
        int globalWidth = 0;
        for (int i = 0; i < this.nodes.size(); ++i) {
            if (this.nodes.get(i).getGlobalWidth() <= globalWidth) continue;
            globalWidth = this.nodes.get(i).getGlobalWidth();
        }
        return globalWidth;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }
}

