/*
 * Decompiled with CFR 0.152.
 */
package net.gobbob.mobends.client.gui.elements;

import net.gobbob.mobends.client.gui.GuiHelper;
import net.gobbob.mobends.util.Draw;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import org.lwjgl.opengl.GL11;

public class GuiPortraitDisplay {
    private int x;
    private int y;
    private int width = 49;
    private int height = 70;
    private boolean hovered = false;
    private boolean value = false;
    private double rotation = 0.0;
    private float animationValue = 0.0f;
    private EntityLivingBase viewEntity;
    protected long time = System.nanoTime() / 1000L;
    protected long lastTime = System.nanoTime() / 1000L;

    public void initGui(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public void update(int mouseX, int mouseY) {
        this.hovered = mouseX >= this.x && mouseX <= this.x + this.width && mouseY >= this.y && mouseY <= this.y + this.height;
    }

    public void display(float partialTicks) {
        this.time = System.nanoTime() / 1000L;
        float delta = (this.time - this.lastTime) / 1000L;
        this.lastTime = this.time;
        int[] position = GuiHelper.getDeScaledCoords(this.x, this.y + this.height + 1);
        int[] size = GuiHelper.getDeScaledVector(this.width, this.height + 2);
        GL11.glEnable((int)3089);
        GL11.glScissor((int)position[0], (int)position[1], (int)size[0], (int)size[1]);
        this.animationValue = this.hovered ? Math.min(this.animationValue + delta * 0.01f, 1.0f) : Math.max(this.animationValue - delta * 0.01f, 0.0f);
        this.rotation += (double)(delta * 0.02f);
        if (this.hovered) {
            Draw.rectangle(this.x, this.y, this.width, this.height, 0x22FFFFFF);
        }
        Draw.rectangle_ygradient((float)this.x, (float)this.y, (float)this.width, (float)this.height, 0, this.value ? -15645628 : -12316399);
        float smoothAnimation = this.animationValue * this.animationValue * 4.0f;
        if (smoothAnimation >= 1.0f) {
            smoothAnimation = 2.0f - (1.0f - this.animationValue) * (1.0f - this.animationValue) * 4.0f;
        }
        smoothAnimation /= 2.0f;
        if (this.viewEntity != null) {
            float scale = 1.0f - smoothAnimation * 0.2f;
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)(this.x + 25), (float)(this.y + this.height / 2), (float)0.0f);
            GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
            this.renderLivingEntity(0, 24, 24.0f, this.viewEntity);
            GlStateManager.func_179121_F();
        }
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        String displayText = this.value ? "Animated" : "Vanilla";
        fontRenderer.func_78276_b(displayText, this.x + this.width / 2 - fontRenderer.func_78256_a(displayText) / 2, (int)((float)(this.y + this.height) - smoothAnimation * 10.0f), 0xFFFFFF);
        GL11.glDisable((int)3089);
    }

    public void renderLivingEntity(int argX, int argY, float scale, EntityLivingBase entityLivingBase) {
        GL11.glEnable((int)2903);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)argX, (float)argY, (float)50.0f);
        GL11.glScalef((float)(-scale), (float)scale, (float)scale);
        GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glRotated((double)this.rotation, (double)0.0, (double)1.0, (double)0.0);
        float f2 = entityLivingBase.field_70761_aq;
        float f3 = entityLivingBase.field_70177_z;
        float f4 = entityLivingBase.field_70125_A;
        float f5 = entityLivingBase.field_70758_at;
        float f6 = entityLivingBase.field_70759_as;
        GL11.glRotatef((float)135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        RenderHelper.func_74519_b();
        GL11.glRotatef((float)-135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        entityLivingBase.field_70761_aq = 0.0f;
        entityLivingBase.field_70177_z = 0.0f;
        entityLivingBase.field_70125_A = 0.0f;
        entityLivingBase.field_70759_as = entityLivingBase.field_70177_z;
        entityLivingBase.field_70758_at = entityLivingBase.field_70177_z;
        Minecraft.func_71410_x().func_175598_ae().field_78735_i = 180.0f;
        entityLivingBase.field_70701_bs = 1.0f;
        Minecraft.func_71410_x().func_175598_ae().func_188391_a((Entity)entityLivingBase, 0.0, 0.0, 0.0, 0.0f, 1.0f, false);
        entityLivingBase.field_70761_aq = f2;
        entityLivingBase.field_70177_z = f3;
        entityLivingBase.field_70125_A = f4;
        entityLivingBase.field_70758_at = f5;
        entityLivingBase.field_70759_as = f6;
        GL11.glPopMatrix();
        RenderHelper.func_74518_a();
        GlStateManager.func_179101_C();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77476_b);
        GlStateManager.func_179090_x();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
    }

    public boolean mouseClicked(int mouseX, int mouseY, int state) {
        if (this.hovered) {
            this.toggle();
            return true;
        }
        return false;
    }

    public GuiPortraitDisplay setValue(boolean value) {
        this.value = value;
        return this;
    }

    public void toggle() {
        this.value = !this.value;
    }

    public GuiPortraitDisplay setViewEntity(EntityLivingBase viewEntity) {
        this.viewEntity = viewEntity;
        return this;
    }

    public EntityLivingBase getViewEntity() {
        return this.viewEntity;
    }

    public boolean getValue() {
        return this.value;
    }
}

