/*
 * Decompiled with CFR 0.152.
 */
package com.shinoow.acintegration.integrations.minetweaker;

import com.shinoow.abyssalcraft.api.APIUtils;
import com.shinoow.abyssalcraft.api.ritual.NecronomiconCreationRitual;
import com.shinoow.abyssalcraft.api.ritual.NecronomiconRitual;
import com.shinoow.abyssalcraft.api.ritual.RitualRegistry;
import com.shinoow.acintegration.integrations.minetweaker.ACMT;
import com.shinoow.acintegration.integrations.minetweaker.ACMTMisc;
import crafttweaker.IAction;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.abyssalcraft.CreationRitual")
public class CreationRitual {
    @ZenMethod
    public static void addRitual(String unlocalizedName, int bookType, int dimension, float requiredEnergy, boolean requiresSacrifice, IItemStack item, IIngredient ... offerings) {
        CreationRitual.addRitual(unlocalizedName, bookType, dimension, requiredEnergy, requiresSacrifice, item, offerings, false);
    }

    @ZenMethod
    public static void addRitual(String unlocalizedName, int bookType, int dimension, float requiredEnergy, boolean requiresSacrifice, IItemStack item, IIngredient[] offerings, boolean nbt) {
        Object[] offers = ACMT.toObjects(offerings);
        NecronomiconCreationRitual ritual = new NecronomiconCreationRitual(unlocalizedName, bookType, dimension, requiredEnergy, requiresSacrifice, ACMT.toStack(item), offers);
        if (nbt) {
            ritual.setNBTSensitive();
        }
        ACMTMisc.TASKS.add(new Add(ritual));
    }

    @ZenMethod
    public static void removeRitual(IItemStack item) {
        ACMTMisc.TASKS.add(new Remove(ACMT.toStack(item)));
    }

    @ZenMethod
    public static void removeAll() {
        ACMTMisc.TASKS.add(new RemoveAll());
    }

    private static class RemoveAll
    implements IAction {
        private RemoveAll() {
        }

        public void apply() {
            RitualRegistry.instance().getRituals().removeIf(r -> r instanceof NecronomiconCreationRitual && r.getClass().getSuperclass() != NecronomiconCreationRitual.class && r.getClass().getSuperclass().getSuperclass() != NecronomiconCreationRitual.class);
        }

        public String describe() {
            return "Removing all Creation Ritual recipes";
        }
    }

    private static class Remove
    implements IAction {
        private final ItemStack item;

        public Remove(ItemStack item) {
            this.item = item;
        }

        public void apply() {
            ArrayList<NecronomiconCreationRitual> temp = new ArrayList<NecronomiconCreationRitual>();
            for (NecronomiconRitual necronomiconRitual : RitualRegistry.instance().getRituals()) {
                if (!(necronomiconRitual instanceof NecronomiconCreationRitual) || necronomiconRitual.getClass().getSuperclass() == NecronomiconCreationRitual.class || necronomiconRitual.getClass().getSuperclass().getSuperclass() == NecronomiconCreationRitual.class) continue;
                temp.add((NecronomiconCreationRitual)necronomiconRitual);
            }
            for (NecronomiconCreationRitual necronomiconCreationRitual : temp) {
                if (!APIUtils.areStacksEqual((ItemStack)this.item, (ItemStack)necronomiconCreationRitual.getItem())) continue;
                RitualRegistry.instance().getRituals().remove(necronomiconCreationRitual);
            }
        }

        public String describe() {
            return "Removing Necronomicon Creation Ritual for " + ACMT.getItemNameSafely(this.item);
        }
    }

    private static class Add
    implements IAction {
        private final NecronomiconCreationRitual ritual;

        public Add(NecronomiconCreationRitual ritual) {
            this.ritual = ritual;
        }

        public void apply() {
            RitualRegistry.instance().registerRitual((NecronomiconRitual)this.ritual);
        }

        public String describe() {
            return "Adding Necronomicon Creation Ritual for " + ACMT.getItemNameSafely(this.ritual.getItem());
        }
    }
}

