/*
 * Decompiled with CFR 0.152.
 */
package com.shinoow.acintegration.command;

import com.shinoow.abyssalcraft.api.APIUtils;
import com.shinoow.abyssalcraft.api.ritual.NecronomiconCreationRitual;
import com.shinoow.abyssalcraft.api.ritual.NecronomiconEnchantmentRitual;
import com.shinoow.abyssalcraft.api.ritual.NecronomiconPotionAoERitual;
import com.shinoow.abyssalcraft.api.ritual.NecronomiconPotionRitual;
import com.shinoow.abyssalcraft.api.ritual.NecronomiconRitual;
import com.shinoow.abyssalcraft.api.ritual.NecronomiconSummonRitual;
import com.shinoow.abyssalcraft.api.ritual.RitualRegistry;
import com.shinoow.abyssalcraft.lib.util.IHiddenRitual;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;

public class RitualCommand
extends CommandBase {
    public String func_71517_b() {
        return "acritual";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/acritual chat | file";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length != 1) {
            sender.func_145747_a((ITextComponent)new TextComponentString(this.func_71518_a(sender)));
            return;
        }
        if (args[0].equals("chat")) {
            StringBuilder sb = new StringBuilder();
            List rituals = RitualRegistry.instance().getRituals();
            int i = 0;
            while (true) {
                if (i >= rituals.size()) {
                    sender.func_145747_a((ITextComponent)new TextComponentString(sb.toString()));
                    return;
                }
                if (!(rituals.get(i) instanceof IHiddenRitual)) {
                    sb.append(((NecronomiconRitual)rituals.get(i)).getUnlocalizedName().substring(10));
                    if (i != rituals.size() - 1) {
                        sb.append(" | ");
                    }
                }
                ++i;
            }
        }
        if (!args[0].equals("file")) {
            sender.func_145747_a((ITextComponent)new TextComponentString(this.func_71518_a(sender)));
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("#######################################################");
        sb.append("\n#               AbyssalCraft Integration              #");
        sb.append("\n#-----------------------------------------------------#");
        sb.append("\n# Ritual list dump (with extra information)            #");
        sb.append("\n########################################################");
        sb.append("\n");
        sb.append("\n");
        sb.append("\n");
        sb.append("\nClass | Unlocalized Name | Name | Book Type | Dimension | PE | Sacrifice | Item Sacrifice | NBT Sensitive | Input | Output");
        sb.append("\n--------------------------------------------------------------------------------------------------------------------------");
        sb.append("\n");
        for (NecronomiconRitual r : RitualRegistry.instance().getRituals()) {
            sb.append(this.getRitualData(r));
        }
        try {
            File f = new File(Minecraft.func_71410_x().field_71412_D, "acritual.txt");
            if (!f.exists()) {
                f.createNewFile();
            }
            FileWriter fw = new FileWriter(f.getAbsoluteFile());
            BufferedWriter bw = new BufferedWriter(fw);
            bw.write(sb.toString());
            bw.close();
            sender.func_145747_a((ITextComponent)new TextComponentString("Done!"));
            return;
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
    }

    private String getRitualData(NecronomiconRitual ritual) {
        if (ritual instanceof IHiddenRitual) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("\n");
        sb.append(ritual.getClass().getSimpleName());
        sb.append(" | ");
        sb.append(ritual.getUnlocalizedName().substring(10));
        sb.append(" | ");
        sb.append(ritual.getLocalizedName());
        sb.append(" | ");
        sb.append(ritual.getBookType());
        sb.append(" | ");
        sb.append(ritual.getDimension());
        sb.append(" | ");
        sb.append(ritual.getReqEnergy());
        sb.append(" | ");
        sb.append(ritual.requiresSacrifice());
        sb.append(" | ");
        sb.append(ritual.requiresItemSacrifice());
        sb.append(" | ");
        sb.append(ritual.isNBTSensitive());
        sb.append(" | ");
        sb.append(ritual.getSacrifice() != null ? this.getStackName(APIUtils.convertToStack((Object)ritual.getSacrifice())) : "None");
        sb.append(" | ");
        sb.append(this.getOutput(ritual));
        sb.append("\n");
        return sb.toString();
    }

    private String getOutput(NecronomiconRitual ritual) {
        if (ritual instanceof NecronomiconCreationRitual) {
            return this.getStackName(((NecronomiconCreationRitual)ritual).getItem());
        }
        if (ritual instanceof NecronomiconEnchantmentRitual) {
            return ((NecronomiconEnchantmentRitual)ritual).getEnchantment().field_76302_b.func_77320_a();
        }
        if (ritual instanceof NecronomiconPotionAoERitual) {
            return ((NecronomiconPotionAoERitual)ritual).getPotionEffect().func_76393_a();
        }
        if (ritual instanceof NecronomiconPotionRitual) {
            return ((NecronomiconPotionRitual)ritual).getPotionEffect().func_76393_a();
        }
        if (ritual instanceof NecronomiconSummonRitual) {
            return ((NecronomiconSummonRitual)ritual).getEntity().getSimpleName();
        }
        return "Unknown";
    }

    private String getStackName(ItemStack stack) {
        return stack.func_190916_E() + "x" + stack.func_77973_b().getRegistryName().toString() + "@" + stack.func_77952_i();
    }
}

