/*
 * Decompiled with CFR 0.152.
 */
package mcjty.xnet.compat.rftoolscontrol;

import java.util.function.Function;
import javax.annotation.Nullable;
import mcjty.rftoolscontrol.api.code.IOpcodeRunnable;
import mcjty.rftoolscontrol.api.code.Opcode;
import mcjty.rftoolscontrol.api.code.OpcodeOutput;
import mcjty.rftoolscontrol.api.parameters.BlockSide;
import mcjty.rftoolscontrol.api.parameters.ParameterDescription;
import mcjty.rftoolscontrol.api.parameters.ParameterType;
import mcjty.rftoolscontrol.api.registry.IOpcodeRegistry;
import mcjty.xnet.blocks.controller.TileEntityController;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.text.TextFormatting;

public class RFToolsControlSupport {
    public static final Opcode DO_CHANNEL = Opcode.builder().id("xnet:channel").description(new String[]{TextFormatting.GREEN + "Operation: channel (XNet)", "turn on or off an XNet channel"}).opcodeOutput(OpcodeOutput.SINGLE).parameter(ParameterDescription.builder().name("controller").type(ParameterType.PAR_SIDE).description(new String[]{"XNet controller adjacent to (networked) block"}).build()).parameter(ParameterDescription.builder().name("channel").type(ParameterType.PAR_INTEGER).description(new String[]{"Channel number (starting at 0)"}).build()).parameter(ParameterDescription.builder().name("enabled").type(ParameterType.PAR_BOOLEAN).description(new String[]{"Enable or disable"}).build()).icon(0, 5, "xnet:textures/gui/guielements.png").runnable((processor, program, opcode) -> {
        BlockSide inv = processor.evaluateSideParameterNonNull(opcode, program, 0);
        int channel = processor.evaluateIntParameter(opcode, program, 1);
        if (channel < 0 || channel > 7) {
            processor.log("Wrong channel!");
            return IOpcodeRunnable.OpcodeResult.POSITIVE;
        }
        boolean enable = processor.evaluateBoolParameter(opcode, program, 2);
        TileEntity te = processor.getTileEntityAt(inv);
        if (te instanceof TileEntityController) {
            TileEntityController controller = (TileEntityController)te;
            controller.getChannels()[channel].setEnabled(enable);
            controller.markAsDirty();
        }
        return IOpcodeRunnable.OpcodeResult.POSITIVE;
    }).build();
    public static final Opcode TEST_COLOR = Opcode.builder().id("xnet:read_color").description(new String[]{TextFormatting.GREEN + "Test: color (XNet)", "test if a certain color is enabled in", "an XNet controller"}).opcodeOutput(OpcodeOutput.YESNO).parameter(ParameterDescription.builder().name("controller").type(ParameterType.PAR_SIDE).description(new String[]{"XNet controller adjacent to (networked) block"}).build()).parameter(ParameterDescription.builder().name("mask").type(ParameterType.PAR_INTEGER).description(new String[]{"Color mask (bit combination of colors)"}).build()).icon(1, 5, "xnet:textures/gui/guielements.png").runnable((processor, program, opcode) -> {
        BlockSide inv = processor.evaluateSideParameterNonNull(opcode, program, 0);
        int mask = processor.evaluateIntParameter(opcode, program, 1);
        TileEntity te = processor.getTileEntityAt(inv);
        if (te instanceof TileEntityController) {
            TileEntityController controller = (TileEntityController)te;
            return controller.matchColor(mask) ? IOpcodeRunnable.OpcodeResult.POSITIVE : IOpcodeRunnable.OpcodeResult.NEGATIVE;
        }
        return IOpcodeRunnable.OpcodeResult.NEGATIVE;
    }).build();

    public static class GetOpcodeRegistry
    implements Function<IOpcodeRegistry, Void> {
        @Override
        @Nullable
        public Void apply(IOpcodeRegistry registry) {
            registry.register(DO_CHANNEL);
            registry.register(TEST_COLOR);
            return null;
        }
    }
}

