/*
 * Decompiled with CFR 0.152.
 */
package mcjty.xnet.apiimpl.items;

import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import mcjty.lib.varia.ItemStackList;
import mcjty.xnet.compat.ForestrySupport;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class ItemFilterCache {
    private boolean matchDamage = true;
    private boolean oredictMode = false;
    private boolean blacklistMode = true;
    private boolean nbtMode = false;
    private ItemStackList stacks;
    private Set<Integer> oredictMatches = new HashSet<Integer>();

    public ItemFilterCache(boolean matchDamage, boolean oredictMode, boolean blacklistMode, boolean nbtMode, @Nonnull ItemStackList stacks) {
        this.matchDamage = matchDamage;
        this.oredictMode = oredictMode;
        this.blacklistMode = blacklistMode;
        this.nbtMode = nbtMode;
        this.stacks = stacks;
        for (ItemStack s : stacks) {
            for (int id : OreDictionary.getOreIDs((ItemStack)s)) {
                this.oredictMatches.add(id);
            }
        }
    }

    public boolean match(ItemStack stack) {
        if (!stack.func_190926_b()) {
            boolean match = false;
            if (this.oredictMode) {
                int[] oreIDs = OreDictionary.getOreIDs((ItemStack)stack);
                if (oreIDs.length == 0) {
                    match = this.itemMatches(stack);
                } else {
                    for (int id : oreIDs) {
                        if (!this.oredictMatches.contains(id)) continue;
                        match = true;
                        break;
                    }
                }
            } else {
                match = this.itemMatches(stack);
            }
            return match != this.blacklistMode;
        }
        return false;
    }

    private boolean itemMatches(ItemStack stack) {
        if (this.stacks != null) {
            int forestryFlags = ForestrySupport.Tag.GEN.getFlag() | ForestrySupport.Tag.IS_ANALYZED.getFlag();
            ItemStack cleanedStack = null;
            if (this.nbtMode && ForestrySupport.isLoaded() && ForestrySupport.isBreedable(stack)) {
                cleanedStack = ForestrySupport.sanitize(stack, forestryFlags);
            }
            for (ItemStack itemStack : this.stacks) {
                ItemStack cleanedItemStack;
                if (this.matchDamage && itemStack.func_77960_j() != stack.func_77960_j() || this.nbtMode && (cleanedStack == null || !ForestrySupport.isBreedable(itemStack) ? !ItemStack.func_77970_a((ItemStack)itemStack, (ItemStack)stack) : !ItemStack.func_77970_a((ItemStack)(cleanedItemStack = ForestrySupport.sanitize(itemStack, forestryFlags)), (ItemStack)cleanedStack)) || !itemStack.func_77973_b().equals(stack.func_77973_b())) continue;
                return true;
            }
        }
        return false;
    }
}

