/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.ynot.traits;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import mcjty.lib.varia.WorldTools;
import mcjty.xnet.api.channels.IChannelSettings;
import mcjty.xnet.api.channels.IControllerContext;
import mcjty.xnet.api.helper.AbstractConnectorSettings;
import mcjty.xnet.api.helper.DefaultChannelSettings;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import pl.asie.ynot.traits.Trait;

public abstract class TraitedChannelSettings
extends DefaultChannelSettings
implements IChannelSettings {
    private final List<Trait> traits = new ArrayList<Trait>();

    protected final List<Trait> getTraits() {
        return this.traits;
    }

    protected void register(Trait trait) {
        this.traits.add(trait);
    }

    public void readFromNBT(NBTTagCompound tag) {
        for (Trait t : this.getTraits()) {
            t.readFromNBT(tag);
        }
    }

    public void writeToNBT(NBTTagCompound tag) {
        for (Trait t : this.getTraits()) {
            t.writeToNBT(tag);
        }
    }

    public void update(Map<String, Object> data) {
        for (Trait t : this.getTraits()) {
            t.update(data);
        }
    }

    protected boolean shouldCheck(IControllerContext context, BlockPos pos, BlockPos extractorPos, AbstractConnectorSettings settings) {
        World world = context.getControllerWorld();
        if (!WorldTools.chunkLoaded((World)world, (BlockPos)pos)) {
            return false;
        }
        if (this.checkRedstone(world, settings, extractorPos)) {
            return false;
        }
        return context.matchColor(settings.getColorsMask());
    }
}

