/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.ynot.mekanism;

import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.xnet.api.gui.IEditorGui;
import mcjty.xnet.api.gui.IndicatorIcon;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.IGasItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import pl.asie.ynot.YNot;
import pl.asie.ynot.enums.InsertionMode;
import pl.asie.ynot.traits.TraitEnum;
import pl.asie.ynot.traits.TraitFilterStack;
import pl.asie.ynot.traits.TraitInteger;
import pl.asie.ynot.traits.TraitIntegerChoices;
import pl.asie.ynot.traits.TraitedConnectorSettings;

public class GasConnectorSettings
extends TraitedConnectorSettings {
    private static final int[] SPEEDS_NORMAL = new int[]{20, 60, 100, 200};
    private static final int[] SPEEDS_ADVANCED = new int[]{10, 20, 60, 100, 200};
    protected TraitEnum<InsertionMode> insertionMode;
    protected TraitFilterStack filterStack;
    protected TraitInteger priority;
    protected TraitInteger rate;
    protected TraitIntegerChoices speeds;
    private static final Set<String> INSERT_TAGS = ImmutableSet.of((Object)"mode", (Object)"filter", (Object)"priority", (Object)"rate", (Object)"rs", (Object)"color0", (Object[])new String[]{"color1", "color2", "color3"});
    private static final Set<String> EXTRACT_TAGS = ImmutableSet.of((Object)"mode", (Object)"filter", (Object)"priority", (Object)"rate", (Object)"speed", (Object)"rs", (Object[])new String[]{"color0", "color1", "color2", "color3"});

    public GasConnectorSettings(@Nonnull EnumFacing side) {
        super(side);
        this.advanced = true;
        this.insertionMode = new TraitEnum<InsertionMode>("mode", InsertionMode.class, InsertionMode.INS);
        this.register(this.insertionMode);
        this.filterStack = new TraitFilterStack("filter");
        this.register(this.filterStack);
        this.priority = new TraitInteger("priority", 0);
        this.register(this.priority);
        this.rate = new TraitInteger("rate", null){

            @Override
            public void update(Map<String, Object> data) {
                int maxRate;
                super.update(data);
                int n = maxRate = GasConnectorSettings.this.advanced ? YNot.maxGasRateAdvanced : YNot.maxGasRateNormal;
                if (this.val != null && this.val > maxRate) {
                    this.val = maxRate;
                }
            }
        };
        this.register(this.rate);
        this.speeds = new TraitIntegerChoices("speed", SPEEDS_ADVANCED);
        this.register(this.speeds);
    }

    public int getRate() {
        return this.rate.get() != null ? this.rate.get() : YNot.maxGasRateNormal;
    }

    private void updateTraits() {
        this.speeds.setChoices(this.advanced ? SPEEDS_ADVANCED : SPEEDS_NORMAL);
    }

    @Nullable
    public GasStack getFilter() {
        ItemStack filter = this.filterStack.get();
        if (filter.func_77973_b() instanceof IGasItem) {
            IGasItem item = (IGasItem)filter.func_77973_b();
            return item.getGas(filter);
        }
        return null;
    }

    @Nullable
    public IndicatorIcon getIndicatorIcon() {
        switch ((InsertionMode)((Object)this.insertionMode.get())) {
            case INS: {
                return new IndicatorIcon(iconXnetGuiElements, 0, 70, 13, 10);
            }
        }
        return new IndicatorIcon(iconXnetGuiElements, 13, 70, 13, 10);
    }

    @Nullable
    public String getIndicator() {
        return null;
    }

    public boolean isEnabled(String tag) {
        if (tag.equals("facing")) {
            return this.insertionMode.get() == InsertionMode.INS && this.advanced;
        }
        switch ((InsertionMode)((Object)this.insertionMode.get())) {
            case INS: {
                return INSERT_TAGS.contains(tag);
            }
        }
        return EXTRACT_TAGS.contains(tag);
    }

    public void createGui(IEditorGui gui) {
        this.advanced = gui.isAdvanced();
        this.updateTraits();
        int maxRate = this.advanced ? YNot.maxGasRateAdvanced : YNot.maxGasRateNormal;
        this.sideGui(gui);
        this.colorsGui(gui);
        this.redstoneGui(gui);
        gui.nl();
        this.insertionMode.apply("Insert or extract mode", gui);
        this.speeds.apply("Number of ticks for each operation", gui);
        gui.nl().label("PRI");
        this.priority.apply("Insertion priority", gui);
        gui.nl().label("Rate");
        this.rate.apply((this.insertionMode.get() == InsertionMode.EXT ? "Gas extraction rate" : "Gas insertion rate") + "|(max " + maxRate + ")", gui);
        gui.nl().label("Filter");
        this.filterStack.apply("Filter stack", gui);
    }
}

