/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.compat.thermalexpansion;

import cofh.thermalexpansion.util.managers.machine.InsolatorManager;
import com.blamejared.ModTweaker;
import com.blamejared.mtlib.helpers.InputHelper;
import com.blamejared.mtlib.helpers.LogHelper;
import com.blamejared.mtlib.utils.BaseAction;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ModOnly;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IItemStack;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.thermalexpansion.Insolator")
@ModOnly(value="thermalexpansion")
@ZenRegister
public class Insolator {
    @ZenMethod
    public static void addRecipe(IItemStack primaryOutput, IItemStack primaryInput, IItemStack secondaryInput, int energy, @Optional IItemStack secondaryOutput, @Optional int secondaryChance, @Optional(valueLong=-1L) int water) {
        ModTweaker.LATE_ADDITIONS.add((IAction)new Add(InputHelper.toStack((IItemStack)primaryOutput), InputHelper.toStack((IItemStack)primaryInput), InputHelper.toStack((IItemStack)secondaryInput), energy, InputHelper.toStack((IItemStack)secondaryOutput), secondaryChance, water, false));
    }

    @ZenMethod
    public static void addRecipeSaplingInfuser(IItemStack primaryOutput, IItemStack primaryInput, IItemStack secondaryInput, int energy, @Optional IItemStack secondaryOutput, @Optional int secondaryChance, @Optional(valueLong=-1L) int water) {
        ModTweaker.LATE_ADDITIONS.add((IAction)new Add(InputHelper.toStack((IItemStack)primaryOutput), InputHelper.toStack((IItemStack)primaryInput), InputHelper.toStack((IItemStack)secondaryInput), energy, InputHelper.toStack((IItemStack)secondaryOutput), secondaryChance, water, true));
    }

    @ZenMethod
    public static void removeRecipe(IItemStack primaryInput, IItemStack secondaryInput) {
        ModTweaker.LATE_REMOVALS.add((IAction)new Remove(InputHelper.toStack((IItemStack)primaryInput), InputHelper.toStack((IItemStack)secondaryInput)));
    }

    private static class Remove
    extends BaseAction {
        private ItemStack primaryInput;
        private ItemStack secondaryInput;

        public Remove(ItemStack primaryInput, ItemStack secondaryInput) {
            super("PhytogenicInsolator");
            this.primaryInput = primaryInput;
            this.secondaryInput = secondaryInput;
        }

        public void apply() {
            if (!InsolatorManager.recipeExists((ItemStack)this.primaryInput, (ItemStack)this.secondaryInput)) {
                CraftTweakerAPI.logError((String)("No Insolator recipe exists for: " + this.primaryInput + " and " + this.secondaryInput));
                return;
            }
            InsolatorManager.removeRecipe((ItemStack)this.primaryInput, (ItemStack)this.secondaryInput);
        }

        protected String getRecipeInfo() {
            return LogHelper.getStackDescription((Object)this.primaryInput) + " and " + LogHelper.getStackDescription((Object)this.secondaryInput);
        }
    }

    private static class Add
    extends BaseAction {
        private final ItemStack primaryOutput;
        private final ItemStack primaryInput;
        private final ItemStack secondaryInput;
        private final ItemStack secondaryOutput;
        private final int energy;
        private final int secondaryChance;
        private final int water;
        private final boolean isSapling;

        public Add(ItemStack primaryOutput, ItemStack primaryInput, ItemStack secondaryInput, int energy, ItemStack secondaryOutput, int secondaryChance, int water, boolean isSapling) {
            super("PhytogenicInsolator");
            this.primaryOutput = primaryOutput;
            this.primaryInput = primaryInput;
            this.secondaryInput = secondaryInput;
            this.secondaryOutput = secondaryOutput;
            this.energy = energy;
            this.water = water;
            this.isSapling = isSapling;
            this.secondaryChance = !secondaryOutput.func_190926_b() && secondaryChance <= 0 ? 100 : secondaryChance;
        }

        public void apply() {
            InsolatorManager.Type type;
            InsolatorManager.Type type2 = type = this.isSapling ? InsolatorManager.Type.TREE : InsolatorManager.Type.STANDARD;
            if (this.water == -1) {
                InsolatorManager.addRecipe((int)this.energy, (ItemStack)this.primaryInput, (ItemStack)this.secondaryInput, (ItemStack)this.primaryOutput, (ItemStack)this.secondaryOutput, (int)this.secondaryChance, (InsolatorManager.Type)type);
            } else {
                InsolatorManager.addRecipe((int)this.energy, (int)this.water, (ItemStack)this.primaryInput, (ItemStack)this.secondaryInput, (ItemStack)this.primaryOutput, (ItemStack)this.secondaryOutput, (int)this.secondaryChance, (InsolatorManager.Type)type);
            }
        }

        protected String getRecipeInfo() {
            return LogHelper.getStackDescription((Object)this.primaryOutput);
        }
    }
}

