/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.compat.botania.commands;

import com.blamejared.mtlib.helpers.LogHelper;
import com.blamejared.mtlib.helpers.StringHelper;
import com.google.common.collect.ImmutableList;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.mc1120.commands.CraftTweakerCommand;
import crafttweaker.mc1120.commands.SpecialMessagesChat;
import java.util.Arrays;
import java.util.List;
import net.minecraft.command.ICommandSender;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.recipe.RecipeBrew;
import vazkii.botania.api.recipe.RecipeElvenTrade;
import vazkii.botania.api.recipe.RecipeManaInfusion;
import vazkii.botania.api.recipe.RecipePetals;
import vazkii.botania.api.recipe.RecipePureDaisy;
import vazkii.botania.api.recipe.RecipeRuneAltar;

public class BotaniaLogger
extends CraftTweakerCommand {
    private static final List<String> ARGS = ImmutableList.of((Object)"apothecary", (Object)"brews", (Object)"trades", (Object)"infusions", (Object)"daisy", (Object)"altar");

    public BotaniaLogger() {
        super("botania");
    }

    public void executeCommand(MinecraftServer server, ICommandSender sender, String[] arguments) {
        List<String> args = Arrays.asList(arguments);
        if (args.contains("apothecary")) {
            for (RecipePetals recipe : BotaniaAPI.petalRecipes) {
                CraftTweakerAPI.logCommand((String)"Botania Apothecary Recipes");
                CraftTweakerAPI.logCommand((String)String.format("mods.botania.Apothecary.addRecipe(%s, %s);", LogHelper.getStackDescription((Object)recipe.getOutput()), LogHelper.getListDescription((List)recipe.getInputs())));
            }
        } else if (args.contains("brews")) {
            for (RecipeBrew recipe : BotaniaAPI.brewRecipes) {
                CraftTweakerAPI.logCommand((String)"Botania Brewing Recipes");
                CraftTweakerAPI.logCommand((String)String.format("mods.botania.Brew.addRecipe(%s, \"%s\");", LogHelper.getListDescription((List)recipe.getInputs()), recipe.getBrew().getKey()));
            }
        } else if (args.contains("trades")) {
            for (RecipeElvenTrade recipe : BotaniaAPI.elvenTradeRecipes) {
                CraftTweakerAPI.logCommand((String)"Botania Trading Recipes");
                CraftTweakerAPI.logCommand((String)String.format("mods.botania.ElvenTrade.addRecipe(%s, %s);", LogHelper.getStackDescription((Object)recipe.getOutputs()), LogHelper.getListDescription((List)recipe.getInputs())));
            }
        } else if (args.contains("infusions")) {
            for (RecipeManaInfusion recipe : BotaniaAPI.manaInfusionRecipes) {
                CraftTweakerAPI.logCommand((String)"Botania Infusion Recipes");
                CraftTweakerAPI.logCommand((String)String.format("mods.botania.ManaInfusion.add%s(%s, %s, %d);", recipe.isAlchemy() ? "Alchemy" : (recipe.isConjuration() ? "Conjuration" : "Infusion"), LogHelper.getStackDescription((Object)recipe.getOutput()), LogHelper.getStackDescription((Object)recipe.getInput()), recipe.getManaToConsume()));
            }
        } else if (args.contains("daisy")) {
            for (RecipePureDaisy recipe : BotaniaAPI.pureDaisyRecipes) {
                CraftTweakerAPI.logCommand((String)"Botania Daisy Recipes");
                CraftTweakerAPI.logCommand((String)String.format("mods.botania.PureDaisy.addRecipe(%s, %s);", LogHelper.getStackDescription((Object)recipe.getInput()), LogHelper.getStackDescription((Object)new ItemStack(recipe.getOutputState().func_177230_c(), 1))));
            }
        } else if (args.contains("altar")) {
            for (RecipeRuneAltar recipe : BotaniaAPI.runeAltarRecipes) {
                CraftTweakerAPI.logCommand((String)"Botania Altar Recipes");
                CraftTweakerAPI.logCommand((String)String.format("mods.botania.RuneAltar.addRecipe(%s, %s, %d);", LogHelper.getStackDescription((Object)recipe.getOutput()), LogHelper.getListDescription((List)recipe.getInputs()), recipe.getManaUsage()));
            }
        } else {
            if (sender != null) {
                sender.func_145747_a((ITextComponent)new TextComponentString("Invalid arguments for command. Valid arguments: " + StringHelper.join(ARGS, (String)", ")));
            }
            return;
        }
        if (sender != null) {
            sender.func_145747_a(SpecialMessagesChat.getLinkToCraftTweakerLog((String)"List generated;", (ICommandSender)sender));
        }
    }

    protected void init() {
    }
}

